/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.tiff;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.image.codec.jpeg.JPEGQTable;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Deflater;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFEncodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFField;
import org.apache.batik.ext.awt.image.codec.util.ImageEncodeParam;
import org.apache.batik.ext.awt.image.codec.util.ImageEncoderImpl;
import org.apache.batik.ext.awt.image.codec.util.SeekableOutputStream;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    private static final int TIFF_UNSUPPORTED = -1;
    private static final int TIFF_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TIFF_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TIFF_GRAY = 2;
    private static final int TIFF_PALETTE = 3;
    private static final int TIFF_RGB = 4;
    private static final int TIFF_CMYK = 5;
    private static final int TIFF_YCBCR = 6;
    private static final int TIFF_CIELAB = 7;
    private static final int TIFF_GENERIC = 8;
    private static final int COMP_NONE = 1;
    private static final int COMP_JPEG_TTN2 = 7;
    private static final int COMP_PACKBITS = 32773;
    private static final int COMP_DEFLATE = 32946;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    private static final int TIFF_YCBCR_POSITIONING = 531;
    private static final int TIFF_REF_BLACK_WHITE = 532;
    private static final int EXTRA_SAMPLE_UNSPECIFIED = 0;
    private static final int EXTRA_SAMPLE_ASSOCIATED_ALPHA = 1;
    private static final int EXTRA_SAMPLE_UNASSOCIATED_ALPHA = 2;
    private static final int DEFAULT_ROWS_PER_STRIP = 8;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    public TIFFImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        this.writeFileHeader();
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        Iterator iterator = tIFFEncodeParam.getExtraImages();
        if (iterator != null) {
            boolean bl;
            int n = 8;
            RenderedImage renderedImage2 = renderedImage;
            TIFFEncodeParam tIFFEncodeParam2 = tIFFEncodeParam;
            do {
                n = this.encode(renderedImage2, tIFFEncodeParam2, n, !(bl = iterator.hasNext()));
                if (!bl) continue;
                Object e = iterator.next();
                if (e instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)e;
                    tIFFEncodeParam2 = tIFFEncodeParam;
                    continue;
                }
                if (!(e instanceof Object[])) continue;
                Object[] objectArray = (Object[])e;
                renderedImage2 = (RenderedImage)objectArray[0];
                tIFFEncodeParam2 = (TIFFEncodeParam)objectArray[1];
            } while (bl);
        } else {
            this.encode(renderedImage, tIFFEncodeParam, 8, true);
        }
    }

    private int encode(RenderedImage renderedImage, TIFFEncodeParam tIFFEncodeParam, int n, boolean bl) throws IOException {
        int n2;
        int n3;
        int byteArrayOutputStream;
        int n4;
        int nArray2;
        TIFFField[] tIFFFieldArray;
        Object object;
        Object object2;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        Object object4;
        byte[] byArray;
        byte[] byArray2;
        int n15;
        int n16;
        int n17 = tIFFEncodeParam.getCompression();
        boolean bl2 = tIFFEncodeParam.getWriteTiled();
        int n18 = renderedImage.getMinX();
        int n19 = renderedImage.getMinY();
        int n20 = renderedImage.getWidth();
        int n21 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int[] nArray = sampleModel.getSampleSize();
        for (n16 = 1; n16 < nArray.length; ++n16) {
            if (nArray[n16] == nArray[0]) continue;
            throw new Error("TIFFImageEncoder0");
        }
        n16 = sampleModel.getNumBands();
        if ((nArray[0] == 1 || nArray[0] == 4) && n16 != 1) {
            throw new Error("TIFFImageEncoder1");
        }
        int n22 = sampleModel.getDataType();
        switch (n22) {
            case 0: {
                if (nArray[0] == 1 || nArray[0] != 4 || nArray[0] == 8) break;
                throw new Error("TIFFImageEncoder2");
            }
            case 1: 
            case 2: {
                if (nArray[0] == 16) break;
                throw new Error("TIFFImageEncoder3");
            }
            case 3: 
            case 4: {
                if (nArray[0] == 32) break;
                throw new Error("TIFFImageEncoder4");
            }
            default: {
                throw new Error("TIFFImageEncoder5");
            }
        }
        boolean bl3 = n22 == 2 || n22 == 1;
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null && colorModel instanceof IndexColorModel && n22 != 0) {
            throw new Error("TIFFImageEncoder6");
        }
        IndexColorModel indexColorModel = null;
        int n23 = 0;
        char[] cArray = null;
        int n24 = -1;
        int n25 = 0;
        int n26 = 0;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            n15 = indexColorModel.getMapSize();
            if (nArray[0] == 1 && n16 == 1) {
                if (n15 != 2) {
                    throw new IllegalArgumentException("TIFFImageEncoder7");
                }
                byArray2 = new byte[n15];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n15];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n15];
                indexColorModel.getBlues((byte[])object4);
                n24 = (byArray2[0] & 0xFF) == 0 && (byArray2[1] & 0xFF) == 255 && (byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 255 && (object4[0] & 0xFF) == 0 && (object4[1] & 0xFF) == 255 ? 1 : ((byArray2[0] & 0xFF) == 255 && (byArray2[1] & 0xFF) == 0 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 0 && (object4[0] & 0xFF) == 255 && (object4[1] & 0xFF) == 0 ? 0 : 3);
            } else if (n16 == 1) {
                n24 = 3;
            }
        } else if (colorModel == null) {
            if (nArray[0] == 1 && n16 == 1) {
                n24 = 1;
            } else {
                n24 = 8;
                if (n16 > 1) {
                    n25 = n16 - 1;
                }
            }
        } else {
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 9: {
                    n24 = 5;
                    break;
                }
                case 6: {
                    n24 = 2;
                    break;
                }
                case 1: {
                    n24 = 7;
                    break;
                }
                case 5: {
                    if (n17 == 7 && tIFFEncodeParam.getJPEGCompressRGBToYCbCr()) {
                        n24 = 6;
                        break;
                    }
                    n24 = 4;
                    break;
                }
                case 3: {
                    n24 = 6;
                    break;
                }
                default: {
                    n24 = 8;
                }
            }
            if (n24 == 8) {
                n25 = n16 - 1;
            } else if (n16 > 1) {
                n25 = n16 - colorSpace.getNumComponents();
            }
            if (n25 == 1 && colorModel.hasAlpha()) {
                int n5 = n26 = colorModel.isAlphaPremultiplied() ? 1 : 2;
            }
        }
        if (n24 == -1) {
            throw new Error("TIFFImageEncoder8");
        }
        if (n17 == 7) {
            if (n24 == 3) {
                throw new Error("TIFFImageEncoder11");
            }
            if (nArray[0] != 8 || n24 != 2 && n24 != 4 && n24 != 6) {
                throw new Error("TIFFImageEncoder9");
            }
        }
        n15 = -1;
        switch (n24) {
            case 0: {
                n15 = 0;
                break;
            }
            case 1: {
                n15 = 1;
                break;
            }
            case 2: 
            case 8: {
                n15 = 1;
                break;
            }
            case 3: {
                n15 = 3;
                indexColorModel = (IndexColorModel)colorModel;
                n23 = indexColorModel.getMapSize();
                byArray2 = new byte[n23];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n23];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n23];
                indexColorModel.getBlues((byte[])object4);
                n14 = 0;
                n13 = n23;
                n12 = 2 * n23;
                cArray = new char[n23 * 3];
                for (n11 = 0; n11 < n23; ++n11) {
                    n10 = 0xFF & byArray2[n11];
                    cArray[n14++] = (char)(n10 << 8 | n10);
                    n10 = 0xFF & byArray[n11];
                    cArray[n13++] = (char)(n10 << 8 | n10);
                    n10 = 0xFF & object4[n11];
                    cArray[n12++] = (char)(n10 << 8 | n10);
                }
                n23 *= 3;
                break;
            }
            case 4: {
                n15 = 2;
                break;
            }
            case 5: {
                n15 = 5;
                break;
            }
            case 6: {
                n15 = 6;
                break;
            }
            case 7: {
                n15 = 8;
                break;
            }
            default: {
                throw new Error("TIFFImageEncoder8");
            }
        }
        if (bl2) {
            n9 = tIFFEncodeParam.getTileWidth() > 0 ? tIFFEncodeParam.getTileWidth() : renderedImage.getTileWidth();
            n8 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : renderedImage.getTileHeight();
        } else {
            n9 = n20;
            n8 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : 8;
        }
        object4 = null;
        if (n17 == 7) {
            object4 = tIFFEncodeParam.getJPEGEncodeParam();
            n14 = object4.getHorizontalSubsampling(0);
            n13 = object4.getVerticalSubsampling(0);
            for (n12 = 1; n12 < n16; ++n12) {
                n11 = object4.getHorizontalSubsampling(n12);
                if (n11 > n14) {
                    n14 = n11;
                }
                if ((n10 = object4.getVerticalSubsampling(n12)) <= n13) continue;
                n13 = n10;
            }
            n12 = 8 * n13;
            if ((n8 = (int)((float)n8 / (float)n12 + 0.5f) * n12) < n12) {
                n8 = n12;
            }
            if (bl2 && (n9 = (int)((float)n9 / (float)(n11 = 8 * n14) + 0.5f) * n11) < n11) {
                n9 = n11;
            }
        }
        n14 = bl2 ? (n20 + n9 - 1) / n9 * ((n21 + n8 - 1) / n8) : (int)Math.ceil((double)n21 / (double)n8);
        long[] lArray = new long[n14];
        long l = (long)Math.ceil((double)nArray[0] / 8.0 * (double)n9 * (double)n16);
        long l2 = l * (long)n8;
        for (int i = 0; i < n14; ++i) {
            lArray[i] = l2;
        }
        if (!bl2) {
            long l3 = n21 - n8 * (n14 - 1);
            lArray[n14 - 1] = l3 * l;
        }
        long l4 = l2 * (long)(n14 - 1) + lArray[n14 - 1];
        long[] lArray2 = new long[n14];
        TreeSet<TIFFField> treeSet = new TreeSet<TIFFField>();
        treeSet.add(new TIFFField(256, 4, 1, new long[]{n20}));
        treeSet.add(new TIFFField(257, 4, 1, new long[]{n21}));
        char[] cArray2 = new char[n16];
        for (int i = 0; i < n16; ++i) {
            cArray2[i] = (char)nArray[i];
        }
        treeSet.add(new TIFFField(258, 3, n16, cArray2));
        treeSet.add(new TIFFField(259, 3, 1, new char[]{(char)n17}));
        treeSet.add(new TIFFField(262, 3, 1, new char[]{(char)n15}));
        if (!bl2) {
            treeSet.add(new TIFFField(273, 4, n14, lArray2));
        }
        treeSet.add(new TIFFField(277, 3, 1, new char[]{(char)n16}));
        if (!bl2) {
            treeSet.add(new TIFFField(278, 4, 1, new long[]{n8}));
            treeSet.add(new TIFFField(279, 4, n14, lArray));
        }
        if (cArray != null) {
            treeSet.add(new TIFFField(320, 3, n23, cArray));
        }
        if (bl2) {
            treeSet.add(new TIFFField(322, 4, 1, new long[]{n9}));
            treeSet.add(new TIFFField(323, 4, 1, new long[]{n8}));
            treeSet.add(new TIFFField(324, 4, n14, lArray2));
            treeSet.add(new TIFFField(325, 4, n14, lArray));
        }
        if (n25 > 0) {
            char[] cArray3 = new char[n25];
            for (n7 = 0; n7 < n25; ++n7) {
                cArray3[n7] = (char)n26;
            }
            treeSet.add(new TIFFField(338, 3, n25, cArray3));
        }
        if (n22 != 0) {
            char[] cArray4 = new char[n16];
            cArray4[0] = n22 == 4 ? 3 : (n22 == 1 ? 1 : 2);
            for (n7 = 1; n7 < n16; ++n7) {
                cArray4[n7] = cArray4[0];
            }
            treeSet.add(new TIFFField(339, 3, n16, cArray4));
        }
        JPEGEncodeParam jPEGEncodeParam = null;
        JPEGImageEncoder jPEGImageEncoder = null;
        int n28 = 0;
        if (n17 == 7) {
            n28 = 0;
            switch (n24) {
                case 2: 
                case 3: {
                    n28 = 1;
                    break;
                }
                case 4: {
                    n28 = 2;
                    break;
                }
                case 6: {
                    n28 = 3;
                }
            }
            Raster object3 = renderedImage.getTile(0, 0);
            jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)object3, (int)n28);
            TIFFImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n16);
            jPEGEncodeParam.setImageInfoValid(false);
            jPEGEncodeParam.setTableInfoValid(true);
            object2 = new ByteArrayOutputStream();
            jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)object2, (JPEGEncodeParam)jPEGEncodeParam);
            jPEGImageEncoder.encode(object3);
            object = ((ByteArrayOutputStream)object2).toByteArray();
            treeSet.add(new TIFFField(347, 7, ((Object)object).length, object));
            jPEGImageEncoder = null;
        }
        if (n24 == 6) {
            int n6;
            boolean c = true;
            char c2 = '\u0001';
            if (n17 == 7) {
                char c3 = (char)object4.getHorizontalSubsampling(0);
                c2 = (char)object4.getVerticalSubsampling(0);
                for (int i = 1; i < n16; ++i) {
                    int n27;
                    int n29 = (char)object4.getHorizontalSubsampling(i);
                    if (n29 > n6) {
                        n6 = n29;
                    }
                    if ((n27 = (int)((char)object4.getVerticalSubsampling(i))) <= c2) continue;
                    c2 = (char)n27;
                }
            }
            treeSet.add(new TIFFField(530, 3, 2, new char[]{n6, c2}));
            treeSet.add(new TIFFField(531, 3, 1, new char[]{(char)(n17 == 7 ? 1 : 2)}));
            object = n17 == 7 ? (Object)new long[][]{{0L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}} : (Object)new long[][]{{15L, 1L}, {235L, 1L}, {128L, 1L}, {240L, 1L}, {128L, 1L}, {240L, 1L}};
            treeSet.add(new TIFFField(532, 5, 6, object));
        }
        if ((tIFFFieldArray = tIFFEncodeParam.getExtraFields()) != null) {
            object2 = new ArrayList<Integer>(treeSet.size());
            for (TIFFField tIFFField : treeSet) {
                object2.add(new Integer(tIFFField.getTag()));
            }
            for (TIFFField tIFFField : tIFFFieldArray) {
                Integer n30 = new Integer(tIFFField.getTag());
                if (object2.contains(n30)) continue;
                treeSet.add(tIFFField);
                object2.add(n30);
            }
        }
        int n31 = this.getDirectorySize(treeSet);
        lArray2[0] = n + n31;
        object = null;
        byte[] byArray3 = null;
        File file = null;
        int n32 = 0;
        boolean bl4 = false;
        Deflater deflater = null;
        boolean bl5 = false;
        if (n17 == 1) {
            int n33;
            nArray2 = 0;
            if (nArray[0] == 16 && lArray2[0] % 2L != 0L) {
                nArray2 = 1;
                lArray2[0] = lArray2[0] + 1L;
            } else if (nArray[0] == 32 && lArray2[0] % 4L != 0L) {
                nArray2 = (int)(4L - lArray2[0] % 4L);
                lArray2[0] = lArray2[0] + (long)nArray2;
            }
            for (n33 = 1; n33 < n14; ++n33) {
                lArray2[n33] = lArray2[n33 - 1] + lArray[n33 - 1];
            }
            if (!bl && ((n32 = (int)(lArray2[0] + l4)) & 1) != 0) {
                ++n32;
                bl4 = true;
            }
            this.writeDirectory(n, treeSet, n32);
            if (nArray2 != 0) {
                for (n33 = 0; n33 < nArray2; ++n33) {
                    this.output.write(0);
                }
            }
        } else {
            if (this.output instanceof SeekableOutputStream) {
                ((SeekableOutputStream)this.output).seek(lArray2[0]);
            } else {
                object = this.output;
                try {
                    file = File.createTempFile("jai-SOS-", ".tmp");
                    file.deleteOnExit();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.output = new SeekableOutputStream(randomAccessFile);
                }
                catch (Exception exception) {
                    this.output = new ByteArrayOutputStream((int)l4);
                }
            }
            nArray2 = 0;
            switch (n17) {
                case 32773: {
                    nArray2 = (int)(l2 + (l + 127L) / 128L * (long)n8);
                    break;
                }
                case 7: {
                    nArray2 = 0;
                    if (n24 != 6 || colorModel == null || colorModel.getColorSpace().getType() != 5) break;
                    bl5 = true;
                    break;
                }
                case 32946: {
                    nArray2 = (int)l2;
                    deflater = new Deflater(tIFFEncodeParam.getDeflateLevel());
                    break;
                }
                default: {
                    nArray2 = 0;
                }
            }
            if (nArray2 != 0) {
                byArray3 = new byte[nArray2];
            }
        }
        int[] nArray3 = null;
        float[] fArray = null;
        boolean bl6 = nArray[0] == 1 && sampleModel instanceof MultiPixelPackedSampleModel && n22 == 0 || nArray[0] == 8 && sampleModel instanceof ComponentSampleModel;
        byte[] byArray4 = null;
        if (n17 != 7) {
            if (n22 == 0) {
                byArray4 = new byte[n8 * n9 * n16];
            } else if (bl3) {
                byArray4 = new byte[2 * n8 * n9 * n16];
            } else if (n22 == 3 || n22 == 4) {
                byArray4 = new byte[4 * n8 * n9 * n16];
            }
        }
        int n34 = n19 + n21;
        int n35 = n18 + n20;
        int n36 = 0;
        for (n4 = n19; n4 < n34; n4 += n8) {
            byteArrayOutputStream = bl2 ? n8 : Math.min(n8, n34 - n4);
            n3 = byteArrayOutputStream * n9 * n16;
            block54: for (n2 = n18; n2 < n35; n2 += n9) {
                int n37;
                int n38;
                int n48;
                Raster raster = renderedImage.getData(new Rectangle(n2, n4, n9, byteArrayOutputStream));
                boolean bl7 = false;
                if (n17 != 7) {
                    if (bl6) {
                        if (nArray[0] == 8) {
                            ComponentSampleModel n49 = (ComponentSampleModel)raster.getSampleModel();
                            int[] nArray4 = n49.getBankIndices();
                            int[] nArray5 = n49.getBandOffsets();
                            n48 = n49.getPixelStride();
                            n38 = n49.getScanlineStride();
                            if (n48 != n16 || (long)n38 != l) {
                                bl7 = false;
                            } else {
                                bl7 = true;
                                for (n37 = 0; bl7 && n37 < n16; ++n37) {
                                    if (nArray4[n37] == 0 && nArray5[n37] == n37) continue;
                                    bl7 = false;
                                }
                            }
                        } else {
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            if (multiPixelPackedSampleModel.getNumBands() == 1 && multiPixelPackedSampleModel.getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                                bl7 = true;
                            }
                        }
                    }
                    if (!bl7) {
                        if (n22 == 4) {
                            fArray = raster.getPixels(n2, n4, n9, byteArrayOutputStream, fArray);
                        } else {
                            nArray3 = raster.getPixels(n2, n4, n9, byteArrayOutputStream, nArray3);
                        }
                    }
                }
                int n39 = 0;
                int n40 = 0;
                switch (nArray[0]) {
                    case 1: {
                        int n41;
                        int n42;
                        if (bl7) {
                            byte[] byArray6 = ((DataBufferByte)raster.getDataBuffer()).getData();
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            n37 = multiPixelPackedSampleModel.getScanlineStride();
                            int n51 = multiPixelPackedSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n4 - raster.getSampleModelTranslateY());
                            if (n37 == (int)l) {
                                System.arraycopy(byArray6, n51, byArray4, 0, (int)l * byteArrayOutputStream);
                            } else {
                                n42 = 0;
                                for (n41 = 0; n41 < byteArrayOutputStream; ++n41) {
                                    System.arraycopy(byArray6, n51, byArray4, n42, (int)l);
                                    n51 += n37;
                                    n42 += (int)l;
                                }
                            }
                        } else {
                            int n43 = 0;
                            for (n48 = 0; n48 < byteArrayOutputStream; ++n48) {
                                for (n38 = 0; n38 < n9 / 8; ++n38) {
                                    n39 = nArray3[n43++] << 7 | nArray3[n43++] << 6 | nArray3[n43++] << 5 | nArray3[n43++] << 4 | nArray3[n43++] << 3 | nArray3[n43++] << 2 | nArray3[n43++] << 1 | nArray3[n43++];
                                    byArray4[n40++] = (byte)n39;
                                }
                                if (n9 % 8 <= 0) continue;
                                n39 = 0;
                                for (n38 = 0; n38 < n9 % 8; ++n38) {
                                    n39 |= nArray3[n43++] << 7 - n38;
                                }
                                byArray4[n40++] = (byte)n39;
                            }
                        }
                        if (n17 == 1) {
                            this.output.write(byArray4, 0, byteArrayOutputStream * ((n9 + 7) / 8));
                            continue block54;
                        }
                        if (n17 == 32773) {
                            int l5 = TIFFImageEncoder.compressPackBits(byArray4, byteArrayOutputStream, (int)l, byArray3);
                            lArray[n36++] = l5;
                            this.output.write(byArray3, 0, l5);
                            continue block54;
                        }
                        if (n17 != 32946) continue block54;
                        int n44 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n36++] = n44;
                        this.output.write(byArray3, 0, n44);
                        continue block54;
                    }
                    case 4: {
                        int n45 = 0;
                        for (n48 = 0; n48 < byteArrayOutputStream; ++n48) {
                            for (n38 = 0; n38 < n9 / 2; ++n38) {
                                n39 = nArray3[n45++] << 4 | nArray3[n45++];
                                byArray4[n40++] = (byte)n39;
                            }
                            if ((n9 & 1) != 1) continue;
                            n39 = nArray3[n45++] << 4;
                            byArray4[n40++] = (byte)n39;
                        }
                        if (n17 == 1) {
                            this.output.write(byArray4, 0, byteArrayOutputStream * ((n9 + 1) / 2));
                            continue block54;
                        }
                        if (n17 == 32773) {
                            n48 = TIFFImageEncoder.compressPackBits(byArray4, byteArrayOutputStream, (int)l, byArray3);
                            lArray[n36++] = n48;
                            this.output.write(byArray3, 0, n48);
                            continue block54;
                        }
                        if (n17 != 32946) continue block54;
                        n48 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n36++] = n48;
                        this.output.write(byArray3, 0, n48);
                        continue block54;
                    }
                    case 8: {
                        int n41;
                        int n42;
                        if (n17 != 7) {
                            if (bl7) {
                                byte[] byArray5 = ((DataBufferByte)raster.getDataBuffer()).getData();
                                ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                                n37 = componentSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n4 - raster.getSampleModelTranslateY());
                                int n52 = componentSampleModel.getScanlineStride();
                                if (n52 == (int)l) {
                                    System.arraycopy(byArray5, n37, byArray4, 0, (int)l * byteArrayOutputStream);
                                } else {
                                    n42 = 0;
                                    for (n41 = 0; n41 < byteArrayOutputStream; ++n41) {
                                        System.arraycopy(byArray5, n37, byArray4, n42, (int)l);
                                        n37 += n52;
                                        n42 += (int)l;
                                    }
                                }
                            } else {
                                for (n48 = 0; n48 < n3; ++n48) {
                                    byArray4[n48] = (byte)nArray3[n48];
                                }
                            }
                        }
                        if (n17 == 1) {
                            this.output.write(byArray4, 0, n3);
                            continue block54;
                        }
                        if (n17 == 32773) {
                            n48 = TIFFImageEncoder.compressPackBits(byArray4, byteArrayOutputStream, (int)l, byArray3);
                            lArray[n36++] = n48;
                            this.output.write(byArray3, 0, n48);
                            continue block54;
                        }
                        if (n17 == 7) {
                            long l3 = this.getOffset(this.output);
                            if (jPEGImageEncoder == null || jPEGEncodeParam.getWidth() != raster.getWidth() || jPEGEncodeParam.getHeight() != raster.getHeight()) {
                                jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)raster, (int)n28);
                                TIFFImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n16);
                                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)this.output, (JPEGEncodeParam)jPEGEncodeParam);
                            }
                            if (bl5) {
                                WritableRaster writableRaster = null;
                                if (raster instanceof WritableRaster) {
                                    writableRaster = (WritableRaster)raster;
                                } else {
                                    writableRaster = raster.createCompatibleWritableRaster();
                                    writableRaster.setRect(raster);
                                }
                                if (writableRaster.getMinX() != 0 || writableRaster.getMinY() != 0) {
                                    writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
                                }
                                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
                                jPEGImageEncoder.encode(bufferedImage);
                            } else {
                                jPEGImageEncoder.encode(raster.createTranslatedChild(0, 0));
                            }
                            long l5 = this.getOffset(this.output);
                            lArray[n36++] = (int)(l5 - l3);
                            continue block54;
                        }
                        if (n17 != 32946) continue block54;
                        n48 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n36++] = n48;
                        this.output.write(byArray3, 0, n48);
                        continue block54;
                    }
                    case 16: {
                        n48 = 0;
                        for (n38 = 0; n38 < n3; ++n38) {
                            n37 = nArray3[n38];
                            byArray4[n48++] = (byte)((n37 & 0xFF00) >> 8);
                            byArray4[n48++] = (byte)(n37 & 0xFF);
                        }
                        if (n17 == 1) {
                            this.output.write(byArray4, 0, n3 * 2);
                            continue block54;
                        }
                        if (n17 == 32773) {
                            n38 = TIFFImageEncoder.compressPackBits(byArray4, byteArrayOutputStream, (int)l, byArray3);
                            lArray[n36++] = n38;
                            this.output.write(byArray3, 0, n38);
                            continue block54;
                        }
                        if (n17 != 32946) continue block54;
                        n38 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n36++] = n38;
                        this.output.write(byArray3, 0, n38);
                        continue block54;
                    }
                    case 32: {
                        if (n22 == 3) {
                            n38 = 0;
                            for (n37 = 0; n37 < n3; ++n37) {
                                int n46 = nArray3[n37];
                                byArray4[n38++] = (byte)((n46 & 0xFF000000) >>> 24);
                                byArray4[n38++] = (byte)((n46 & 0xFF0000) >>> 16);
                                byArray4[n38++] = (byte)((n46 & 0xFF00) >>> 8);
                                byArray4[n38++] = (byte)(n46 & 0xFF);
                            }
                        } else {
                            n38 = 0;
                            for (n37 = 0; n37 < n3; ++n37) {
                                int n47 = Float.floatToIntBits(fArray[n37]);
                                byArray4[n38++] = (byte)((n47 & 0xFF000000) >>> 24);
                                byArray4[n38++] = (byte)((n47 & 0xFF0000) >>> 16);
                                byArray4[n38++] = (byte)((n47 & 0xFF00) >>> 8);
                                byArray4[n38++] = (byte)(n47 & 0xFF);
                            }
                        }
                        if (n17 == 1) {
                            this.output.write(byArray4, 0, n3 * 4);
                            continue block54;
                        }
                        if (n17 == 32773) {
                            n38 = TIFFImageEncoder.compressPackBits(byArray4, byteArrayOutputStream, (int)l, byArray3);
                            lArray[n36++] = n38;
                            this.output.write(byArray3, 0, n38);
                            continue block54;
                        }
                        if (n17 != 32946) continue block54;
                        n38 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n36++] = n38;
                        this.output.write(byArray3, 0, n38);
                    }
                }
            }
        }
        if (n17 == 1) {
            if (bl4) {
                this.output.write(0);
            }
        } else {
            n4 = 0;
            for (byteArrayOutputStream = 1; byteArrayOutputStream < n14; ++byteArrayOutputStream) {
                n3 = (int)lArray[byteArrayOutputStream - 1];
                n4 += n3;
                lArray2[byteArrayOutputStream] = lArray2[byteArrayOutputStream - 1] + (long)n3;
            }
            int n48 = n32 = bl ? 0 : n + n31 + (n4 += (int)lArray[n14 - 1]);
            if ((n32 & 1) != 0) {
                ++n32;
                bl4 = true;
            }
            if (object == null) {
                if (bl4) {
                    this.output.write(0);
                }
                SeekableOutputStream seekableOutputStream = (SeekableOutputStream)this.output;
                long l6 = seekableOutputStream.getFilePointer();
                seekableOutputStream.seek(n);
                this.writeDirectory(n, treeSet, n32);
                seekableOutputStream.seek(l6);
            } else if (file != null) {
                int n49;
                FileInputStream fileInputStream = new FileInputStream(file);
                this.output.close();
                this.output = object;
                this.writeDirectory(n, treeSet, n32);
                byte[] byArray6 = new byte[8192];
                for (n2 = 0; n2 < n4 && (n49 = fileInputStream.read(byArray6)) != -1; n2 += n49) {
                    this.output.write(byArray6, 0, n49);
                }
                fileInputStream.close();
                file.delete();
                if (bl4) {
                    this.output.write(0);
                }
            } else if (this.output instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream2 = (ByteArrayOutputStream)this.output;
                this.output = object;
                this.writeDirectory(n, treeSet, n32);
                byteArrayOutputStream2.writeTo(this.output);
                if (bl4) {
                    this.output.write(0);
                }
            } else {
                throw new IllegalStateException();
            }
        }
        return n32;
    }

    private int getDirectorySize(SortedSet sortedSet) {
        int n = sortedSet.size();
        int n2 = 2 + n * 12 + 4;
        for (TIFFField tIFFField : sortedSet) {
            int n3 = tIFFField.getCount() * sizeOfType[tIFFField.getType()];
            if (n3 <= 4) continue;
            n2 += n3;
        }
        return n2;
    }

    private void writeFileHeader() throws IOException {
        this.output.write(77);
        this.output.write(77);
        this.output.write(0);
        this.output.write(42);
        this.writeLong(8L);
    }

    private void writeDirectory(int n, SortedSet sortedSet, int n2) throws IOException {
        int n3 = sortedSet.size();
        long l = n + 12 * n3 + 4 + 2;
        ArrayList<TIFFField> arrayList = new ArrayList<TIFFField>();
        this.writeUnsignedShort(n3);
        for (TIFFField tIFFField : sortedSet) {
            int n4 = tIFFField.getTag();
            this.writeUnsignedShort(n4);
            int n5 = tIFFField.getType();
            this.writeUnsignedShort(n5);
            int n6 = tIFFField.getCount();
            int n7 = TIFFImageEncoder.getValueSize(tIFFField);
            this.writeLong(n5 == 2 ? (long)n7 : (long)n6);
            if (n7 > 4) {
                this.writeLong(l);
                l += (long)n7;
                arrayList.add(tIFFField);
                continue;
            }
            this.writeValuesAsFourBytes(tIFFField);
        }
        this.writeLong(n2);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.writeValues((TIFFField)arrayList.get(i));
        }
    }

    private static int getValueSize(TIFFField tIFFField) {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        int n3 = 0;
        if (n == 2) {
            for (int i = 0; i < n2; ++i) {
                byte[] byArray = tIFFField.getAsString(i).getBytes();
                n3 += byArray.length;
                if (byArray[byArray.length - 1] == 0) continue;
                ++n3;
            }
        } else {
            n3 = n2 * sizeOfType[n];
        }
        return n3;
    }

    private void writeValuesAsFourBytes(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: {
                int n3;
                byte[] byArray = tIFFField.getAsBytes();
                if (n2 > 4) {
                    n2 = 4;
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    this.output.write(byArray[n3]);
                }
                for (n3 = 0; n3 < 4 - n2; ++n3) {
                    this.output.write(0);
                }
                break;
            }
            case 3: {
                int n4;
                char[] cArray = tIFFField.getAsChars();
                if (n2 > 2) {
                    n2 = 2;
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    this.writeUnsignedShort(cArray[n4]);
                }
                for (n4 = 0; n4 < 2 - n2; ++n4) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i]);
                }
                break;
            }
        }
    }

    private void writeValues(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = tIFFField.getAsBytes();
                for (int i = 0; i < n2; ++i) {
                    this.output.write(byArray[i]);
                }
                break;
            }
            case 3: {
                char[] cArray = tIFFField.getAsChars();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(cArray[i]);
                }
                break;
            }
            case 8: {
                short[] sArray = tIFFField.getAsShorts();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(sArray[i]);
                }
                break;
            }
            case 4: 
            case 9: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i]);
                }
                break;
            }
            case 11: {
                float[] fArray = tIFFField.getAsFloats();
                for (int i = 0; i < n2; ++i) {
                    int n3 = Float.floatToIntBits(fArray[i]);
                    this.writeLong(n3);
                }
                break;
            }
            case 12: {
                double[] dArray = tIFFField.getAsDoubles();
                for (int i = 0; i < n2; ++i) {
                    long l = Double.doubleToLongBits(dArray[i]);
                    this.writeLong(l >>> 32);
                    this.writeLong(l & 0xFFFFFFFFL);
                }
                break;
            }
            case 5: 
            case 10: {
                long[][] lArray = tIFFField.getAsRationals();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i][0]);
                    this.writeLong(lArray[i][1]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    byte[] byArray = tIFFField.getAsString(i).getBytes();
                    this.output.write(byArray);
                    if (byArray[byArray.length - 1] == 0) continue;
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new Error("TIFFImageEncoder10");
            }
        }
    }

    private void writeUnsignedShort(int n) throws IOException {
        this.output.write((n & 0xFF00) >>> 8);
        this.output.write(n & 0xFF);
    }

    private void writeLong(long l) throws IOException {
        this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
        this.output.write((int)((l & 0xFF0000L) >>> 16));
        this.output.write((int)((l & 0xFF00L) >>> 8));
        this.output.write((int)(l & 0xFFL));
    }

    private long getOffset(OutputStream outputStream) throws IOException {
        if (outputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)outputStream).size();
        }
        if (outputStream instanceof SeekableOutputStream) {
            return ((SeekableOutputStream)outputStream).getFilePointer();
        }
        throw new IllegalStateException();
    }

    private static int compressPackBits(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            n4 = TIFFImageEncoder.packBits(byArray, n3, n2, byArray2, n4);
            n3 += n2;
        }
        return n4;
    }

    private static int packBits(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2 - 1;
        int n5 = n4 - 1;
        while (n <= n4) {
            int n6;
            byte by = byArray[n];
            for (n6 = 1; n6 < 127 && n < n4 && byArray[n] == byArray[n + 1]; ++n6, ++n) {
            }
            if (n6 > 1) {
                ++n;
                byArray2[n3++] = (byte)(-(n6 - 1));
                byArray2[n3++] = by;
            }
            int n7 = n3;
            for (n6 = 0; n6 < 128 && (n < n4 && byArray[n] != byArray[n + 1] || n < n5 && byArray[n] != byArray[n + 2]); ++n6) {
                byArray2[++n3] = byArray[n++];
            }
            if (n6 > 0) {
                byArray2[n7] = (byte)(n6 - 1);
                ++n3;
            }
            if (n != n4) continue;
            if (n6 > 0 && n6 < 128) {
                int n8 = n7;
                byArray2[n8] = (byte)(byArray2[n8] + 1);
                byArray2[n3++] = byArray[n++];
                continue;
            }
            byArray2[n3++] = 0;
            byArray2[n3++] = byArray[n++];
        }
        return n3;
    }

    private static int deflate(Deflater deflater, byte[] byArray, byte[] byArray2) {
        deflater.setInput(byArray);
        deflater.finish();
        int n = deflater.deflate(byArray2);
        deflater.reset();
        return n;
    }

    private static void modifyEncodeParam(JPEGEncodeParam jPEGEncodeParam, JPEGEncodeParam jPEGEncodeParam2, int n) {
        jPEGEncodeParam2.setDensityUnit(jPEGEncodeParam.getDensityUnit());
        jPEGEncodeParam2.setXDensity(jPEGEncodeParam.getXDensity());
        jPEGEncodeParam2.setYDensity(jPEGEncodeParam.getYDensity());
        jPEGEncodeParam2.setRestartInterval(jPEGEncodeParam.getRestartInterval());
        for (int i = 0; i < 4; ++i) {
            JPEGQTable jPEGQTable = jPEGEncodeParam.getQTable(i);
            if (jPEGQTable == null) continue;
            jPEGEncodeParam2.setQTable(i, jPEGQTable);
        }
    }
}

