/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.parser.UnitProcessor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.XMLImage;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.svg.SVGUserAgent;
import org.apache.fop.util.UnclosableInputStream;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGReader
implements ImageReader {
    protected static Log log = LogFactory.getLog(class$org$apache$fop$image$analyser$SVGReader == null ? (class$org$apache$fop$image$analyser$SVGReader = SVGReader.class$("org.apache.fop.image.analyser.SVGReader")) : class$org$apache$fop$image$analyser$SVGReader);
    public static final String SVG_MIME_TYPE = "image/svg+xml";
    private boolean batik = true;
    static /* synthetic */ Class class$org$apache$fop$image$analyser$SVGReader;

    public FopImage.ImageInfo verifySignature(String uri, InputStream fis, FOUserAgent ua) throws IOException {
        FopImage.ImageInfo info = this.loadImage(uri, fis, ua);
        if (info != null) {
            IOUtils.closeQuietly(fis);
        }
        return info;
    }

    public String getMimeType() {
        return SVG_MIME_TYPE;
    }

    private FopImage.ImageInfo loadImage(String uri, InputStream bis, FOUserAgent ua) {
        if (this.batik) {
            try {
                Loader loader = new Loader();
                return loader.getImage(uri, bis, ua.getSourcePixelUnitToMillimeter());
            }
            catch (NoClassDefFoundError e) {
                this.batik = false;
                log.warn("Batik not in class path", e);
                return null;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Loader {
        Loader() {
        }

        private FopImage.ImageInfo getImage(String uri, InputStream fis, float pixelUnitToMM) {
            try {
                fis = new UnclosableInputStream(fis);
                FopImage.ImageInfo info = new FopImage.ImageInfo();
                info.dpiVertical = info.dpiHorizontal = (double)(25.4f / pixelUnitToMM);
                info.originalURI = uri;
                info.mimeType = SVGReader.this.getMimeType();
                info.str = "http://www.w3.org/2000/svg";
                int length = fis.available();
                fis.mark(length + 1);
                SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLImage.getParserName());
                SVGDocument doc = factory.createSVGDocument(uri, fis);
                info.data = doc;
                SVGSVGElement e = doc.getRootElement();
                SVGUserAgent userAg = new SVGUserAgent(pixelUnitToMM, new AffineTransform());
                BridgeContext ctx = new BridgeContext(userAg);
                UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, e);
                String s = e.getAttributeNS(null, "width");
                if (s.length() == 0) {
                    s = "100%";
                }
                info.width = Math.round(UnitProcessor.svgHorizontalLengthToUserSpace(s, "width", uctx));
                s = e.getAttributeNS(null, "height");
                if (s.length() == 0) {
                    s = "100%";
                }
                info.height = Math.round(UnitProcessor.svgVerticalLengthToUserSpace(s, "height", uctx));
                return info;
            }
            catch (NoClassDefFoundError ncdfe) {
                try {
                    fis.reset();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                SVGReader.this.batik = false;
                log.warn("Batik not in class path", ncdfe);
                return null;
            }
            catch (IOException e) {
                log.debug("Error while trying to load stream as an SVG file: " + e.getMessage());
                try {
                    fis.reset();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return null;
            }
        }
    }
}

