/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field;

import org.fest.reflect.field.FieldType;
import org.fest.reflect.field.FieldTypeRef;
import org.fest.reflect.reference.TypeRef;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldName {
    private final String name;

    public static FieldName beginFieldAccess(String name) {
        FieldName.validateIsNotNullOrEmpty(name);
        return new FieldName(name);
    }

    private static void validateIsNotNullOrEmpty(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the field to access should not be null");
        }
        if (Strings.isEmpty(name)) {
            throw new IllegalArgumentException("The name of the field to access should not be empty");
        }
    }

    private FieldName(String name) {
        this.name = name;
    }

    public <T> FieldType<T> ofType(Class<T> type) {
        return FieldType.newFieldType(this.name, type);
    }

    public <T> FieldTypeRef<T> ofType(TypeRef<T> type) {
        return FieldTypeRef.newFieldTypeRef(this.name, type);
    }
}

