/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Image;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.fest.swing.applet.AppletViewer;
import org.fest.swing.applet.StatusDisplay;
import org.fest.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAppletContext
implements AppletContext {
    private static final Enumeration<Applet> NO_APPLETS = new EmptyAppletEnumeration();
    private final Map<String, InputStream> streamMap = new HashMap<String, InputStream>();
    private final StatusDisplay statusDisplay;

    public BasicAppletContext(StatusDisplay statusDisplay) {
        if (statusDisplay == null) {
            throw new NullPointerException("Instance of StatusDisplay should not be null");
        }
        this.statusDisplay = statusDisplay;
    }

    @Override
    public Applet getApplet(String name) {
        return BasicAppletContext.appletFrom(this.statusDisplay);
    }

    @Override
    public Enumeration<Applet> getApplets() {
        Applet applet = BasicAppletContext.appletFrom(this.statusDisplay);
        if (applet == null) {
            return NO_APPLETS;
        }
        return java.util.Collections.enumeration(Collections.list(applet));
    }

    private static Applet appletFrom(StatusDisplay statusDisplay) {
        if (!(statusDisplay instanceof AppletViewer)) {
            return null;
        }
        AppletViewer viewer = (AppletViewer)statusDisplay;
        return viewer.applet();
    }

    @Override
    public AudioClip getAudioClip(URL url) {
        return null;
    }

    @Override
    public Image getImage(URL url) {
        return null;
    }

    @Override
    public InputStream getStream(String key) {
        return this.streamMap.get(key);
    }

    @Override
    public Iterator<String> getStreamKeys() {
        return this.streamMap.keySet().iterator();
    }

    @Override
    public void setStream(String key, InputStream stream) {
        if (stream == null) {
            this.streamMap.remove(key);
            return;
        }
        this.streamMap.put(key, stream);
    }

    @Override
    public void showDocument(URL url) {
    }

    @Override
    public void showDocument(URL url, String target) {
    }

    @Override
    public void showStatus(String status) {
        this.statusDisplay.showStatus(status);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyAppletEnumeration
    implements Enumeration<Applet> {
        EmptyAppletEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public Applet nextElement() {
            return null;
        }
    }
}

