/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.data;

import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.data.TableCell;
import org.fest.swing.data.TableCellFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Arrays;
import org.fest.util.Objects;
import org.fest.util.Strings;

public class TableCellInRowByValue
implements TableCellFinder {
    private final String[] values;
    private final int column;

    public static TableCellBuilder rowWithValue(String ... values) {
        if (values == null) {
            throw new NullPointerException("The array of values should not be null");
        }
        return new TableCellBuilder(values);
    }

    protected TableCellInRowByValue(String[] values, int column) {
        this.values = values;
        this.column = column;
    }

    @RunsInEDT
    public TableCell findCell(JTable table, JTableCellReader cellReader) {
        int row = TableCellInRowByValue.findRowIndex(table, cellReader, this.values);
        if (row == -1) {
            throw ActionFailedException.actionFailure(Strings.concat("Unable to find a row with values:<", Arrays.format(this.values), ">"));
        }
        return new TableCell(row, this.column);
    }

    @RunsInEDT
    private static int findRowIndex(final JTable table, final JTableCellReader cellReader, final String[] values) {
        return GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                TableCellInRowByValue.validateEqualSize(table, values);
                int rowCount = table.getRowCount();
                for (int row = 0; row < rowCount; ++row) {
                    if (!TableCellInRowByValue.matchingRow(table, cellReader, values, row)) continue;
                    return row;
                }
                return -1;
            }
        });
    }

    @RunsInCurrentThread
    private static void validateEqualSize(JTable table, String[] values) {
        int columnCount = table.getColumnCount();
        if (values.length != columnCount) {
            throw new IllegalStateException(Strings.concat("The array of values should have size:<", columnCount, ">"));
        }
    }

    @RunsInCurrentThread
    private static boolean matchingRow(JTable table, JTableCellReader cellReader, String[] values, int row) {
        int columnCount = table.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            if (Objects.areEqual(cellReader.valueAt(table, row, col), values[col])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Strings.concat(this.getClass().getName(), "[values=", Arrays.format(this.values), ", column=", this.column, "]");
    }

    public static class TableCellBuilder {
        private final String[] values;

        TableCellBuilder(String[] values) {
            this.values = values;
        }

        public TableCellInRowByValue column(int column) {
            return new TableCellInRowByValue(this.values, column);
        }
    }
}

