/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JTreeCellReader;
import org.fest.swing.driver.BasicJTreeCellReader;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.util.Strings;

class JTreePathFinder {
    private static final String SEPARATOR = "/";
    private JTreeCellReader cellReader;
    private String separator;

    JTreePathFinder() {
        this.cellReader(new BasicJTreeCellReader());
        this.separator(SEPARATOR);
    }

    @RunsInCurrentThread
    TreePath findMatchingPath(JTree tree, String path) {
        String[] pathStrings = this.splitPath(path);
        TreeModel model = tree.getModel();
        ArrayList<Object> newPathValues = new ArrayList<Object>(pathStrings.length + 1);
        Object node = model.getRoot();
        int pathElementCount = pathStrings.length;
        for (int stringIndex = 0; stringIndex < pathElementCount; ++stringIndex) {
            String pathString = pathStrings[stringIndex];
            Object match = null;
            if (stringIndex == 0 && tree.isRootVisible()) {
                if (!pathString.equals(this.value(tree, node))) {
                    throw this.pathNotFound(path);
                }
                newPathValues.add(node);
                continue;
            }
            int childCount = model.getChildCount(node);
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                Object child = model.getChild(node, childIndex);
                if (!pathString.equals(this.value(tree, child))) continue;
                if (match != null) {
                    throw this.multipleMatchingNodes(pathString, this.value(tree, node));
                }
                match = child;
            }
            if (match == null) {
                throw this.pathNotFound(path);
            }
            newPathValues.add(match);
            node = match;
        }
        return new TreePath(newPathValues.toArray());
    }

    private LocationUnavailableException pathNotFound(String path) {
        throw new LocationUnavailableException(Strings.concat("Unable to find path ", Strings.quote(path)));
    }

    private String[] splitPath(String path) {
        ArrayList<String> result = new ArrayList<String>();
        int separatorSize = this.separator.length();
        int index = 0;
        int pathSize = path.length();
        while (index < pathSize) {
            int separatorPosition = path.indexOf(this.separator, index);
            if (separatorPosition == -1) {
                separatorPosition = pathSize;
            }
            result.add(path.substring(index, separatorPosition));
            index = separatorPosition + separatorSize;
        }
        return result.toArray(new String[result.size()]);
    }

    private LocationUnavailableException multipleMatchingNodes(String matchingText, Object parentText) {
        throw new LocationUnavailableException(Strings.concat("There is more than one node with value ", Strings.quote(matchingText), " under ", Strings.quote(parentText)));
    }

    private String value(JTree tree, Object modelValue) {
        return this.cellReader.valueAt(tree, modelValue);
    }

    String separator() {
        return this.separator;
    }

    void separator(String newSeparator) {
        this.separator = newSeparator;
    }

    void cellReader(JTreeCellReader newCellReader) {
        this.cellReader = newCellReader;
    }

    JTreeCellReader cellReader() {
        return this.cellReader;
    }
}

