/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JTreeMatchingPathQuery;
import org.fest.swing.driver.JTreePathFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.util.Arrays;
import org.fest.util.Objects;
import org.fest.util.Strings;

final class JTreeVerifySelectionTask {
    @RunsInEDT
    static void verifySelection(final JTree tree, final int[] selection, final Description errMsg) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JTreeVerifySelectionTask.checkSelection(tree, selection, errMsg);
            }
        });
    }

    @RunsInCurrentThread
    private static void checkSelection(JTree tree, int[] selection, Description errMsg) {
        int[] selectionRows = tree.getSelectionRows();
        if (org.fest.swing.util.Arrays.isEmptyIntArray(selectionRows)) {
            JTreeVerifySelectionTask.failNoSelection(errMsg);
        }
        java.util.Arrays.sort(selection);
        if (java.util.Arrays.equals(selectionRows, selection)) {
            return;
        }
        throw JTreeVerifySelectionTask.failNotEqualSelection(errMsg, selection, selectionRows);
    }

    private static AssertionError failNotEqualSelection(Description msg, int[] expected, int[] actual) {
        throw Fail.fail(Strings.concat("[", msg.value(), "] expecting selection:<", Arrays.format(expected), "> but was:<", Arrays.format(actual), ">"));
    }

    @RunsInEDT
    static void verifySelection(final JTree tree, final String[] selection, final JTreePathFinder pathFinder, final Description errMsg) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JTreeVerifySelectionTask.checkSelection(tree, selection, pathFinder, errMsg);
            }
        });
    }

    @RunsInCurrentThread
    private static void checkSelection(JTree tree, String[] selection, JTreePathFinder pathFinder, Description errMsg) {
        int selectionCount;
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (Arrays.isEmpty(selectionPaths)) {
            JTreeVerifySelectionTask.failNoSelection(errMsg);
        }
        if ((selectionCount = selection.length) != selectionPaths.length) {
            throw JTreeVerifySelectionTask.failNotEqualSelection(errMsg, selection, selectionPaths);
        }
        for (int i = 0; i < selectionCount; ++i) {
            TreePath actual;
            TreePath expected = JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, selection[i], pathFinder);
            if (Objects.areEqual(expected, actual = selectionPaths[i])) continue;
            throw JTreeVerifySelectionTask.failNotEqualSelection(errMsg, selection, selectionPaths);
        }
    }

    private static AssertionError failNotEqualSelection(Description msg, String[] expected, TreePath[] actual) {
        throw Fail.fail(Strings.concat("[", msg.value(), "] expecting selection:<", Arrays.format(expected), "> but was:<", Arrays.format(actual), ">"));
    }

    private static void failNoSelection(Description errorMessage) {
        Fail.fail(Strings.concat("[", errorMessage.value(), "] No selection"));
    }

    @RunsInEDT
    static void verifyNoSelection(final JTree tree, final Description errMsg) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                if (tree.getSelectionCount() == 0) {
                    return;
                }
                String message = Strings.concat("[", errMsg.value(), "] expected no selection but was:<", Arrays.format(tree.getSelectionPaths()), ">");
                Fail.fail(message);
            }
        });
    }

    private JTreeVerifySelectionTask() {
    }
}

