/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import javax.swing.JTabbedPane;
import org.fest.swing.format.ComponentFormatterTemplate;
import org.fest.util.Arrays;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTabbedPaneFormatter
extends ComponentFormatterTemplate {
    private static final String NO_SELECTION = "<No selection>";

    @Override
    protected String doFormat(Component c) {
        JTabbedPane tabbedPane = (JTabbedPane)c;
        return Strings.concat(tabbedPane.getClass().getName(), "[", "name=", Strings.quote(tabbedPane.getName()), ", ", "selectedTabIndex=", String.valueOf(tabbedPane.getSelectedIndex()), ", ", "selectedTabTitle=", this.selectedTab(tabbedPane), ", ", "tabCount=", String.valueOf(tabbedPane.getTabCount()), ", ", "tabTitles=", Arrays.format(this.tabTitles(tabbedPane)), ", ", "enabled=", String.valueOf(tabbedPane.isEnabled()), ", ", "visible=", String.valueOf(tabbedPane.isVisible()), ", ", "showing=", String.valueOf(tabbedPane.isShowing()), "]");
    }

    private String selectedTab(JTabbedPane tabbedPane) {
        if (tabbedPane.getTabCount() == 0) {
            return NO_SELECTION;
        }
        int index = tabbedPane.getSelectedIndex();
        if (index == -1) {
            return NO_SELECTION;
        }
        return Strings.quote(tabbedPane.getTitleAt(index));
    }

    private String[] tabTitles(JTabbedPane tabbedPane) {
        int count = tabbedPane.getTabCount();
        if (count == 0) {
            return new String[0];
        }
        String[] titles = new String[count];
        for (int i = 0; i < count; ++i) {
            titles[i] = tabbedPane.getTitleAt(i);
        }
        return titles;
    }

    @Override
    public Class<? extends Component> targetType() {
        return JTabbedPane.class;
    }
}

