/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.keystroke;

import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.fest.swing.keystroke.KeyStrokeMappingProvider;
import org.fest.swing.util.OSFamily;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeyStrokeMappingProviderNames
implements Iterable<String> {
    private final String osFamily;
    private final String language;
    private final String country;

    static KeyStrokeMappingProviderNames generateNamesFrom(OSFamily osFamily, Locale locale) {
        return new KeyStrokeMappingProviderNames(osFamily, locale);
    }

    private KeyStrokeMappingProviderNames(OSFamily osFamily, Locale locale) {
        this.osFamily = osFamily.key();
        this.language = locale.getLanguage();
        this.country = locale.getCountry();
    }

    @Override
    public Iterator<String> iterator() {
        return new NameIterator(this.osFamily, this.language, this.country);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameIterator
    implements Iterator<String> {
        private static final String PREFIX = KeyStrokeMappingProvider.class.getName();
        private static final String DELIMETER = "_";
        private final String osFamily;
        private final String language;
        private final String country;
        private State state;

        NameIterator(String osFamily, String language, String country) {
            this.osFamily = osFamily;
            this.language = language;
            this.country = country;
            this.state = State.FULL_NAME;
        }

        @Override
        public String next() {
            switch (this.state) {
                case FULL_NAME: {
                    this.state = State.WITHOUT_COUNTRY;
                    return Strings.join(PREFIX, this.osFamily, this.language, this.country).with(DELIMETER);
                }
                case WITHOUT_COUNTRY: {
                    this.state = State.LANGUAGE_ONLY;
                    return Strings.join(PREFIX, this.osFamily, this.language).with(DELIMETER);
                }
                case LANGUAGE_ONLY: {
                    this.state = State.END;
                    return Strings.join(PREFIX, this.language).with(DELIMETER);
                }
            }
            throw new NoSuchElementException("There are no more names to generate");
        }

        @Override
        public boolean hasNext() {
            return this.state != State.END;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support 'remove'");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            FULL_NAME,
            WITHOUT_COUNTRY,
            LANGUAGE_ONLY,
            END;

        }
    }
}

