/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.lock;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.fest.swing.exception.ScreenLockException;
import org.fest.util.Strings;

@ThreadSafe
public final class ScreenLock {
    private final Lock lock = new ReentrantLock();
    private final Condition released = this.lock.newCondition();
    @GuardedBy(value="lock")
    private Object owner;
    @GuardedBy(value="lock")
    private boolean acquired;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(Object newOwner) {
        this.lock.lock();
        try {
            if (this.alreadyAcquiredBy(newOwner)) {
                return;
            }
            while (this.acquired) {
                this.released.await();
            }
            this.owner = newOwner;
            this.acquired = true;
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object currentOwner) {
        this.lock.lock();
        try {
            if (!this.acquired) {
                throw new ScreenLockException("No lock to release");
            }
            if (this.owner != currentOwner) {
                throw new ScreenLockException(Strings.concat(currentOwner, " is not the lock owner"));
            }
            this.acquired = false;
            this.owner = null;
            this.released.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquiredBy(Object possibleOwner) {
        this.lock.lock();
        try {
            boolean bl = this.alreadyAcquiredBy(possibleOwner);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean alreadyAcquiredBy(Object possibleOwner) {
        return this.acquired && this.owner == possibleOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquired() {
        this.lock.lock();
        try {
            boolean bl = this.acquired;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static ScreenLock instance() {
        return ScreenLockHolder.instance;
    }

    ScreenLock() {
    }

    private static class ScreenLockHolder {
        static ScreenLock instance = new ScreenLock();

        private ScreenLockHolder() {
        }
    }
}

