/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicCommandPopupMenuUI;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceBorder;

public class SubstanceCommandPopupMenuUI
extends BasicCommandPopupMenuUI {
    public static ComponentUI createUI(JComponent c) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)c);
        return new SubstanceCommandPopupMenuUI();
    }

    protected JPanel createMenuPanel() {
        return new SubstanceMenuPanel();
    }

    protected BasicCommandPopupMenuUI.ScrollableCommandButtonPanel createScrollableButtonPanel() {
        BasicCommandPopupMenuUI.ScrollableCommandButtonPanel result = super.createScrollableButtonPanel();
        result.setBorder((Border)new SubstanceBorder(new Insets(0, 0, 1, 0)));
        return result;
    }

    protected static class SubstanceMenuPanel
    extends BasicCommandPopupMenuUI.MenuPanel {
        protected SubstanceMenuPanel() {
        }

        protected void paintIconGutterSeparator(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            int sepX = this.getSeparatorX();
            g2d.translate(sepX, 0);
            SeparatorPainterUtils.paintSeparator((Component)((Object)this), (Graphics)g2d, (int)2, (int)this.getHeight(), (int)1, (boolean)true, (int)0, (int)0, (boolean)false);
            g2d.dispose();
        }

        protected void paintIconGutterBackground(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
            if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme((Component)((Object)this), (ComponentState)ComponentState.ENABLED);
                Color leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getUltraLightColor() : scheme.getLightColor();
                Color rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getUltraLightColor() : scheme.getLightColor();
                g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)((Object)this), (float)0.7f, (Graphics)g));
                int sepX = this.getSeparatorX();
                if (this.getComponentOrientation().isLeftToRight()) {
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, leftColor, sepX + 2, 0.0f, rightColor);
                    g2d.setPaint(gp);
                    g2d.fillRect(0, 0, sepX, this.getHeight());
                } else {
                    GradientPaint gp = new GradientPaint(sepX, 0.0f, leftColor, this.getWidth(), 0.0f, rightColor);
                    g2d.setPaint(gp);
                    g2d.fillRect(sepX + 2, 0, this.getWidth() - sepX, this.getHeight());
                }
            }
            g2d.dispose();
        }
    }
}

