/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.common.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.EnumSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.internal.ui.common.BasicScrollablePanelUI;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.flamingo.common.TransitionAwareResizableIcon;
import org.pushingpixels.substance.flamingo.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceScrollablePanelUI
extends BasicScrollablePanelUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceScrollablePanelUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics g, JComponent c) {
        if (!c.isShowing()) {
            return;
        }
        JComponent jComponent = c;
        synchronized (jComponent) {
            if (c.isOpaque()) {
                BackgroundPaintingUtils.update((Graphics)g, (Component)c, (boolean)false);
                super.paint(g, c);
            } else {
                super.paint(g, c);
            }
        }
    }

    public JCommandButton createLeadingScroller() {
        final JCommandButton result = super.createLeadingScroller();
        int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)result);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallArrowIconHeight((int)fontSize) + 3;
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        if (arrowIconHeight % 2 == 0) {
            ++arrowIconHeight;
        }
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon((AbstractCommandButton)result, new TransitionAwareResizableIcon.StateTransitionTrackerDelegate(){

            @Override
            public StateTransitionTracker getStateTransitionTracker() {
                return ((ActionPopupTransitionAwareUI)result.getUI()).getActionTransitionTracker();
            }
        }, new TransitionAwareResizableIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme scheme, int width, int height) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)result);
                float arrowStrokeWidth = SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize) - 0.3f;
                if (SubstanceScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
                    --width;
                }
                Icon doubleArrowIcon = SubstanceImageCreator.getDoubleArrowIcon((int)SubstanceSizeUtils.getComponentFontSize((Component)result), (float)width, (float)height, (float)arrowStrokeWidth, (int)(SubstanceScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? 7 : 1), (SubstanceColorScheme)scheme);
                return doubleArrowIcon;
            }
        }, new Dimension(arrowIconHeight, arrowIconWidth));
        result.setIcon((ResizableIcon)arrowIcon);
        result.putClientProperty((Object)"substancelaf.buttonside", this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? EnumSet.of(SubstanceConstants.Side.RIGHT) : EnumSet.of(SubstanceConstants.Side.BOTTOM));
        result.setHorizontalAlignment(0);
        result.setFlat(true);
        return result;
    }

    public JCommandButton createTrailingScroller() {
        final JCommandButton result = super.createTrailingScroller();
        int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)result);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallArrowIconHeight((int)fontSize) + 3;
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        if (arrowIconHeight % 2 == 0) {
            ++arrowIconHeight;
        }
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon((AbstractCommandButton)result, new TransitionAwareResizableIcon.StateTransitionTrackerDelegate(){

            @Override
            public StateTransitionTracker getStateTransitionTracker() {
                return ((ActionPopupTransitionAwareUI)result.getUI()).getActionTransitionTracker();
            }
        }, new TransitionAwareResizableIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme scheme, int width, int height) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)result);
                float arrowStrokeWidth = SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize) - 0.3f;
                if (SubstanceScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
                    --width;
                }
                Icon doubleArrowIcon = SubstanceImageCreator.getDoubleArrowIcon((int)SubstanceSizeUtils.getComponentFontSize((Component)result), (float)width, (float)height, (float)arrowStrokeWidth, (int)(SubstanceScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? 3 : 5), (SubstanceColorScheme)scheme);
                return doubleArrowIcon;
            }
        }, new Dimension(arrowIconHeight, arrowIconWidth));
        result.setIcon((ResizableIcon)arrowIcon);
        result.putClientProperty((Object)"substancelaf.buttonside", this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? EnumSet.of(SubstanceConstants.Side.LEFT) : EnumSet.of(SubstanceConstants.Side.TOP));
        result.setHorizontalAlignment(0);
        result.setFlat(true);
        return result;
    }
}

