/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonRootPane;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.substance.flamingo.ribbon.ui.SubstanceRibbonFrameTitlePane;
import org.pushingpixels.substance.flamingo.ribbon.ui.SubstanceRibbonUI;
import org.pushingpixels.substance.internal.ui.SubstanceRootPaneUI;

public class SubstanceRibbonRootPaneUI
extends SubstanceRootPaneUI {
    protected JRibbonApplicationMenuButton applicationMenuButton;
    protected HierarchyListener substanceRibbonHierarchyListener;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceRibbonRootPaneUI();
    }

    protected void installComponents(JRootPane root) {
        super.installComponents(root);
        this.createAppMenuButton(root);
    }

    protected void installListeners(final JRootPane root) {
        super.installListeners(root);
        this.substanceRibbonHierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SubstanceRibbonRootPaneUI.this.createAppMenuButton(root);
                    }
                });
            }
        };
        root.addHierarchyListener(this.substanceRibbonHierarchyListener);
    }

    protected void uninstallListeners(JRootPane root) {
        root.removeHierarchyListener(this.substanceRibbonHierarchyListener);
        this.substanceRibbonHierarchyListener = null;
        super.uninstallListeners(root);
    }

    protected void uninstallComponents(JRootPane root) {
        root.getLayeredPane().remove((Component)this.applicationMenuButton);
        this.applicationMenuButton = null;
        super.uninstallComponents(root);
    }

    protected LayoutManager createLayoutManager() {
        return new SubstanceRibbonRootLayout();
    }

    protected JComponent createTitlePane(JRootPane root) {
        return new SubstanceRibbonFrameTitlePane(root, this);
    }

    public void syncApplicationMenuTips() {
        if (this.applicationMenuButton == null || !this.applicationMenuButton.isVisible()) {
            return;
        }
        JRibbonRootPane ribbonRootPane = (JRibbonRootPane)this.root;
        if (ribbonRootPane == null) {
            return;
        }
        JRibbonFrame ribbonFrame = (JRibbonFrame)ribbonRootPane.getParent();
        JRibbon ribbon = ribbonFrame.getRibbon();
        if (ribbon != null) {
            this.applicationMenuButton.setPopupRichTooltip(ribbon.getApplicationMenuRichTooltip());
            this.applicationMenuButton.setPopupKeyTip(ribbon.getApplicationMenuKeyTip());
        }
    }

    private void createAppMenuButton(JRootPane root) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(root);
        if (this.applicationMenuButton == null && windowAncestor instanceof JRibbonFrame) {
            JRibbonFrame ribbonFrame = (JRibbonFrame)windowAncestor;
            this.applicationMenuButton = new JRibbonApplicationMenuButton(ribbonFrame.getRibbon());
            this.applicationMenuButton.applyComponentOrientation(ribbonFrame.getRibbon().getComponentOrientation());
            root.getLayeredPane().add((Component)this.applicationMenuButton);
            root.getLayeredPane().setLayer((Component)this.applicationMenuButton, JRibbonRootPane.RIBBON_SPECIAL_LAYER);
            FlamingoUtilities.updateRibbonFrameIconImages((JRibbonFrame)ribbonFrame);
            JComponent titlePane = this.getTitlePane();
            if (titlePane != null) {
                this.getTitlePane().doLayout();
            }
        }
    }

    protected class SubstanceRibbonRootLayout
    extends SubstanceRootPaneUI.SubstanceRootLayout {
        protected SubstanceRibbonRootLayout() {
            super((SubstanceRootPaneUI)SubstanceRibbonRootPaneUI.this);
        }

        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            if (SubstanceRibbonRootPaneUI.this.applicationMenuButton == null) {
                return;
            }
            JRibbonRootPane ribbonRootPane = (JRibbonRootPane)SubstanceRibbonRootPaneUI.this.root;
            JRibbonFrame ribbonFrame = (JRibbonFrame)ribbonRootPane.getParent();
            boolean ltr = ribbonFrame.getRibbon().getComponentOrientation().isLeftToRight();
            SubstanceRibbonUI ribbonUI = (SubstanceRibbonUI)ribbonFrame.getRibbon().getUI();
            int appMenuButtonSize = SubstanceRibbonRootPaneUI.this.getTitlePane().getHeight() + ribbonUI.getTaskToggleButtonHeight();
            SubstanceRibbonRootPaneUI.this.applicationMenuButton.setVisible(ribbonFrame.getRibbon().getApplicationMenu() != null);
            if (ltr) {
                SubstanceRibbonRootPaneUI.this.applicationMenuButton.setBounds(3, 3, appMenuButtonSize - 6, appMenuButtonSize - 6);
            } else {
                SubstanceRibbonRootPaneUI.this.applicationMenuButton.setBounds(parent.getWidth() - 3 - appMenuButtonSize, 3, appMenuButtonSize - 6, appMenuButtonSize - 6);
            }
            SubstanceRibbonRootPaneUI.this.syncApplicationMenuTips();
            SubstanceRibbonRootPaneUI.this.getTitlePane().doLayout();
            ribbonFrame.getRibbon().doLayout();
        }
    }
}

