/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonRootPane;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.flamingo.ribbon.ui.RibbonBorderShaper;
import org.pushingpixels.substance.flamingo.ribbon.ui.SubstanceRibbonBandUI;
import org.pushingpixels.substance.flamingo.ribbon.ui.SubstanceRibbonRootPaneUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceRibbonUI
extends BasicRibbonUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceRibbonUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        SubstanceLookAndFeel.setDecorationType((JComponent)this.ribbon, (DecorationAreaType)DecorationAreaType.HEADER);
        Color backgr = this.ribbon.getBackground();
        if (backgr == null || backgr instanceof UIResource) {
            Color toSet = SubstanceColorSchemeUtilities.getColorScheme((Component)this.ribbon, (ComponentState)ComponentState.ENABLED).getBackgroundFillColor();
            this.ribbon.setBackground((Color)new ColorUIResource(toSet));
        }
    }

    protected void uninstallDefaults() {
        DecorationPainterUtils.clearDecorationType((JComponent)this.ribbon);
        super.uninstallDefaults();
    }

    protected void installComponents() {
        super.installComponents();
        SubstanceLookAndFeel.setDecorationType((JComponent)this.taskBarPanel, (DecorationAreaType)DecorationAreaType.PRIMARY_TITLE_PANE);
        SubstanceLookAndFeel.setDecorationType((JComponent)this.ribbon, (DecorationAreaType)DecorationAreaType.HEADER);
        SubstanceLookAndFeel.setDecorationType((JComponent)this.bandScrollablePanel, (DecorationAreaType)DecorationAreaType.GENERAL);
    }

    protected void uninstallComponents() {
        DecorationPainterUtils.clearDecorationType((JComponent)this.taskBarPanel);
        super.uninstallComponents();
    }

    protected BasicRibbonUI.TaskToggleButtonsHostPanel createTaskToggleButtonsHostPanel() {
        return new SubstanceTaskToggleButtonsHostPanel();
    }

    protected BasicRibbonUI.BandHostPanel createBandHostPanel() {
        return new SubstanceBandHostPanel();
    }

    protected void paintBackground(Graphics g) {
        BackgroundPaintingUtils.update((Graphics)g, (Component)this.ribbon, (boolean)false);
    }

    protected void paintTaskArea(Graphics g, int x, int y, int width, int height) {
        if (this.ribbon.getTaskCount() == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        RibbonTask selectedTask = this.ribbon.getSelectedTask();
        JRibbonTaskToggleButton selectedTaskButton = (JRibbonTaskToggleButton)this.taskToggleButtons.get(selectedTask);
        Rectangle selectedTaskButtonBounds = selectedTaskButton.getBounds();
        Point converted = SwingUtilities.convertPoint(selectedTaskButton.getParent(), selectedTaskButtonBounds.getLocation(), (Component)this.ribbon);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius((int)SubstanceSizeUtils.getComponentFontSize((Component)this.ribbon));
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth((int)SubstanceSizeUtils.getComponentFontSize((Component)this.ribbon)) / 2.0);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter((Component)this.ribbon);
        int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth((int)SubstanceSizeUtils.getComponentFontSize((Component)this.ribbon));
        AbstractRibbonBand band = selectedTask.getBandCount() == 0 ? null : selectedTask.getBand(0);
        SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)band, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)ComponentState.ENABLED);
        Rectangle taskToggleButtonsViewportBounds = ((BasicRibbonUI.TaskToggleButtonsHostPanel)this.taskToggleButtonsScrollablePanel.getView()).getParent().getBounds();
        taskToggleButtonsViewportBounds.setLocation(SwingUtilities.convertPoint((Component)this.taskToggleButtonsScrollablePanel, taskToggleButtonsViewportBounds.getLocation(), (Component)this.ribbon));
        int startSelectedX = Math.max(converted.x + 1, (int)taskToggleButtonsViewportBounds.getMinX());
        startSelectedX = Math.min(startSelectedX, (int)taskToggleButtonsViewportBounds.getMaxX());
        int endSelectedX = Math.min(converted.x + selectedTaskButtonBounds.width - 1, (int)taskToggleButtonsViewportBounds.getMaxX());
        endSelectedX = Math.max(endSelectedX, (int)taskToggleButtonsViewportBounds.getMinX());
        GeneralPath outerContour = RibbonBorderShaper.getRibbonBorderOutline(this.ribbon, x + borderDelta, x + width - 2 * borderDelta - 1, startSelectedX + borderDelta, endSelectedX - 2 * borderDelta, converted.y + borderDelta, y + borderDelta, y + height - 2 * borderDelta, radius);
        GeneralPath innerContour = RibbonBorderShaper.getRibbonBorderOutline(this.ribbon, x + borderDelta + borderThickness, x + width - 2 * (borderDelta + borderThickness) - 1, startSelectedX + borderDelta + borderThickness, endSelectedX - 2 * (borderDelta + borderThickness), converted.y + borderDelta + borderThickness, y + borderDelta + borderThickness, y + height - 2 * (borderDelta + borderThickness) + 1, radius);
        g2d.setColor(SubstanceColorSchemeUtilities.getColorScheme((Component)band, (ComponentState)ComponentState.ENABLED).getBackgroundFillColor());
        g2d.clipRect(x, y, width, height + 2);
        g2d.fill(outerContour);
        borderPainter.paintBorder((Graphics)g2d, (Component)this.ribbon, width, height + selectedTaskButtonBounds.height + 1, (Shape)outerContour, (Shape)innerContour, borderScheme);
        RibbonTask selected = selectedTask;
        RibbonContextualTaskGroup contextualGroup = selected.getContextualGroup();
        if (contextualGroup != null) {
            Insets ins = this.ribbon.getInsets();
            int topY = ins.top + this.getTaskbarHeight();
            int bottomY = topY + 5;
            Color hueColor = contextualGroup.getHueColor();
            GradientPaint paint = new GradientPaint(0.0f, topY, FlamingoUtilities.getAlphaColor((Color)hueColor, (int)63), 0.0f, bottomY, FlamingoUtilities.getAlphaColor((Color)hueColor, (int)0));
            g2d.setPaint(paint);
            g2d.clip(outerContour);
            g2d.fillRect(0, topY, width, bottomY - topY + 1);
        }
        g2d.dispose();
    }

    protected int getTabButtonGap() {
        return SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)this.ribbon), (int)super.getTabButtonGap(), (int)3, (int)1, (boolean)false);
    }

    protected void syncApplicationMenuTips() {
        JRibbonRootPane ribbonRootPane = (JRibbonRootPane)SwingUtilities.getRootPane((Component)this.ribbon);
        if (ribbonRootPane == null) {
            return;
        }
        SubstanceRibbonRootPaneUI ribbonRootPaneUI = (SubstanceRibbonRootPaneUI)((Object)ribbonRootPane.getUI());
        ribbonRootPaneUI.syncApplicationMenuTips();
    }

    protected void paintMinimizedRibbonSeparator(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(0, this.ribbon.getHeight() - 1);
        SeparatorPainterUtils.paintSeparator((Component)this.ribbon, (Graphics)g2d, (int)this.ribbon.getWidth(), (int)0, (int)0, (boolean)false, (int)0);
        g2d.dispose();
    }

    protected class SubstanceBandHostPanel
    extends BasicRibbonUI.BandHostPanel {
        protected SubstanceBandHostPanel() {
        }

        protected void paintComponent(Graphics g) {
            int dy = 0;
            int i = 0;
            while (i < this.getComponentCount()) {
                Component child = this.getComponent(i);
                if (child instanceof AbstractRibbonBand) {
                    dy = child.getBounds().y;
                    break;
                }
                ++i;
            }
            SubstanceRibbonBandUI.paintRibbonBandBackground(g, (Component)((Object)this), 0.0f, dy);
        }
    }

    protected class SubstanceTaskToggleButtonsHostPanel
    extends BasicRibbonUI.TaskToggleButtonsHostPanel {
        protected SubstanceTaskToggleButtonsHostPanel() {
            super((BasicRibbonUI)SubstanceRibbonUI.this);
        }

        protected void paintContextualTaskGroupOutlines(Graphics g, RibbonContextualTaskGroup group, Rectangle groupBounds) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(groupBounds.x, 0);
            SeparatorPainterUtils.paintSeparator((Component)SubstanceRibbonUI.this.ribbon, (Graphics)g2d, (int)2, (int)(groupBounds.height * 3 / 4), (int)1, (boolean)false, (int)0, (int)(groupBounds.height / 3), (boolean)true);
            g2d.translate(groupBounds.width - 1, 0);
            SeparatorPainterUtils.paintSeparator((Component)SubstanceRibbonUI.this.ribbon, (Graphics)g2d, (int)2, (int)(groupBounds.height * 3 / 4), (int)1, (boolean)false, (int)0, (int)(groupBounds.height / 3), (boolean)true);
            g2d.dispose();
        }

        protected void paintTaskOutlines(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme((Component)SubstanceRibbonUI.this.ribbon, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.ENABLED);
            HashSet<RibbonTask> tasksWithTrailingSeparators = new HashSet<RibbonTask>();
            int i = 0;
            while (i < SubstanceRibbonUI.this.ribbon.getTaskCount() - 1) {
                RibbonTask task = SubstanceRibbonUI.this.ribbon.getTask(i);
                tasksWithTrailingSeparators.add(task);
                ++i;
            }
            i = 0;
            while (i < SubstanceRibbonUI.this.ribbon.getContextualTaskGroupCount()) {
                RibbonContextualTaskGroup group = SubstanceRibbonUI.this.ribbon.getContextualTaskGroup(i);
                if (SubstanceRibbonUI.this.ribbon.isVisible(group)) {
                    int j = 0;
                    while (j < group.getTaskCount() - 1) {
                        RibbonTask task = group.getTask(j);
                        tasksWithTrailingSeparators.add(task);
                        ++j;
                    }
                }
                ++i;
            }
            for (RibbonTask taskWithTrailingSeparator : tasksWithTrailingSeparators) {
                JRibbonTaskToggleButton taskToggleButton = (JRibbonTaskToggleButton)SubstanceRibbonUI.this.taskToggleButtons.get(taskWithTrailingSeparator);
                Rectangle bounds = taskToggleButton.getBounds();
                int x = bounds.x + bounds.width + SubstanceRibbonUI.this.getTabButtonGap() / 2 - 1;
                g2d.translate(x, 0);
                SeparatorPainterUtils.paintSeparator((Component)SubstanceRibbonUI.this.ribbon, (Graphics)g2d, (SubstanceColorScheme)scheme, (int)2, (int)this.getHeight(), (int)1, (boolean)false, (int)(this.getHeight() / 3), (int)0, (boolean)true);
                g2d.translate(-x, 0);
            }
            g2d.dispose();
        }
    }
}

