/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNGNUDiffGenerator;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNChangeEntryHandler;
import org.tmatesoft.svn.core.wc.admin.ISVNChangedDirectoriesHandler;
import org.tmatesoft.svn.core.wc.admin.ISVNGNUDiffGenerator;
import org.tmatesoft.svn.core.wc.admin.SVNChangeEntry;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNNodeEditor
implements ISVNEditor {
    private static final char TYPE_REPLACED = 'R';
    private Node myCurrentNode;
    private Node myRootNode;
    private FSRoot myBaseRoot;
    private FSFS myFSFS;
    private Map myFiles;
    private ISVNEventHandler myCancelHandler;
    private File myTempDirectory;

    public SVNNodeEditor(FSFS fsfs, FSRoot baseRoot, ISVNEventHandler handler) {
        this.myBaseRoot = baseRoot;
        this.myFSFS = fsfs;
        this.myCancelHandler = handler;
        this.myFiles = new SVNHashMap();
    }

    public void abortEdit() throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentNode = this.addOrOpen(path, 'A', SVNNodeKind.DIR, this.myCurrentNode, copyFromPath, copyFromRevision);
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        Node node = this.addOrOpen(path, 'A', SVNNodeKind.FILE, this.myCurrentNode, copyFromPath, copyFromRevision);
        this.myFiles.put(path, node);
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        this.myCurrentNode.myHasPropModifications = true;
    }

    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        Node fileNode = (Node)this.myFiles.get(path);
        fileNode.myHasPropModifications = true;
    }

    public void closeDir() throws SVNException {
        this.myCurrentNode = this.myCurrentNode.myParent;
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        this.myFiles.remove(path);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        String name = SVNPathUtil.tail(path);
        Node node = null;
        if (this.myCurrentNode != null && this.myCurrentNode.myChildren != null) {
            Iterator children = this.myCurrentNode.myChildren.iterator();
            while (children.hasNext()) {
                Node child = (Node)children.next();
                if (!child.myName.equals(name)) continue;
                node = child;
                break;
            }
        }
        if (node == null && this.myCurrentNode != null) {
            node = new Node();
            node.myName = name;
            node.myParent = this.myCurrentNode;
            if (this.myCurrentNode.myChildren == null) {
                this.myCurrentNode.myChildren = new LinkedList();
            }
            this.myCurrentNode.myChildren.add(node);
        }
        node.myAction = (char)68;
        SVNLocationEntry baseLocation = this.findRealBaseLocation(node);
        FSRoot baseRoot = null;
        baseRoot = !SVNRevision.isValidRevisionNumber(baseLocation.getRevision()) ? this.myBaseRoot : this.myFSFS.createRevisionRoot(baseLocation.getRevision());
        SVNNodeKind kind = baseRoot.checkNodeKind(baseLocation.getPath());
        if (kind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' not found in filesystem", path);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        node.myKind = kind;
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentNode = this.addOrOpen(path, 'R', SVNNodeKind.DIR, this.myCurrentNode, null, -1L);
    }

    public void openFile(String path, long revision) throws SVNException {
        Node node = this.addOrOpen(path, 'R', SVNNodeKind.FILE, this.myCurrentNode, null, -1L);
        this.myFiles.put(path, node);
    }

    public void openRoot(long revision) throws SVNException {
        this.myRootNode = this.myCurrentNode = new Node();
        this.myCurrentNode.myName = "";
        this.myCurrentNode.myParent = null;
        this.myCurrentNode.myKind = SVNNodeKind.DIR;
        this.myCurrentNode.myAction = (char)82;
    }

    public void targetRevision(long revision) throws SVNException {
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        Node fileNode = (Node)this.myFiles.get(path);
        fileNode.myHasTextModifications = true;
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return null;
    }

    public void textDeltaEnd(String path) throws SVNException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff(FSRoot root, long baseRevision, ISVNGNUDiffGenerator generator, OutputStream os) throws SVNException {
        if (this.myRootNode != null) {
            FSRevisionRoot baseRoot = root.getOwner().createRevisionRoot(baseRevision);
            try {
                this.diffImpl(root, baseRoot, "/", "/", this.myRootNode, generator, os);
            }
            finally {
                this.cleanup();
            }
        }
    }

    public void traverseTree(boolean includeCopyInfo, ISVNChangeEntryHandler handler) throws SVNException {
        if (this.myRootNode != null) {
            this.traverseChangedTreeImpl(this.myRootNode, "/", includeCopyInfo, handler);
        }
    }

    public void traverseChangedDirs(ISVNChangedDirectoriesHandler handler) throws SVNException {
        if (this.myRootNode != null) {
            this.traverseChangedDirsImpl(this.myRootNode, "/", handler);
        }
    }

    private void diffImpl(FSRoot root, FSRevisionRoot baseRoot, String path, String basePath, Node node, ISVNGNUDiffGenerator generator, OutputStream os) throws SVNException {
        if (this.myCancelHandler != null) {
            this.myCancelHandler.checkCancelled();
        }
        DefaultSVNGNUDiffGenerator defaultGenerator = null;
        if (generator instanceof DefaultSVNGNUDiffGenerator) {
            defaultGenerator = (DefaultSVNGNUDiffGenerator)generator;
            defaultGenerator.setHeaderWritten(false);
        }
        boolean isCopy = false;
        boolean printedHeader = false;
        if (SVNRevision.isValidRevisionNumber(node.myCopyFromRevision) && node.myCopyFromPath != null) {
            basePath = node.myCopyFromPath;
            generator.displayHeader(3, path, basePath, node.myCopyFromRevision, os);
            baseRoot = this.myFSFS.createRevisionRoot(node.myCopyFromRevision);
            isCopy = true;
            printedHeader = true;
        }
        boolean doDiff = false;
        boolean isOriginalEmpty = false;
        DiffItem originalFile = null;
        DiffItem newFile = null;
        if (node.myKind == SVNNodeKind.FILE) {
            if (node.myAction == 'R' && node.myHasTextModifications) {
                doDiff = true;
                originalFile = this.prepareTmpFile(baseRoot, basePath, generator);
                newFile = this.prepareTmpFile(root, path, generator);
            } else if (generator.isDiffCopied() && node.myAction == 'A' && isCopy) {
                if (node.myHasTextModifications) {
                    doDiff = true;
                    originalFile = this.prepareTmpFile(baseRoot, basePath, generator);
                    newFile = this.prepareTmpFile(root, path, generator);
                }
            } else if (generator.isDiffAdded() && node.myAction == 'A') {
                doDiff = true;
                isOriginalEmpty = true;
                originalFile = this.prepareTmpFile(null, basePath, generator);
                newFile = this.prepareTmpFile(root, path, generator);
            } else if (generator.isDiffDeleted() && node.myAction == 'D') {
                doDiff = true;
                originalFile = this.prepareTmpFile(null, basePath, generator);
                newFile = this.prepareTmpFile(null, path, generator);
            }
            if (!printedHeader && (node.myAction != 'R' || node.myHasTextModifications)) {
                if (node.myAction == 'A') {
                    generator.displayHeader(0, path, null, -1L, os);
                } else if (node.myAction == 'D') {
                    generator.displayHeader(1, path, null, -1L, os);
                } else if (node.myAction == 'R') {
                    generator.displayHeader(2, path, null, -1L, os);
                }
                printedHeader = true;
            }
        }
        if (doDiff) {
            if (defaultGenerator != null) {
                if (isOriginalEmpty) {
                    defaultGenerator.setOriginalFile(null, path);
                } else {
                    defaultGenerator.setOriginalFile(baseRoot, basePath);
                }
                defaultGenerator.setNewFile(root, path);
            }
            String rev1 = isOriginalEmpty ? "(rev 0)" : "(rev " + baseRoot.getRevision() + ")";
            String rev2 = null;
            if (root instanceof FSRevisionRoot) {
                FSRevisionRoot revRoot = (FSRevisionRoot)root;
                rev2 = "(rev " + revRoot.getRevision() + ")";
            } else {
                FSTransactionRoot txnRoot = (FSTransactionRoot)root;
                rev2 = "(txn " + txnRoot.getTxnID() + ")";
            }
            generator.displayFileDiff(path, originalFile.myTmpFile, newFile.myTmpFile, rev1, rev2, originalFile.myMimeType, newFile.myMimeType, os);
        } else if (printedHeader) {
            generator.displayHeader(4, path, null, -1L, os);
        }
        if (node.myHasPropModifications && node.myAction != 'D') {
            SVNProperties propsDiff;
            FSRevisionNode localNode = root.getRevisionNode(path);
            SVNProperties props = localNode.getProperties(root.getOwner());
            SVNProperties baseProps = null;
            if (node.myAction != 'A') {
                FSRevisionNode baseNode = baseRoot.getRevisionNode(basePath);
                baseProps = baseNode.getProperties(baseRoot.getOwner());
            }
            if ((propsDiff = FSRepositoryUtil.getPropsDiffs(baseProps, props)).size() > 0) {
                String displayPath = path.startsWith("/") ? path.substring(1) : path;
                generator.displayPropDiff(displayPath, baseProps, propsDiff, os);
            }
        }
        if (node.myChildren == null || node.myChildren.size() == 0) {
            return;
        }
        Iterator children = node.myChildren.iterator();
        while (children.hasNext()) {
            Node childNode = (Node)children.next();
            String childPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(path, childNode.myName));
            String childBasePath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(basePath, childNode.myName));
            this.diffImpl(root, baseRoot, childPath, childBasePath, childNode, generator, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiffItem prepareTmpFile(FSRoot root, String path, ISVNDiffGenerator generator) throws SVNException {
        FSRevisionNode node;
        SVNProperties nodeProps;
        String mimeType = null;
        if (root != null && SVNProperty.isBinaryMimeType(mimeType = (nodeProps = (node = root.getRevisionNode(path)).getProperties(root.getOwner())).getStringValue("svn:mime-type")) && !generator.isForcedBinaryDiff()) {
            return new DiffItem(mimeType, null);
        }
        File tmpFile = this.createTempFile(generator);
        if (root != null) {
            InputStream contents = null;
            OutputStream tmpOS = null;
            try {
                contents = root.getFileStreamForPath(new SVNDeltaCombiner(), path);
                tmpOS = SVNFileUtil.openFileForWriting(tmpFile);
                FSRepositoryUtil.copy(contents, tmpOS, this.myCancelHandler);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(contents);
                SVNFileUtil.closeFile(tmpOS);
                throw throwable;
            }
            SVNFileUtil.closeFile(contents);
            SVNFileUtil.closeFile(tmpOS);
        }
        return new DiffItem(mimeType, tmpFile);
    }

    private File createTempFile(ISVNDiffGenerator generator) throws SVNException {
        File tmpFile = null;
        try {
            return File.createTempFile("diff.", ".tmp", this.getTempDirectory(generator));
        }
        catch (IOException e) {
            SVNFileUtil.deleteFile(tmpFile);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
            return null;
        }
    }

    private File getTempDirectory(ISVNDiffGenerator generator) throws SVNException {
        if (this.myTempDirectory == null || !this.myTempDirectory.exists()) {
            this.myTempDirectory = generator.createTempDirectory();
        }
        return this.myTempDirectory;
    }

    private void cleanup() {
        if (this.myTempDirectory != null) {
            SVNFileUtil.deleteAll(this.myTempDirectory, true);
        }
    }

    private void traverseChangedDirsImpl(Node node, String path, ISVNChangedDirectoriesHandler handler) throws SVNException {
        Iterator children;
        if (this.myCancelHandler != null) {
            this.myCancelHandler.checkCancelled();
        }
        if (node == null || node.myKind != SVNNodeKind.DIR) {
            return;
        }
        boolean proceed = node.myHasPropModifications;
        if (!proceed && node.myChildren != null) {
            children = node.myChildren.iterator();
            while (children.hasNext() && !proceed) {
                Node child = (Node)children.next();
                if (child.myKind != SVNNodeKind.FILE && !child.myHasTextModifications && child.myAction != 'A' && child.myAction != 'D') continue;
                proceed = true;
            }
        }
        if (proceed && handler != null) {
            handler.handleDir(path);
        }
        if (node.myChildren == null || node.myChildren.size() == 0) {
            return;
        }
        children = node.myChildren.iterator();
        while (children.hasNext()) {
            Node childNode = (Node)children.next();
            String fullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(path, childNode.myName));
            this.traverseChangedDirsImpl(childNode, fullPath, handler);
        }
    }

    private void traverseChangedTreeImpl(Node node, String path, boolean includeCopyInfo, ISVNChangeEntryHandler handler) throws SVNException {
        if (this.myCancelHandler != null) {
            this.myCancelHandler.checkCancelled();
        }
        if (node == null) {
            return;
        }
        SVNChangeEntry changeEntry = null;
        if (node.myAction == 'A') {
            String copyFromPath = includeCopyInfo ? node.myCopyFromPath : null;
            long copyFromRevision = includeCopyInfo ? node.myCopyFromRevision : -1L;
            changeEntry = new SVNChangeEntry(path, node.myKind, node.myAction, copyFromPath, copyFromRevision, false, false);
        } else if (node.myAction == 'D') {
            changeEntry = new SVNChangeEntry(path, node.myKind, node.myAction, null, -1L, false, false);
        } else if (node.myAction == 'R' && (node.myHasPropModifications || node.myHasTextModifications)) {
            changeEntry = new SVNChangeEntry(path, node.myKind, 'U', null, -1L, node.myHasTextModifications, node.myHasPropModifications);
        }
        if (changeEntry != null && handler != null) {
            handler.handleEntry(changeEntry);
        }
        if (node.myChildren == null || node.myChildren.size() == 0) {
            return;
        }
        Iterator children = node.myChildren.iterator();
        while (children.hasNext()) {
            Node childNode = (Node)children.next();
            String fullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(path, childNode.myName));
            this.traverseChangedTreeImpl(childNode, fullPath, includeCopyInfo, handler);
        }
    }

    private SVNLocationEntry findRealBaseLocation(Node node) throws SVNException {
        if (node.myAction == 'A' && node.myCopyFromPath != null && SVNRevision.isValidRevisionNumber(node.myCopyFromRevision)) {
            return new SVNLocationEntry(node.myCopyFromRevision, node.myCopyFromPath);
        }
        if (node.myParent != null) {
            SVNLocationEntry location = this.findRealBaseLocation(node.myParent);
            return new SVNLocationEntry(location.getRevision(), SVNPathUtil.getAbsolutePath(SVNPathUtil.append(location.getPath(), node.myName)));
        }
        return new SVNLocationEntry(-1L, "/");
    }

    private Node addOrOpen(String path, char action, SVNNodeKind kind, Node parent, String copyFromPath, long copyFromRevision) {
        if (parent.myChildren == null) {
            parent.myChildren = new LinkedList();
        }
        Node node = new Node();
        node.myName = SVNPathUtil.tail(path);
        node.myAction = action;
        node.myKind = kind;
        node.myCopyFromPath = copyFromPath;
        node.myCopyFromRevision = copyFromRevision;
        node.myParent = parent;
        parent.myChildren.add(node);
        return node;
    }

    private class DiffItem {
        String myMimeType;
        File myTmpFile;

        public DiffItem() {
        }

        public DiffItem(String mimeType, File tmpFile) {
            this.myMimeType = mimeType;
            this.myTmpFile = tmpFile;
        }
    }

    private class Node {
        SVNNodeKind myKind;
        char myAction;
        boolean myHasTextModifications;
        boolean myHasPropModifications;
        String myName;
        long myCopyFromRevision;
        String myCopyFromPath;
        Node myParent;
        LinkedList myChildren;

        private Node() {
        }
    }
}

