/*
 * Decompiled with CFR 0.152.
 */
package test.substance.ribbon;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.skin.OfficeBlack2007Skin;
import org.pushingpixels.substance.flamingo.ribbon.gallery.oob.SubstanceRibbonTask;
import test.ribbon.BasicCheckRibbon;

public class NewCheckRibbon
extends BasicCheckRibbon {
    private JLabel saveLabel;

    public void configureRibbon() {
        super.configureRibbon();
        this.getRibbon().addTask(SubstanceRibbonTask.getSubstanceRibbonTask());
    }

    protected void configureStatusBar() {
        super.configureStatusBar();
        SubstanceLookAndFeel.setDecorationType((JComponent)this.statusBar, (DecorationAreaType)DecorationAreaType.FOOTER);
    }

    protected void configureControlPanel(DefaultFormBuilder formBuilder) {
        super.configureControlPanel(formBuilder);
        final JCheckBox useThemedDefaultIconsCheckBox = new JCheckBox("use");
        useThemedDefaultIconsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UIManager.put("substancelaf.useThemedDefaultIcons", useThemedDefaultIconsCheckBox.isSelected() ? Boolean.TRUE : null);
                        SwingUtilities.updateComponentTreeUI((Component)((Object)NewCheckRibbon.this));
                        NewCheckRibbon.this.repaint();
                    }
                });
            }
        });
        formBuilder.append("Themed icons", (Component)useThemedDefaultIconsCheckBox);
        final JCheckBox heapPanel = new JCheckBox("show");
        heapPanel.setSelected(false);
        heapPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstanceLookAndFeel.setWidgetVisible((JRootPane)NewCheckRibbon.this.getRootPane(), (boolean)heapPanel.isSelected(), (SubstanceConstants.SubstanceWidgetType[])new SubstanceConstants.SubstanceWidgetType[]{SubstanceConstants.SubstanceWidgetType.TITLE_PANE_HEAP_STATUS});
            }
        });
        formBuilder.append("Heap panel", (Component)heapPanel);
    }

    public static void main(String[] args) {
        Window[] windowArray = Window.getWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window w = windowArray[n2];
            String wTitle = null;
            JRootPane rootPane = null;
            if (w instanceof Frame) {
                wTitle = ((Frame)w).getTitle();
            }
            if (w instanceof Dialog) {
                wTitle = ((Dialog)w).getTitle();
            }
            if (w instanceof JFrame) {
                rootPane = ((JFrame)w).getRootPane();
            }
            if (w instanceof JDialog) {
                rootPane = ((JDialog)w).getRootPane();
            }
            System.out.println("Window '" + wTitle + "' of " + w.getClass().getName());
            if (rootPane != null) {
                System.out.println("\troot pane UI:" + rootPane.getUI().getClass().getName());
            }
            ++n2;
        }
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("lookAndFeel".equals(evt.getPropertyName())) {
                    LookAndFeel oldLaf = (LookAndFeel)evt.getOldValue();
                    LookAndFeel newLaf = (LookAndFeel)evt.getNewValue();
                    System.out.println("Look-and-feel change from " + (oldLaf == null ? "null" : oldLaf.getName()) + " to " + (newLaf == null ? "null" : newLaf.getName()));
                }
            }
        });
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = cl.getResources("META-INF/MANIFEST.MF");
            HashSet<String> timestampStrings = new HashSet<String>();
            while (urls.hasMoreElements()) {
                String line;
                InputStream is = urls.nextElement().openStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    String name;
                    int firstColonIndex = line.indexOf(":");
                    if (firstColonIndex < 0 || timestampStrings.contains(name = line.substring(0, firstColonIndex).trim()) || !name.endsWith("-BuildStamp")) continue;
                    System.out.println(line);
                    timestampStrings.add(name);
                }
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            System.out.println();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin((SubstanceSkin)new OfficeBlack2007Skin());
                NewCheckRibbon c = new NewCheckRibbon();
                c.configureRibbon();
                c.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                c.setPreferredSize(new Dimension(r.width, r.height / 2));
                c.setMinimumSize(new Dimension(100, r.height / 3));
                c.pack();
                c.setLocation(r.x, r.y);
                c.setDefaultCloseOperation(3);
                c.setVisible(true);
            }
        });
    }
}

