/*
 * Decompiled with CFR 0.152.
 */
package test.substance.ribbon;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JFlowRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.skin.OfficeBlue2007Skin;
import test.ribbon.BasicCheckRibbon;
import test.svg.transcoded.help_browser;

public class SmallCheckRibbon
extends BasicCheckRibbon {
    private JLabel saveLabel;

    public SmallCheckRibbon() {
        this.setTitle("Ribbon longer title to check contextual tabs");
    }

    public void configureRibbon() {
        JRibbonBand clipboardBand = this.getClipboardBand();
        JRibbonBand quickStylesBand = this.getQuickStylesBand();
        JFlowRibbonBand fontBand = this.getFontBand();
        JRibbonBand findBand = this.getFindBand();
        RibbonTask pageLayoutTask = new RibbonTask("Page Layout", new AbstractRibbonBand[]{clipboardBand, quickStylesBand, fontBand, findBand});
        pageLayoutTask.setKeyTip("P");
        JRibbonBand themeBand = this.getActionBand();
        JRibbonBand preferencesBand = this.getPreferencesBand();
        JRibbonBand arrangeBand = this.getApplicationsBand();
        JRibbonBand paragraphBand = this.getParagraphBand();
        JRibbonBand showHideBand = this.getShowHideBand();
        RibbonTask writeTask = new RibbonTask("Write", new AbstractRibbonBand[]{themeBand, preferencesBand, arrangeBand, paragraphBand, showHideBand});
        writeTask.setKeyTip("W");
        JRibbonBand previewBand = this.getPreviewBand();
        JRibbonBand animationBand = this.getAnimationBand();
        JRibbonBand transitionBand = this.getTransitionBand();
        JRibbonBand transitionNextBand = this.getTransitionNextBand();
        RibbonTask animationsTask = new RibbonTask("Animations", new AbstractRibbonBand[]{previewBand, animationBand, transitionBand, transitionNextBand});
        animationsTask.setKeyTip("A");
        JRibbonBand rowSpanBand = this.getRowSpanBand();
        JRibbonBand alignmentBand = this.getAlignmentBand();
        RibbonTask wrappedTask = new RibbonTask("Wrapped", new AbstractRibbonBand[]{rowSpanBand, alignmentBand});
        wrappedTask.setKeyTip("R");
        this.getRibbon().addTask(pageLayoutTask);
        this.getRibbon().addTask(writeTask);
        this.getRibbon().addTask(animationsTask);
        this.getRibbon().addTask(wrappedTask);
        this.getRibbon().configureHelp((ResizableIcon)new help_browser(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog((Component)((Object)SmallCheckRibbon.this), "Help button clicked");
            }
        });
        this.group1 = new RibbonContextualTaskGroup("Group 1", Color.red, new RibbonTask[]{this.getContextualRibbonTask("Group 1-1", "XA"), this.getContextualRibbonTask("Group 1-2", "XB")});
        this.group2 = new RibbonContextualTaskGroup("Group 2", Color.green, new RibbonTask[]{this.getContextualRibbonTask("Group 2-1", "YA")});
        this.getRibbon().addContextualTaskGroup(this.group1);
        this.getRibbon().addContextualTaskGroup(this.group2);
        this.configureTaskBar();
        this.configureApplicationMenu();
        JPanel controlPanel = new JPanel();
        controlPanel.setBorder(new EmptyBorder(20, 0, 0, 5));
        FormLayout lm = new FormLayout("right:pref, 4dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, controlPanel);
        this.configureControlPanel(builder);
        this.add(controlPanel, "East");
        this.add((Component)new BasicCheckRibbon.RulerPanel(), "Center");
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin((SubstanceSkin)new OfficeBlue2007Skin());
                SmallCheckRibbon c = new SmallCheckRibbon();
                c.configureRibbon();
                Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                c.setPreferredSize(new Dimension(r.width, r.height / 2));
                c.setMinimumSize(new Dimension(100, r.height / 3));
                c.pack();
                c.setLocation(r.x, r.y);
                c.setDefaultCloseOperation(3);
                c.setVisible(true);
            }
        });
    }
}

