/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonarsource.scanner.api.Dirs;
import org.sonarsource.scanner.api.LogOutput;
import org.sonarsource.scanner.api.LoggerAdapter;
import org.sonarsource.scanner.api.System2;
import org.sonarsource.scanner.api.Utils;
import org.sonarsource.scanner.api.internal.ClassloadRules;
import org.sonarsource.scanner.api.internal.IsolatedLauncherFactory;
import org.sonarsource.scanner.api.internal.batch.IsolatedLauncher;
import org.sonarsource.scanner.api.internal.cache.Logger;

public class EmbeddedScanner {
    private static final String BITBUCKET_CLOUD_ENV_VAR = "BITBUCKET_BUILD_NUMBER";
    private static final String SONARCLOUD_HOST = "https://sonarcloud.io";
    private final IsolatedLauncherFactory launcherFactory;
    private IsolatedLauncher launcher;
    private final LogOutput logOutput;
    private final Map<String, String> globalProperties = new HashMap<String, String>();
    private final Logger logger;
    private final Set<String> classloaderMask = new HashSet<String>();
    private final Set<String> classloaderUnmask = new HashSet<String>();
    private final System2 system;

    EmbeddedScanner(IsolatedLauncherFactory bl, Logger logger, LogOutput logOutput, System2 system) {
        this.logger = logger;
        this.launcherFactory = bl;
        this.logOutput = logOutput;
        this.classloaderUnmask.add("org.sonarsource.scanner.api.internal.batch.");
        this.system = system;
    }

    public static EmbeddedScanner create(String app, String version, LogOutput logOutput, System2 system2) {
        LoggerAdapter logger = new LoggerAdapter(logOutput);
        return new EmbeddedScanner(new IsolatedLauncherFactory(logger), logger, logOutput, system2).setGlobalProperty("sonar.scanner.app", app).setGlobalProperty("sonar.scanner.appVersion", version);
    }

    public static EmbeddedScanner create(String app, String version, LogOutput logOutput) {
        return EmbeddedScanner.create(app, version, logOutput, new System2());
    }

    public Map<String, String> globalProperties() {
        return this.globalProperties;
    }

    public EmbeddedScanner unmask(String fqcnPrefix) {
        this.checkLauncherDoesntExist();
        this.classloaderUnmask.add(fqcnPrefix);
        return this;
    }

    public EmbeddedScanner mask(String fqcnPrefix) {
        this.checkLauncherDoesntExist();
        this.classloaderMask.add(fqcnPrefix);
        return this;
    }

    public EmbeddedScanner addGlobalProperties(Map<String, String> p) {
        this.globalProperties.putAll(p);
        return this;
    }

    public EmbeddedScanner setGlobalProperty(String key, String value) {
        this.globalProperties.put(key, value);
        return this;
    }

    public String globalProperty(String key, @Nullable String defaultValue) {
        return Optional.ofNullable(this.globalProperties.get(key)).orElse(defaultValue);
    }

    public String app() {
        return this.globalProperty("sonar.scanner.app", null);
    }

    public String appVersion() {
        return this.globalProperty("sonar.scanner.appVersion", null);
    }

    public void start() {
        this.initGlobalDefaultValues();
        this.doStart();
    }

    public String serverVersion() {
        this.checkLauncherExists();
        return this.launcher.getVersion();
    }

    public void execute(Map<String, String> taskProps) {
        this.checkLauncherExists();
        try (IsolatedLauncherFactory launcherFactoryToBeClosed = this.launcherFactory;){
            HashMap<String, String> allProps = new HashMap<String, String>();
            allProps.putAll(this.globalProperties);
            allProps.putAll(taskProps);
            this.initAnalysisProperties(allProps);
            this.doExecute(allProps);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private void initGlobalDefaultValues() {
        if (this.system.getEnvironmentVariable(BITBUCKET_CLOUD_ENV_VAR) != null) {
            this.setGlobalDefaultValue("sonar.host.url", SONARCLOUD_HOST);
            this.logger.info("Bitbucket Cloud Pipelines detected");
        } else {
            this.setGlobalDefaultValue("sonar.host.url", "http://localhost:9000");
        }
    }

    private void initAnalysisProperties(Map<String, String> p) {
        this.initSourceEncoding(p);
        new Dirs(this.logger).init(p);
    }

    void initSourceEncoding(Map<String, String> p) {
        boolean onProject = Utils.taskRequiresProject(p);
        if (onProject) {
            String sourceEncoding = Optional.ofNullable(p.get("sonar.sourceEncoding")).orElse("");
            boolean platformDependent = false;
            if ("".equals(sourceEncoding)) {
                sourceEncoding = Charset.defaultCharset().name();
                platformDependent = true;
                p.put("sonar.sourceEncoding", sourceEncoding);
            }
            this.logger.info("Default locale: \"" + Locale.getDefault() + "\", source code encoding: \"" + sourceEncoding + "\"" + (platformDependent ? " (analysis is platform dependent)" : ""));
        }
    }

    private void setGlobalDefaultValue(String key, String value) {
        if (!this.globalProperties.containsKey(key)) {
            this.setGlobalProperty(key, value);
        }
    }

    protected void doStart() {
        this.checkLauncherDoesntExist();
        ClassloadRules rules = new ClassloadRules(this.classloaderMask, this.classloaderUnmask);
        this.launcher = this.launcherFactory.createLauncher(this.globalProperties(), rules);
    }

    protected void doExecute(Map<String, String> properties) {
        this.launcher.execute(properties, (formattedMessage, level) -> this.logOutput.log(formattedMessage, LogOutput.Level.valueOf(level.name())));
    }

    private void checkLauncherExists() {
        if (this.launcher == null) {
            throw new IllegalStateException("not started");
        }
    }

    private void checkLauncherDoesntExist() {
        if (this.launcher != null) {
            throw new IllegalStateException("already started");
        }
    }
}

