/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonarsource.scanner.api.Dirs;
import org.sonarsource.scanner.api.LogOutput;
import org.sonarsource.scanner.api.LoggerAdapter;
import org.sonarsource.scanner.api.ScannerApiVersion;
import org.sonarsource.scanner.api.Utils;
import org.sonarsource.scanner.api.internal.ClassloadRules;
import org.sonarsource.scanner.api.internal.IsolatedLauncherFactory;
import org.sonarsource.scanner.api.internal.VersionUtils;
import org.sonarsource.scanner.api.internal.batch.IsolatedLauncher;
import org.sonarsource.scanner.api.internal.cache.Logger;

public class EmbeddedScanner {
    private final IsolatedLauncherFactory launcherFactory;
    private IsolatedLauncher launcher;
    private final LogOutput logOutput;
    private final Properties globalProperties = new Properties();
    private final List<Object> extensions = new ArrayList<Object>();
    private final Logger logger;
    private final Set<String> classloaderMask = new HashSet<String>();
    private final Set<String> classloaderUnmask = new HashSet<String>();

    EmbeddedScanner(IsolatedLauncherFactory bl, Logger logger, LogOutput logOutput) {
        this.logger = logger;
        this.launcherFactory = bl;
        this.logOutput = logOutput;
        this.classloaderUnmask.add("org.sonarsource.scanner.api.internal.batch.");
    }

    public static EmbeddedScanner create(LogOutput logOutput) {
        LoggerAdapter logger = new LoggerAdapter(logOutput);
        return new EmbeddedScanner(new IsolatedLauncherFactory(logger), logger, logOutput);
    }

    public Properties globalProperties() {
        Properties clone = new Properties();
        clone.putAll((Map<?, ?>)this.globalProperties);
        return clone;
    }

    public EmbeddedScanner unmask(String fqcnPrefix) {
        this.checkLauncherDoesntExist();
        this.classloaderUnmask.add(fqcnPrefix);
        return this;
    }

    public EmbeddedScanner mask(String fqcnPrefix) {
        this.checkLauncherDoesntExist();
        this.classloaderMask.add(fqcnPrefix);
        return this;
    }

    public EmbeddedScanner addGlobalProperties(Properties p) {
        this.globalProperties.putAll((Map<?, ?>)p);
        return this;
    }

    public EmbeddedScanner setGlobalProperty(String key, String value) {
        this.globalProperties.setProperty(key, value);
        return this;
    }

    public String globalProperty(String key, @Nullable String defaultValue) {
        return this.globalProperties.getProperty(key, defaultValue);
    }

    public EmbeddedScanner setApp(String app, String version) {
        this.setGlobalProperty("sonar.scanner.app", app);
        this.setGlobalProperty("sonar.scanner.appVersion", version);
        return this;
    }

    public String app() {
        return this.globalProperty("sonar.scanner.app", null);
    }

    public EmbeddedScanner addExtensions(Object ... objs) {
        this.checkLauncherExists();
        if (VersionUtils.isAtLeast52(this.launcher.getVersion())) {
            throw new IllegalStateException("not supported in current SonarQube version: " + this.launcher.getVersion());
        }
        this.extensions.addAll(Arrays.asList(objs));
        return this;
    }

    public String appVersion() {
        return this.globalProperty("sonar.scanner.appVersion", null);
    }

    public void runAnalysis(Properties analysisProperties) {
        this.checkLauncherExists();
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)analysisProperties);
        this.initAnalysisProperties(copy);
        this.doExecute(copy);
    }

    public void start() {
        this.initGlobalDefaultValues();
        this.doStart();
    }

    public void stop() {
        this.checkLauncherExists();
        this.doStop();
    }

    public String serverVersion() {
        this.checkLauncherExists();
        return this.launcher.getVersion();
    }

    @Deprecated
    public final void execute() {
        this.start();
        this.runAnalysis(new Properties());
        this.stop();
    }

    private void initGlobalDefaultValues() {
        this.setGlobalDefaultValue("sonar.host.url", "http://localhost:9000");
        this.setGlobalDefaultValue("sonar.scanner.app", "SonarQubeScanner");
        this.setGlobalDefaultValue("sonar.scanner.appVersion", ScannerApiVersion.version());
    }

    private void initAnalysisProperties(Properties p) {
        this.initSourceEncoding(p);
        new Dirs(this.logger).init(p);
    }

    void initSourceEncoding(Properties p) {
        boolean onProject = Utils.taskRequiresProject(p);
        if (onProject) {
            String sourceEncoding = p.getProperty("sonar.sourceEncoding", "");
            boolean platformDependent = false;
            if ("".equals(sourceEncoding)) {
                sourceEncoding = Charset.defaultCharset().name();
                platformDependent = true;
                p.setProperty("sonar.sourceEncoding", sourceEncoding);
            }
            this.logger.info("Default locale: \"" + Locale.getDefault() + "\", source code encoding: \"" + sourceEncoding + "\"" + (platformDependent ? " (analysis is platform dependent)" : ""));
        }
    }

    private void setGlobalDefaultValue(String key, String value) {
        if (!this.globalProperties.containsKey(key)) {
            this.setGlobalProperty(key, value);
        }
    }

    protected void doStart() {
        this.checkLauncherDoesntExist();
        ClassloadRules rules = new ClassloadRules(this.classloaderMask, this.classloaderUnmask);
        this.launcher = this.launcherFactory.createLauncher(this.globalProperties(), rules);
        if (VersionUtils.isAtLeast52(this.launcher.getVersion())) {
            this.launcher.start(this.globalProperties(), (formattedMessage, level) -> this.logOutput.log(formattedMessage, LogOutput.Level.valueOf(level.name())));
        }
    }

    protected void doStop() {
        if (VersionUtils.isAtLeast52(this.launcher.getVersion())) {
            this.launcher.stop();
            this.launcher = null;
        }
    }

    protected void doExecute(Properties analysisProperties) {
        if (VersionUtils.isAtLeast52(this.launcher.getVersion())) {
            this.launcher.execute(analysisProperties);
        } else {
            Properties prop = new Properties();
            prop.putAll((Map<?, ?>)this.globalProperties());
            prop.putAll((Map<?, ?>)analysisProperties);
            this.launcher.executeOldVersion(prop, this.extensions);
        }
    }

    private void checkLauncherExists() {
        if (this.launcher == null) {
            throw new IllegalStateException("not started");
        }
    }

    private void checkLauncherDoesntExist() {
        if (this.launcher != null) {
            throw new IllegalStateException("already started");
        }
    }
}

