/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.filter.AncestorOrSelfDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.StateDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.traversal.BuildingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.FilteringDependencyNodeVisitor;

public class DependencyCollector {
    private final DependencyTreeBuilder dependencyTreeBuilder;
    private final ArtifactRepository localRepository;

    public DependencyCollector(DependencyTreeBuilder dependencyTreeBuilder, ArtifactRepository localRepository) {
        this.dependencyTreeBuilder = dependencyTreeBuilder;
        this.localRepository = localRepository;
    }

    private List<Dependency> collectProjectDependencies(MavenProject project) {
        final ArrayList<Dependency> result = new ArrayList<Dependency>();
        try {
            DependencyNode root = this.dependencyTreeBuilder.buildDependencyTree(project, this.localRepository, null);
            BuildingDependencyNodeVisitor visitor = new BuildingDependencyNodeVisitor(new DependencyNodeVisitor(){
                private Deque<Dependency> stack = new ArrayDeque<Dependency>();

                public boolean visit(DependencyNode node) {
                    if (node.getParent() != null && node.getParent() != node) {
                        Dependency dependency = DependencyCollector.this.toDependency(node);
                        if (this.stack.isEmpty()) {
                            result.add(dependency);
                        } else {
                            this.stack.peek().dependencies().add(dependency);
                        }
                        this.stack.push(dependency);
                    }
                    return true;
                }

                public boolean endVisit(DependencyNode node) {
                    if (!this.stack.isEmpty()) {
                        this.stack.pop();
                    }
                    return true;
                }
            });
            StateDependencyNodeFilter filter = StateDependencyNodeFilter.INCLUDED;
            CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
            FilteringDependencyNodeVisitor firstPassVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collectingVisitor, (DependencyNodeFilter)filter);
            root.accept((DependencyNodeVisitor)firstPassVisitor);
            AncestorOrSelfDependencyNodeFilter secondPassFilter = new AncestorOrSelfDependencyNodeFilter(collectingVisitor.getNodes());
            visitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)visitor, (DependencyNodeFilter)secondPassFilter);
            root.accept((DependencyNodeVisitor)visitor);
        }
        catch (DependencyTreeBuilderException e) {
            throw new IllegalStateException("Can not load the graph of dependencies of the project " + project, e);
        }
        return result;
    }

    private Dependency toDependency(DependencyNode node) {
        String key = String.format("%s:%s", node.getArtifact().getGroupId(), node.getArtifact().getArtifactId());
        String version = node.getArtifact().getBaseVersion();
        return new Dependency(key, version).setScope(node.getArtifact().getScope());
    }

    public String toJson(MavenProject project) {
        return this.dependenciesToJson(this.collectProjectDependencies(project));
    }

    private String dependenciesToJson(List<Dependency> deps) {
        StringBuilder json = new StringBuilder();
        json.append('[');
        this.serializeDeps(json, deps);
        json.append(']');
        return json.toString();
    }

    private void serializeDeps(StringBuilder json, List<Dependency> deps) {
        Iterator<Dependency> dependencyIt = deps.iterator();
        while (dependencyIt.hasNext()) {
            this.serializeDep(json, dependencyIt.next());
            if (!dependencyIt.hasNext()) continue;
            json.append(',');
        }
    }

    private void serializeDep(StringBuilder json, Dependency dependency) {
        json.append("{");
        json.append("\"k\":\"");
        json.append(dependency.key());
        json.append("\",\"v\":\"");
        json.append(dependency.version());
        json.append("\",\"s\":\"");
        json.append(dependency.scope());
        json.append("\",\"d\":[");
        this.serializeDeps(json, dependency.dependencies());
        json.append("]");
        json.append("}");
    }

    private static class Dependency {
        private final String key;
        private final String version;
        private String scope;
        List<Dependency> dependencies = new ArrayList<Dependency>();

        public Dependency(String key, String version) {
            this.key = key;
            this.version = version;
        }

        public String key() {
            return this.key;
        }

        public String version() {
            return this.version;
        }

        public String scope() {
            return this.scope;
        }

        public Dependency setScope(String scope) {
            this.scope = scope;
            return this;
        }

        public List<Dependency> dependencies() {
            return this.dependencies;
        }
    }
}

