/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.util.Properties;
import org.apache.maven.plugin.logging.Log;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public class PropertyDecryptor {
    private final Log log;
    private final SecDispatcher securityDispatcher;

    public PropertyDecryptor(Log log, SecDispatcher securityDispatcher) {
        this.log = log;
        this.securityDispatcher = securityDispatcher;
    }

    public Properties decryptProperties(Properties properties) {
        Properties newProperties = new Properties();
        try {
            for (String key : properties.stringPropertyNames()) {
                if (!key.contains(".password") && !key.contains(".login")) continue;
                this.decrypt(properties, newProperties, key);
            }
        }
        catch (Exception e) {
            this.log.warn((CharSequence)"Unable to decrypt properties", (Throwable)e);
        }
        return newProperties;
    }

    private void decrypt(Properties properties, Properties newProperties, String key) {
        try {
            String decrypted = this.securityDispatcher.decrypt(properties.getProperty(key));
            newProperties.setProperty(key, decrypted);
        }
        catch (SecDispatcherException e) {
            this.log.debug((CharSequence)("Unable to decrypt property " + key), (Throwable)e);
        }
    }
}

