/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.maven.bootstrap.MavenProjectConverter;
import org.sonarsource.scanner.maven.bootstrap.MavenUtils;
import org.sonarsource.scanner.maven.bootstrap.PropertyDecryptor;
import org.sonarsource.scanner.maven.bootstrap.SourceCollector;
import org.sonarsource.scanner.maven.bootstrap.SystemWrapper;

public class ScannerBootstrapper {
    static final String UNSUPPORTED_BELOW_SONARQUBE_56_MESSAGE = "With SonarQube server prior to 5.6, use sonar-maven-plugin <= 3.3";
    private static final String SONARCLOUD_HOST_URL = "https://sonarcloud.io";
    private static final Pattern REPORT_PROPERTY_PATTERN = Pattern.compile("^sonar\\..*[rR]eportPaths?$");
    private final Log log;
    private final MavenSession session;
    private final EmbeddedScanner scanner;
    private final MavenProjectConverter mavenProjectConverter;
    private String serverVersion;
    private PropertyDecryptor propertyDecryptor;

    public ScannerBootstrapper(Log log, MavenSession session, EmbeddedScanner scanner, MavenProjectConverter mavenProjectConverter, PropertyDecryptor propertyDecryptor) {
        this.log = log;
        this.session = session;
        this.scanner = scanner;
        this.mavenProjectConverter = mavenProjectConverter;
        this.propertyDecryptor = propertyDecryptor;
    }

    public void execute() throws MojoExecutionException {
        try {
            this.logEnvironmentInformation();
            this.scanner.start();
            this.serverVersion = this.scanner.serverVersion();
            if (this.isSonarCloudUsed()) {
                this.log.info((CharSequence)"Communicating with SonarCloud");
            } else {
                if (this.serverVersion != null) {
                    this.log.info((CharSequence)("Communicating with SonarQube Server " + this.serverVersion));
                }
                this.checkSQVersion();
            }
            if (this.log.isDebugEnabled()) {
                this.scanner.setGlobalProperty("sonar.verbose", "true");
            }
            this.scanner.execute(this.collectProperties());
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private boolean isSonarCloudUsed() {
        return this.session.getProjects().stream().map(project -> MavenProjectConverter.getPropertyByKey("sonar.host.url", project, this.session.getUserProperties(), this.mavenProjectConverter.getEnvProperties())).filter(Objects::nonNull).anyMatch(hostUrl -> hostUrl.startsWith(SONARCLOUD_HOST_URL));
    }

    @VisibleForTesting
    Map<String, String> collectProperties() throws MojoExecutionException {
        List sortedProjects = this.session.getProjects();
        MavenProject topLevelProject = null;
        for (MavenProject project : sortedProjects) {
            if (!project.isExecutionRoot()) continue;
            topLevelProject = project;
            break;
        }
        if (topLevelProject == null) {
            throw new IllegalStateException("Maven session does not declare a top level project");
        }
        Properties userProperties = this.session.getUserProperties();
        Map<String, String> props = this.mavenProjectConverter.configure(sortedProjects, topLevelProject, userProperties);
        props.putAll(this.propertyDecryptor.decryptProperties(props));
        if (ScannerBootstrapper.shouldCollectAllSources(userProperties)) {
            this.log.info((CharSequence)"Parameter sonar.maven.scanAll is enabled. The scanner will attempt to collect additional sources.");
            if (this.mavenProjectConverter.isSourceDirsOverridden()) {
                this.log.warn((CharSequence)ScannerBootstrapper.notCollectingAdditionalSourcesBecauseOf("sonar.sources"));
            } else if (this.mavenProjectConverter.isTestDirsOverridden()) {
                this.log.warn((CharSequence)ScannerBootstrapper.notCollectingAdditionalSourcesBecauseOf("sonar.tests"));
            } else {
                boolean shouldCollectJavaAndKotlinSources = ScannerBootstrapper.isUserDefinedJavaBinaries(userProperties);
                this.collectAllSources(props, shouldCollectJavaAndKotlinSources);
            }
        }
        return props;
    }

    private static boolean shouldCollectAllSources(Properties userProperties) {
        return Boolean.TRUE.equals(Boolean.parseBoolean(userProperties.getProperty("sonar.maven.scanAll")));
    }

    private static String notCollectingAdditionalSourcesBecauseOf(String overriddenProperty) {
        return "Parameter sonar.maven.scanAll is enabled but the scanner will not collect additional sources because " + overriddenProperty + " has been overridden.";
    }

    private static Set<Path> excludedReportFiles(Map<String, String> props) {
        return props.keySet().stream().filter(key -> REPORT_PROPERTY_PATTERN.matcher((CharSequence)key).matches()).map(props::get).map(MavenUtils::splitAsCsv).flatMap(Collection::stream).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).map(Path::normalize).collect(Collectors.toSet());
    }

    @VisibleForTesting
    void collectAllSources(Map<String, String> props, boolean shouldCollectJavaAndKotlinSources) {
        String projectBasedir = props.get("sonar.projectBaseDir");
        List coveredSources = props.entrySet().stream().filter(k -> ((String)k.getKey()).endsWith("sonar.sources") || ((String)k.getKey()).endsWith("sonar.tests")).map(Map.Entry::getValue).filter(value -> !value.isEmpty()).flatMap(value -> MavenUtils.splitAsCsv(value).stream()).collect(Collectors.toList());
        try {
            Set<Path> existingSources = coveredSources.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet());
            SourceCollector visitor = new SourceCollector(existingSources, this.mavenProjectConverter.getSkippedBasedDirs(), ScannerBootstrapper.excludedReportFiles(props), shouldCollectJavaAndKotlinSources);
            Files.walkFileTree(Paths.get(projectBasedir, new String[0]), visitor);
            List collectedSources = visitor.getCollectedSources().stream().map(file -> file.toAbsolutePath().toString()).collect(Collectors.toList());
            ArrayList<String> mergedSources = new ArrayList<String>();
            mergedSources.addAll(MavenUtils.splitAsCsv(props.get("sonar.sources")));
            mergedSources.addAll(collectedSources);
            props.put("sonar.sources", MavenUtils.joinAsCsv(mergedSources));
        }
        catch (IOException e) {
            this.log.warn((Throwable)e);
        }
    }

    private static boolean isUserDefinedJavaBinaries(Properties userProperties) {
        return userProperties.containsKey("sonar.java.libraries") && userProperties.containsKey("sonar.java.binaries");
    }

    private void checkSQVersion() {
        if (this.isVersionPriorTo("5.6")) {
            throw new UnsupportedOperationException(UNSUPPORTED_BELOW_SONARQUBE_56_MESSAGE);
        }
    }

    boolean isVersionPriorTo(String version) {
        if (this.serverVersion == null) {
            return true;
        }
        return new ComparableVersion(this.serverVersion).compareTo(new ComparableVersion(version)) < 0;
    }

    private void logEnvironmentInformation() {
        String vmInformation = String.format("Java %s %s (%s-bit)", SystemWrapper.getProperty("java.version"), SystemWrapper.getProperty("java.vm.vendor"), SystemWrapper.getProperty("sun.arch.data.model"));
        this.log.info((CharSequence)vmInformation);
        String operatingSystem = String.format("%s %s (%s)", SystemWrapper.getProperty("os.name"), SystemWrapper.getProperty("os.version"), SystemWrapper.getProperty("os.arch"));
        this.log.info((CharSequence)operatingSystem);
        String mavenOptions = SystemWrapper.getenv("MAVEN_OPTS");
        if (mavenOptions != null) {
            this.log.info((CharSequence)String.format("MAVEN_OPTS=%s", mavenOptions));
        }
    }
}

