/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.function.Predicate;
import org.springframework.boot.context.properties.source.AliasedConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.boot.context.properties.source.FilteredConfigurationPropertiesSource;
import org.springframework.boot.context.properties.source.SpringConfigurationPropertySource;
import org.springframework.core.env.PropertySource;

@FunctionalInterface
public interface ConfigurationPropertySource {
    public ConfigurationProperty getConfigurationProperty(ConfigurationPropertyName var1);

    default public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name) {
        return ConfigurationPropertyState.UNKNOWN;
    }

    default public ConfigurationPropertySource filter(Predicate<ConfigurationPropertyName> filter) {
        return new FilteredConfigurationPropertiesSource(this, filter);
    }

    default public ConfigurationPropertySource withAliases(ConfigurationPropertyNameAliases aliases) {
        return new AliasedConfigurationPropertySource(this, aliases);
    }

    default public Object getUnderlyingSource() {
        return null;
    }

    public static ConfigurationPropertySource from(PropertySource<?> source) {
        if (source instanceof ConfigurationPropertySourcesPropertySource) {
            return null;
        }
        return SpringConfigurationPropertySource.from(source);
    }
}

