/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.configuration.CompatibilityNotMetException;
import org.springframework.cloud.configuration.CompatibilityVerifier;
import org.springframework.cloud.configuration.VerificationResult;

class CompositeCompatibilityVerifier {
    private static final Log log = LogFactory.getLog(CompositeCompatibilityVerifier.class);
    private final List<CompatibilityVerifier> verifiers;

    CompositeCompatibilityVerifier(List<CompatibilityVerifier> verifiers) {
        this.verifiers = verifiers;
    }

    void verifyDependencies() {
        List<VerificationResult> errors = this.verifierErrors();
        if (errors.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"All conditions are passing");
            }
            return;
        }
        throw new CompatibilityNotMetException(errors);
    }

    private List<VerificationResult> verifierErrors() {
        ArrayList<VerificationResult> errors = new ArrayList<VerificationResult>();
        for (CompatibilityVerifier verifier : this.verifiers) {
            VerificationResult result = verifier.verify();
            if (!result.isNotCompatible()) continue;
            errors.add(result);
        }
        return errors;
    }
}

