/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.springframework.cloud.bootstrap.BootstrapConfiguration;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.style.ToStringCreator;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.StringUtils;

public class BootstrapImportSelector
implements EnvironmentAware,
DeferredImportSelector {
    private Environment environment;
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory();

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public String[] selectImports(AnnotationMetadata annotationMetadata) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<String> names = new ArrayList<String>(SpringFactoriesLoader.loadFactoryNames(BootstrapConfiguration.class, (ClassLoader)classLoader));
        names.addAll(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)this.environment.getProperty("spring.cloud.bootstrap.sources", ""))));
        ArrayList<OrderedAnnotatedElement> elements = new ArrayList<OrderedAnnotatedElement>();
        for (String name : names) {
            try {
                elements.add(new OrderedAnnotatedElement(this.metadataReaderFactory, name));
            }
            catch (IOException e2) {}
        }
        AnnotationAwareOrderComparator.sort(elements);
        String[] classNames = (String[])elements.stream().map(e -> ((OrderedAnnotatedElement)e).name).toArray(String[]::new);
        return classNames;
    }

    class OrderedAnnotatedElement
    implements AnnotatedElement {
        private final String name;
        private Order order = null;
        private Integer value;

        public OrderedAnnotatedElement(MetadataReaderFactory metadataReaderFactory, String name) throws IOException {
            MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(name);
            AnnotationMetadata metadata = metadataReader.getAnnotationMetadata();
            Map attributes = metadata.getAnnotationAttributes(Order.class.getName());
            this.name = name;
            if (attributes != null && attributes.containsKey("value")) {
                this.value = (Integer)attributes.get("value");
                this.order = new Order(){

                    public Class<? extends Annotation> annotationType() {
                        return Order.class;
                    }

                    public int value() {
                        return OrderedAnnotatedElement.this.value;
                    }
                };
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            if (annotationClass == Order.class) {
                return (T)this.order;
            }
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            Annotation[] annotationArray;
            if (this.order == null) {
                annotationArray = new Annotation[]{};
            } else {
                Annotation[] annotationArray2 = new Annotation[1];
                annotationArray = annotationArray2;
                annotationArray2[0] = this.order;
            }
            return annotationArray;
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.getAnnotations();
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("name", (Object)this.name).append("value", (Object)this.value).toString();
        }
    }
}

