/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.beans.ConstructorProperties;
import lombok.NonNull;

public final class Pair<S, T> {
    @NonNull
    private final S first;
    @NonNull
    private final T second;

    public static <S, T> Pair<S, T> of(S first, T second) {
        return new Pair<S, T>(first, second);
    }

    public S getFirst() {
        return this.first;
    }

    public T getSecond() {
        return this.second;
    }

    public String toString() {
        return "Pair(first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        S this$first = this.getFirst();
        S other$first = other.getFirst();
        if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
            return false;
        }
        T this$second = this.getSecond();
        T other$second = other.getSecond();
        return !(this$second == null ? other$second != null : !this$second.equals(other$second));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        S $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : $first.hashCode());
        T $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : $second.hashCode());
        return result;
    }

    @ConstructorProperties(value={"first", "second"})
    private Pair(@NonNull S first, @NonNull T second) {
        if (first == null) {
            throw new IllegalArgumentException("first is null");
        }
        if (second == null) {
            throw new IllegalArgumentException("second is null");
        }
        this.first = first;
        this.second = second;
    }
}

