/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class ReflectionUtils {
    private static final Class<?> JAVA8_STREAM_TYPE;

    private ReflectionUtils() {
    }

    public static <T> T createInstanceIfPresent(String classname, T defaultInstance) {
        try {
            Class<?> type = ClassUtils.getDefaultClassLoader().loadClass(classname);
            return (T)BeanUtils.instantiateClass(type);
        }
        catch (Exception e) {
            return defaultInstance;
        }
    }

    public static boolean isDefaultMethod(Method method) {
        return (method.getModifiers() & 0x409) == 1 && method.getDeclaringClass().isInterface();
    }

    public static Field findField(Class<?> type, final ReflectionUtils.FieldFilter filter) {
        return ReflectionUtils.findField(type, new DescribedFieldFilter(){

            public boolean matches(Field field) {
                return filter.matches(field);
            }

            @Override
            public String getDescription() {
                return String.format("FieldFilter %s", filter.toString());
            }
        }, false);
    }

    public static Field findField(Class<?> type, DescribedFieldFilter filter) {
        return ReflectionUtils.findField(type, filter, true);
    }

    public static Field findField(Class<?> type, DescribedFieldFilter filter, boolean enforceUniqueness) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull((Object)filter, (String)"Filter must not be null!");
        Field foundField = null;
        for (Class<?> targetClass = type; targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            for (Field field : targetClass.getDeclaredFields()) {
                if (!filter.matches(field)) continue;
                if (!enforceUniqueness) {
                    return field;
                }
                if (foundField != null && enforceUniqueness) {
                    throw new IllegalStateException(filter.getDescription());
                }
                foundField = field;
            }
        }
        return foundField;
    }

    public static void setField(Field field, Object target, Object value) {
        org.springframework.util.ReflectionUtils.makeAccessible((Field)field);
        org.springframework.util.ReflectionUtils.setField((Field)field, (Object)target, (Object)value);
    }

    public static boolean isJava8StreamType(Class<?> type) {
        if (type == null || JAVA8_STREAM_TYPE == null) {
            return false;
        }
        return JAVA8_STREAM_TYPE.isAssignableFrom(type);
    }

    public static Constructor<?> findConstructor(Class<?> type, Object ... constructorArguments) {
        Assert.notNull(type, (String)"Target type must not be null!");
        Assert.notNull((Object)constructorArguments, (String)"Constructor arguments must not be null!");
        for (Constructor<?> candidate : type.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = candidate.getParameterTypes();
            if (!ReflectionUtils.argumentsMatch(parameterTypes, constructorArguments)) continue;
            return candidate;
        }
        return null;
    }

    private static final boolean argumentsMatch(Class<?>[] parameterTypes, Object[] arguments) {
        if (parameterTypes.length != arguments.length) {
            return false;
        }
        int index = 0;
        for (Class<?> argumentType : parameterTypes) {
            Object argument = arguments[index];
            if (argumentType.isPrimitive() && argument == null) {
                return false;
            }
            if (argument != null && !ClassUtils.isAssignableValue(argumentType, (Object)argument)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    static {
        Class<?> cls = null;
        try {
            cls = Class.forName("java.util.stream.Stream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        JAVA8_STREAM_TYPE = cls;
    }

    public static class AnnotationFieldFilter
    implements DescribedFieldFilter {
        private final Class<? extends Annotation> annotationType;

        public AnnotationFieldFilter(Class<? extends Annotation> annotationType) {
            Assert.notNull(annotationType, (String)"Annotation type must not be null!");
            this.annotationType = annotationType;
        }

        public boolean matches(Field field) {
            return AnnotationUtils.getAnnotation((AnnotatedElement)field, this.annotationType) != null;
        }

        @Override
        public String getDescription() {
            return String.format("Annotation filter for %s", this.annotationType.getName());
        }
    }

    public static interface DescribedFieldFilter
    extends ReflectionUtils.FieldFilter {
        public String getDescription();
    }
}

