/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class BeanWrapper<T>
implements PersistentPropertyAccessor {
    private final T bean;

    protected BeanWrapper(T bean) {
        Assert.notNull(bean, (String)"Bean must not be null!");
        this.bean = bean;
    }

    @Override
    public void setProperty(PersistentProperty<?> property, @Nullable Object value) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        try {
            if (!property.usePropertyAccess()) {
                Field field = property.getRequiredField();
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, this.bean, (Object)value);
                return;
            }
            Method setter = property.getRequiredSetter();
            ReflectionUtils.makeAccessible((Method)setter);
            ReflectionUtils.invokeMethod((Method)setter, this.bean, (Object[])new Object[]{value});
        }
        catch (IllegalStateException e) {
            throw new MappingException("Could not set object property!", e);
        }
    }

    @Override
    @Nullable
    public Object getProperty(PersistentProperty<?> property) {
        return this.getProperty(property, property.getType());
    }

    @Nullable
    public <S> Object getProperty(PersistentProperty<?> property, Class<? extends S> type) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        try {
            if (!property.usePropertyAccess()) {
                Field field = property.getRequiredField();
                ReflectionUtils.makeAccessible((Field)field);
                return ReflectionUtils.getField((Field)field, this.bean);
            }
            Method getter = property.getRequiredGetter();
            ReflectionUtils.makeAccessible((Method)getter);
            return ReflectionUtils.invokeMethod((Method)getter, this.bean);
        }
        catch (IllegalStateException e) {
            throw new MappingException(String.format("Could not read property %s of %s!", property.toString(), this.bean.toString()), e);
        }
    }

    public T getBean() {
        return this.bean;
    }
}

