/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.mongodb.AbstractMongodbQuery;
import java.util.List;
import java.util.Optional;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbQuery;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QSort;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.util.Assert;

public class QuerydslMongoPredicateExecutor<T>
implements QuerydslPredicateExecutor<T> {
    private final PathBuilder<T> builder;
    private final EntityInformation<T, ?> entityInformation;
    private final MongoOperations mongoOperations;

    public QuerydslMongoPredicateExecutor(MongoEntityInformation<T, ?> entityInformation, MongoOperations mongoOperations) {
        this(entityInformation, mongoOperations, (EntityPathResolver)SimpleEntityPathResolver.INSTANCE);
    }

    public QuerydslMongoPredicateExecutor(MongoEntityInformation<T, ?> entityInformation, MongoOperations mongoOperations, EntityPathResolver resolver) {
        Assert.notNull((Object)resolver, (String)"EntityPathResolver must not be null!");
        EntityPath path = resolver.createPath(entityInformation.getJavaType());
        this.builder = new PathBuilder(path.getType(), path.getMetadata());
        this.entityInformation = entityInformation;
        this.mongoOperations = mongoOperations;
    }

    public Optional<T> findOne(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        try {
            return Optional.ofNullable(this.createQueryFor(predicate).fetchOne());
        }
        catch (NonUniqueResultException ex) {
            throw new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
    }

    public List<T> findAll(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        return this.createQueryFor(predicate).fetch();
    }

    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        Assert.notNull(orders, (String)"Order specifiers must not be null!");
        return ((SpringDataMongodbQuery)this.createQueryFor(predicate).orderBy(orders)).fetch();
    }

    public List<T> findAll(Predicate predicate, Sort sort) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        return this.applySorting(this.createQueryFor(predicate), sort).fetch();
    }

    public Iterable<T> findAll(OrderSpecifier<?> ... orders) {
        Assert.notNull(orders, (String)"Order specifiers must not be null!");
        return ((SpringDataMongodbQuery)this.createQuery().orderBy(orders)).fetch();
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> query = this.createQueryFor(predicate);
        return PageableExecutionUtils.getPage((List)this.applyPagination(query, pageable).fetch(), (Pageable)pageable, () -> query.fetchCount());
    }

    public long count(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        return this.createQueryFor(predicate).fetchCount();
    }

    public boolean exists(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        return this.createQueryFor(predicate).fetchCount() > 0L;
    }

    private AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> createQueryFor(Predicate predicate) {
        return this.createQuery().where(predicate);
    }

    private AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> createQuery() {
        return new SpringDataMongodbQuery(this.mongoOperations, this.entityInformation.getJavaType());
    }

    private AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> applyPagination(AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> query, Pageable pageable) {
        query = ((SpringDataMongodbQuery)query.offset(pageable.getOffset())).limit(pageable.getPageSize());
        return this.applySorting(query, pageable.getSort());
    }

    private AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> applySorting(AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> query, Sort sort) {
        if (sort instanceof QSort) {
            List orderSpecifiers = ((QSort)sort).getOrderSpecifiers();
            query.orderBy(orderSpecifiers.toArray(new OrderSpecifier[orderSpecifiers.size()]));
            return query;
        }
        sort.stream().map(this::toOrder).forEach(arg_0 -> query.orderBy(arg_0));
        return query;
    }

    private OrderSpecifier<?> toOrder(Sort.Order order) {
        PathBuilder property = this.builder.get(order.getProperty());
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, (Expression)property);
    }
}

