/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.ClusterStateFailureException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.FallbackExceptionTranslationStrategy;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.ClusterNodeResourceProvider;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.ClusterTopology;
import org.springframework.data.redis.connection.ClusterTopologyProvider;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisMessageListener;
import org.springframework.data.redis.connection.jedis.JedisSubscription;
import org.springframework.data.redis.connection.util.ByteArraySet;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.geo.GeoRadiusParam;

public class JedisClusterConnection
implements RedisClusterConnection {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new FallbackExceptionTranslationStrategy(JedisConverters.exceptionConverter());
    private final Log log = LogFactory.getLog(this.getClass());
    private final JedisCluster cluster;
    private boolean closed;
    private final JedisClusterTopologyProvider topologyProvider;
    private ClusterCommandExecutor clusterCommandExecutor;
    private final boolean disposeClusterCommandExecutorOnClose;
    private volatile JedisSubscription subscription;

    public JedisClusterConnection(JedisCluster cluster) {
        Assert.notNull((Object)cluster, (String)"JedisCluster must not be null.");
        this.cluster = cluster;
        this.closed = false;
        this.topologyProvider = new JedisClusterTopologyProvider(cluster);
        this.clusterCommandExecutor = new ClusterCommandExecutor(this.topologyProvider, new JedisClusterNodeResourceProvider(cluster, this.topologyProvider), EXCEPTION_TRANSLATION);
        this.disposeClusterCommandExecutorOnClose = true;
        try {
            DirectFieldAccessor dfa = new DirectFieldAccessor((Object)cluster);
            this.clusterCommandExecutor.setMaxRedirects((Integer)dfa.getPropertyValue("maxRedirections"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JedisClusterConnection(JedisCluster cluster, ClusterCommandExecutor executor) {
        Assert.notNull((Object)cluster, (String)"JedisCluster must not be null.");
        Assert.notNull((Object)executor, (String)"ClusterCommandExecutor must not be null.");
        this.closed = false;
        this.cluster = cluster;
        this.topologyProvider = new JedisClusterTopologyProvider(cluster);
        this.clusterCommandExecutor = executor;
        this.disposeClusterCommandExecutorOnClose = false;
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        throw new UnsupportedOperationException("Execute is currently not supported in cluster mode.");
    }

    @Override
    public Long del(byte[] ... keys) {
        Assert.noNullElements((Object[])keys, (String)"Keys must not be null or contain null key!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.cluster.del(keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        return this.clusterCommandExecutor.executeMuliKeyCommand(new JedisMultiKeyClusterCommandCallback<Long>(){

            @Override
            public Long doInCluster(Jedis client, byte[] key) {
                return client.del(key);
            }
        }, Arrays.asList(keys)).resultsAsList().size();
    }

    @Override
    public DataType type(byte[] key) {
        try {
            return JedisConverters.toDataType(this.cluster.type(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> keys(final byte[] pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        List<Set<byte[]>> keysPerNode = this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInCluster(Jedis client) {
                return client.keys(pattern);
            }
        }).resultsAsList();
        HashSet<byte[]> keys = new HashSet<byte[]>();
        for (Set set : keysPerNode) {
            keys.addAll(set);
        }
        return keys;
    }

    @Override
    public Set<byte[]> keys(RedisClusterNode node, final byte[] pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInCluster(Jedis client) {
                return client.keys(pattern);
            }
        }, node).getValue();
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        throw new InvalidDataAccessApiUsageException("Scan is not supported accros multiple nodes within a cluster");
    }

    @Override
    public byte[] randomKey() {
        ArrayList<RedisClusterNode> nodes = new ArrayList<RedisClusterNode>(this.topologyProvider.getTopology().getActiveMasterNodes());
        HashSet<RedisClusterNode> inspectedNodes = new HashSet<RedisClusterNode>(nodes.size());
        do {
            RedisClusterNode node = (RedisClusterNode)nodes.get(new Random().nextInt(nodes.size()));
            while (inspectedNodes.contains(node)) {
                node = (RedisClusterNode)nodes.get(new Random().nextInt(nodes.size()));
            }
            inspectedNodes.add(node);
            byte[] key = this.randomKey(node);
            if (key == null || key.length <= 0) continue;
            return key;
        } while (nodes.size() != inspectedNodes.size());
        return null;
    }

    @Override
    public byte[] randomKey(RedisClusterNode node) {
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<byte[]>(){

            @Override
            public byte[] doInCluster(Jedis client) {
                return client.randomBinaryKey();
            }
        }, node).getValue();
    }

    @Override
    public void rename(byte[] sourceKey, byte[] targetKey) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sourceKey, targetKey)) {
            try {
                this.cluster.rename(sourceKey, targetKey);
                return;
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        byte[] value = this.dump(sourceKey);
        if (value != null && value.length > 0) {
            this.restore(targetKey, 0L, value);
            this.del(new byte[][]{sourceKey});
        }
    }

    @Override
    public Boolean renameNX(byte[] sourceKey, byte[] targetKey) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sourceKey, targetKey)) {
            try {
                return JedisConverters.toBoolean(this.cluster.renamenx(sourceKey, targetKey));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        byte[] value = this.dump(sourceKey);
        if (value != null && value.length > 0 && !this.exists(targetKey).booleanValue()) {
            this.restore(targetKey, 0L, value);
            this.del(new byte[][]{sourceKey});
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        if (seconds > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Jedis does not support seconds exceeding Integer.MAX_VALUE.");
        }
        try {
            return JedisConverters.toBoolean(this.cluster.expire(key, Long.valueOf(seconds).intValue()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        try {
            return JedisConverters.toBoolean(this.cluster.pexpire(key, millis));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        try {
            return JedisConverters.toBoolean(this.cluster.expireAt(key, unixTime));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        try {
            return JedisConverters.toBoolean(this.cluster.pexpireAt(key, unixTimeInMillis));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        try {
            return JedisConverters.toBoolean(this.cluster.persist(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        throw new UnsupportedOperationException("Cluster mode does not allow moving keys.");
    }

    @Override
    public Long ttl(byte[] key) {
        try {
            return this.cluster.ttl(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key, TimeUnit timeUnit) {
        try {
            return Converters.secondsToTimeUnit(this.cluster.ttl(key), timeUnit);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long pTtl(final byte[] key) {
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<Long>(){

            @Override
            public Long doInCluster(Jedis client) {
                return client.pttl(key);
            }
        }, this.topologyProvider.getTopology().getKeyServingMasterNode(key)).getValue();
    }

    @Override
    public Long pTtl(final byte[] key, final TimeUnit timeUnit) {
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<Long>(){

            @Override
            public Long doInCluster(Jedis client) {
                return Converters.millisecondsToTimeUnit(client.pttl(key), timeUnit);
            }
        }, this.topologyProvider.getTopology().getKeyServingMasterNode(key)).getValue();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        try {
            return this.cluster.sort(key, JedisConverters.toSortingParams(params));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        List<byte[]> sorted = this.sort(key, params);
        if (!CollectionUtils.isEmpty(sorted)) {
            byte[][] arr = new byte[sorted.size()][];
            switch (this.type(key)) {
                case SET: {
                    this.sAdd(storeKey, (byte[][])sorted.toArray((T[])arr));
                    return 1L;
                }
                case LIST: {
                    this.lPush(storeKey, (byte[][])sorted.toArray((T[])arr));
                    return 1L;
                }
            }
            throw new IllegalArgumentException("sort and store is only supported for SET and LIST");
        }
        return 0L;
    }

    @Override
    public byte[] dump(final byte[] key) {
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<byte[]>(){

            @Override
            public byte[] doInCluster(Jedis client) {
                return client.dump(key);
            }
        }, this.topologyProvider.getTopology().getKeyServingMasterNode(key)).getValue();
    }

    @Override
    public void restore(final byte[] key, final long ttlInMillis, final byte[] serializedValue) {
        if (ttlInMillis > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Jedis does not support ttlInMillis exceeding Integer.MAX_VALUE.");
        }
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.restore(key, Long.valueOf(ttlInMillis).intValue(), serializedValue);
            }
        }, this.clusterGetNodeForKey(key));
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            return this.cluster.get(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        try {
            return this.cluster.getSet(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return this.cluster.mget(keys);
        }
        return this.clusterCommandExecutor.executeMuliKeyCommand(new JedisMultiKeyClusterCommandCallback<byte[]>(){

            @Override
            public byte[] doInCluster(Jedis client, byte[] key) {
                return client.get(key);
            }
        }, Arrays.asList(keys)).resultsAsListSortBy(keys);
    }

    @Override
    public void set(byte[] key, byte[] value) {
        try {
            this.cluster.set(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        if (expiration == null || expiration.isPersistent()) {
            if (option == null || ObjectUtils.nullSafeEquals((Object)((Object)RedisStringCommands.SetOption.UPSERT), (Object)((Object)option))) {
                this.set(key, value);
            } else {
                if (ObjectUtils.nullSafeEquals((Object)((Object)RedisStringCommands.SetOption.SET_IF_PRESENT), (Object)((Object)option))) {
                    throw new UnsupportedOperationException("Jedis does not support SET XX without PX or EX on BinaryCluster.");
                }
                this.setNX(key, value);
            }
        } else if (option == null || ObjectUtils.nullSafeEquals((Object)((Object)RedisStringCommands.SetOption.UPSERT), (Object)((Object)option))) {
            if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)expiration.getTimeUnit()))) {
                this.pSetEx(key, expiration.getExpirationTime(), value);
            } else {
                this.setEx(key, expiration.getExpirationTime(), value);
            }
        } else {
            byte[] nxxx = JedisConverters.toSetCommandNxXxArgument(option);
            byte[] expx = JedisConverters.toSetCommandExPxArgument(expiration);
            try {
                this.cluster.set(key, value, nxxx, expx, expiration.getExpirationTime());
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        try {
            return JedisConverters.toBoolean(this.cluster.setnx(key, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long seconds, byte[] value) {
        if (seconds > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Seconds have cannot exceed Integer.MAX_VALUE!");
        }
        try {
            this.cluster.setex(key, Long.valueOf(seconds).intValue(), value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void pSetEx(final byte[] key, final long milliseconds, final byte[] value) {
        if (milliseconds > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Milliseconds have cannot exceed Integer.MAX_VALUE!");
        }
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.psetex(key, milliseconds, value);
            }
        }, this.topologyProvider.getTopology().getKeyServingMasterNode(key));
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys((byte[][])tuples.keySet().toArray((T[])new byte[tuples.keySet().size()][]))) {
            try {
                this.cluster.mset(JedisConverters.toByteArrays(tuples));
                return;
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        for (Map.Entry<byte[], byte[]> entry : tuples.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, (String)"Tuple must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys((byte[][])tuples.keySet().toArray((T[])new byte[tuples.keySet().size()][]))) {
            try {
                return JedisConverters.toBoolean(this.cluster.msetnx(JedisConverters.toByteArrays(tuples)));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        boolean result = true;
        for (Map.Entry<byte[], byte[]> entry : tuples.entrySet()) {
            if (this.setNX(entry.getKey(), entry.getValue()).booleanValue() || !result) continue;
            result = false;
        }
        return result;
    }

    @Override
    public Long incr(byte[] key) {
        try {
            return this.cluster.incr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        try {
            return this.cluster.incrBy(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        try {
            return this.cluster.incrByFloat(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        try {
            return this.cluster.decr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        try {
            return this.cluster.decrBy(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        try {
            return this.cluster.append(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long begin, long end) {
        try {
            return this.cluster.getrange(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long offset) {
        try {
            this.cluster.setrange(key, offset, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        try {
            return this.cluster.getbit(key, offset);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        try {
            return this.cluster.setbit(key, offset, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key) {
        try {
            return this.cluster.bitcount(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key, long begin, long end) {
        try {
            return this.cluster.bitcount(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        byte[][] allKeys = ByteUtils.mergeArrays(destination, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.cluster.bitop(JedisConverters.toBitOp(op), destination, keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("BITOP is only supported for same slot keys in cluster mode.");
    }

    @Override
    public Long strLen(byte[] key) {
        try {
            return this.cluster.strlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        try {
            return this.cluster.rpush(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        try {
            return this.cluster.lpush(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        try {
            return this.cluster.rpushx(key, (byte[][])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        try {
            return this.cluster.lpushx(key, (byte[][])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        try {
            return this.cluster.llen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long begin, long end) {
        try {
            return this.cluster.lrange(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long begin, long end) {
        try {
            this.cluster.ltrim(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        try {
            return this.cluster.lindex(key, index);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        try {
            return this.cluster.linsert(key, JedisConverters.toListPosition(where), pivot, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        try {
            this.cluster.lset(key, index, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        try {
            return this.cluster.lrem(key, count, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        try {
            return this.cluster.lpop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        try {
            return this.cluster.rpop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(final int timeout, byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.cluster.blpop(timeout, keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        return this.clusterCommandExecutor.executeMuliKeyCommand(new JedisMultiKeyClusterCommandCallback<List<byte[]>>(){

            @Override
            public List<byte[]> doInCluster(Jedis client, byte[] key) {
                return client.blpop(timeout, (byte[][])new byte[][]{key});
            }
        }, Arrays.asList(keys)).getFirstNonNullNotEmptyOrDefault(Collections.emptyList());
    }

    @Override
    public List<byte[]> bRPop(final int timeout, byte[] ... keys) {
        return this.clusterCommandExecutor.executeMuliKeyCommand(new JedisMultiKeyClusterCommandCallback<List<byte[]>>(){

            @Override
            public List<byte[]> doInCluster(Jedis client, byte[] key) {
                return client.brpop(timeout, (byte[][])new byte[][]{key});
            }
        }, Arrays.asList(keys)).getFirstNonNullNotEmptyOrDefault(Collections.emptyList());
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, dstKey)) {
            try {
                return this.cluster.rpoplpush(srcKey, dstKey);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        byte[] val = this.rPop(srcKey);
        this.lPush(dstKey, new byte[][]{val});
        return val;
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, dstKey)) {
            try {
                return this.cluster.brpoplpush(srcKey, dstKey, timeout);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        List<byte[]> val = this.bRPop(timeout, new byte[][]{srcKey});
        if (!CollectionUtils.isEmpty(val)) {
            this.lPush(dstKey, new byte[][]{val.get(1)});
            return val.get(1);
        }
        return null;
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        try {
            return this.cluster.sadd(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        try {
            return this.cluster.srem(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        try {
            return this.cluster.spop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, destKey)) {
            try {
                return JedisConverters.toBoolean(this.cluster.smove(srcKey, destKey, value));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        if (this.exists(srcKey).booleanValue() && this.sRem(srcKey, new byte[][]{value}) > 0L && !this.sIsMember(destKey, value).booleanValue()) {
            return JedisConverters.toBoolean(this.sAdd(destKey, new byte[][]{value}));
        }
        return Boolean.FALSE;
    }

    @Override
    public Long sCard(byte[] key) {
        try {
            return this.cluster.scard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        try {
            return this.cluster.sismember(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.cluster.sinter(keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        List<Set<byte[]>> resultList = this.clusterCommandExecutor.executeMuliKeyCommand(new JedisMultiKeyClusterCommandCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInCluster(Jedis client, byte[] key) {
                return client.smembers(key);
            }
        }, Arrays.asList(keys)).resultsAsList();
        ByteArraySet result = null;
        for (Set set : resultList) {
            ByteArraySet tmp = new ByteArraySet(set);
            if (result == null) {
                result = tmp;
                continue;
            }
            result.retainAll(tmp);
            if (!result.isEmpty()) continue;
            break;
        }
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        return result.asRawSet();
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.cluster.sinterstore(destKey, keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        Set<byte[]> result = this.sInter(keys);
        if (result.isEmpty()) {
            return 0L;
        }
        return this.sAdd(destKey, (byte[][])result.toArray((T[])new byte[result.size()][]));
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.cluster.sunion(keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        List<Set<byte[]>> resultList = this.clusterCommandExecutor.executeMuliKeyCommand(new JedisMultiKeyClusterCommandCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInCluster(Jedis client, byte[] key) {
                return client.smembers(key);
            }
        }, Arrays.asList(keys)).resultsAsList();
        ByteArraySet result = new ByteArraySet();
        for (Set set : resultList) {
            result.addAll(set);
        }
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        return result.asRawSet();
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.cluster.sunionstore(destKey, keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        Set<byte[]> result = this.sUnion(keys);
        if (result.isEmpty()) {
            return 0L;
        }
        return this.sAdd(destKey, (byte[][])result.toArray((T[])new byte[result.size()][]));
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.cluster.sdiff(keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        byte[] source = keys[0];
        byte[][] others = (byte[][])Arrays.copyOfRange(keys, 1, keys.length);
        ByteArraySet values = new ByteArraySet(this.sMembers(source));
        List<Set<byte[]>> resultList = this.clusterCommandExecutor.executeMuliKeyCommand(new JedisMultiKeyClusterCommandCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInCluster(Jedis client, byte[] key) {
                return client.smembers(key);
            }
        }, Arrays.asList(others)).resultsAsList();
        if (values.isEmpty()) {
            return Collections.emptySet();
        }
        for (Set set : resultList) {
            values.removeAll(set);
        }
        return values.asRawSet();
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.cluster.sdiffstore(destKey, keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        Set<byte[]> diff = this.sDiff(keys);
        if (diff.isEmpty()) {
            return 0L;
        }
        return this.sAdd(destKey, (byte[][])diff.toArray((T[])new byte[diff.size()][]));
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        try {
            return this.cluster.smembers(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        try {
            return this.cluster.srandmember(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        if (count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return this.cluster.srandmember(key, Long.valueOf(count).intValue());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Cursor<byte[]> sScan(final byte[] key, ScanOptions options) {
        return new ScanCursor<byte[]>(options){

            @Override
            protected ScanIteration<byte[]> doScan(long cursorId, ScanOptions options) {
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisClusterConnection.this.cluster.sscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<byte[]>(Long.valueOf(result.getStringCursor()), result.getResult());
            }
        }.open();
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        try {
            return JedisConverters.toBoolean(this.cluster.zadd(key, score, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        try {
            return this.cluster.zadd(key, JedisConverters.toTupleMap(tuples));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        try {
            return this.cluster.zrem(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        try {
            return this.cluster.zincrby(key, increment, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        try {
            return this.cluster.zrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        try {
            return this.cluster.zrevrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long begin, long end) {
        try {
            return this.cluster.zrange(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        return this.zRangeByScoreWithScores(key, range, null);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZRANGEBYSCOREWITHSCORES.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit != null) {
                return JedisConverters.toTupleSet(this.cluster.zrangeByScoreWithScores(key, min, max, limit.getOffset(), limit.getCount()));
            }
            return JedisConverters.toTupleSet(this.cluster.zrangeByScoreWithScores(key, min, max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return this.zRevRangeByScore(key, range, null);
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZREVRANGEBYSCORE.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit != null) {
                return this.cluster.zrevrangeByScore(key, max, min, limit.getOffset(), limit.getCount());
            }
            return this.cluster.zrevrangeByScore(key, max, min);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        return this.zRevRangeByScoreWithScores(key, range, null);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZREVRANGEBYSCOREWITHSCORES.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit != null) {
                return JedisConverters.toTupleSet(this.cluster.zrevrangeByScoreWithScores(key, max, min, limit.getOffset(), limit.getCount()));
            }
            return JedisConverters.toTupleSet(this.cluster.zrevrangeByScoreWithScores(key, max, min));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZCOUNT.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            return this.cluster.zcount(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZREMRANGEBYSCORE.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            return this.cluster.zremrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return this.zRangeByScore(key, range, null);
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZRANGEBYSCORE.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit != null) {
                return this.cluster.zrangeByScore(key, min, max, limit.getOffset(), limit.getCount());
            }
            return this.cluster.zrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key) {
        return this.zRangeByLex(key, RedisZSetCommands.Range.unbounded());
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range) {
        return this.zRangeByLex(key, range, null);
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZRANGEBYLEX.");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getMin(), JedisConverters.toBytes("-"));
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getMax(), JedisConverters.toBytes("+"));
        try {
            if (limit != null) {
                return this.cluster.zrangeByLex(key, min, max, limit.getOffset(), limit.getCount());
            }
            return this.cluster.zrangeByLex(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long begin, long end) {
        try {
            return JedisConverters.toTupleSet(this.cluster.zrangeWithScores(key, begin, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        try {
            return this.cluster.zrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            return JedisConverters.toTupleSet(this.cluster.zrangeByScoreWithScores(key, min, max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return this.cluster.zrangeByScore(key, min, max, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return JedisConverters.toTupleSet(this.cluster.zrangeByScoreWithScores(key, min, max, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long begin, long end) {
        try {
            return this.cluster.zrevrange(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long begin, long end) {
        try {
            return JedisConverters.toTupleSet(this.cluster.zrevrangeWithScores(key, begin, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        try {
            return this.cluster.zrevrangeByScore(key, max, min);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            return JedisConverters.toTupleSet(this.cluster.zrevrangeByScoreWithScores(key, max, min));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return this.cluster.zrevrangeByScore(key, max, min, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return JedisConverters.toTupleSet(this.cluster.zrevrangeByScoreWithScores(key, max, min, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        try {
            return this.cluster.zcount(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        try {
            return this.cluster.zcard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        try {
            return this.cluster.zscore(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long begin, long end) {
        try {
            return this.cluster.zremrangeByRank(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        try {
            return this.cluster.zremrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.cluster.zunionstore(destKey, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZUNIONSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            try {
                return this.cluster.zunionstore(destKey, zparams, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZUNIONSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.cluster.zinterstore(destKey, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZINTERSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            try {
                return this.cluster.zinterstore(destKey, zparams, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new IllegalArgumentException("ZINTERSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(final byte[] key, ScanOptions options) {
        return new ScanCursor<RedisZSetCommands.Tuple>(options){

            @Override
            protected ScanIteration<RedisZSetCommands.Tuple> doScan(long cursorId, ScanOptions options) {
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisClusterConnection.this.cluster.zscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<RedisZSetCommands.Tuple>(Long.valueOf(result.getStringCursor()), JedisConverters.tuplesToTuples().convert(result.getResult()));
            }
        }.open();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        try {
            return this.cluster.zrangeByScore(key, JedisConverters.toBytes(min), JedisConverters.toBytes(max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return this.cluster.zrangeByScore(key, JedisConverters.toBytes(min), JedisConverters.toBytes(max), Long.valueOf(offset).intValue(), Long.valueOf(count).intValue());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        try {
            return JedisConverters.toBoolean(this.cluster.hset(key, field, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        try {
            return JedisConverters.toBoolean(this.cluster.hsetnx(key, field, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        try {
            return this.cluster.hget(key, field);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        try {
            return this.cluster.hmget(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        try {
            this.cluster.hmset(key, hashes);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        try {
            return this.cluster.hincrBy(key, field, delta);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        try {
            return this.cluster.hincrByFloat(key, field, delta);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        try {
            return this.cluster.hexists(key, field);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        try {
            return this.cluster.hdel(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        try {
            return this.cluster.hlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        try {
            return this.cluster.hkeys(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        try {
            return new ArrayList<byte[]>(this.cluster.hvals(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        try {
            return this.cluster.hgetAll(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(final byte[] key, ScanOptions options) {
        return new ScanCursor<Map.Entry<byte[], byte[]>>(options){

            @Override
            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(long cursorId, ScanOptions options) {
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisClusterConnection.this.cluster.hscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<Map.Entry<byte[], byte[]>>(Long.valueOf(result.getStringCursor()), result.getResult());
            }
        }.open();
    }

    @Override
    public void multi() {
        throw new InvalidDataAccessApiUsageException("MUTLI is currently not supported in cluster mode.");
    }

    @Override
    public List<Object> exec() {
        throw new InvalidDataAccessApiUsageException("EXEC is currently not supported in cluster mode.");
    }

    @Override
    public void discard() {
        throw new InvalidDataAccessApiUsageException("DISCARD is currently not supported in cluster mode.");
    }

    @Override
    public void watch(byte[] ... keys) {
        throw new InvalidDataAccessApiUsageException("WATCH is currently not supported in cluster mode.");
    }

    @Override
    public void unwatch() {
        throw new InvalidDataAccessApiUsageException("UNWATCH is currently not supported in cluster mode.");
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        try {
            return this.cluster.publish(channel, message);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        try {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, channels, null);
            this.cluster.subscribe((BinaryJedisPubSub)jedisPubSub, channels);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        try {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, null, patterns);
            this.cluster.psubscribe((BinaryJedisPubSub)jedisPubSub, patterns);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long geoAdd(byte[] key, Point point, byte[] member) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)point, (String)"Point must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        try {
            return this.cluster.geoadd(key, point.getX(), point.getY(), member);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long geoAdd(byte[] key, RedisGeoCommands.GeoLocation<byte[]> location) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(location, (String)"Location must not be null!");
        return this.geoAdd(key, location.getPoint(), location.getName());
    }

    @Override
    public Long geoAdd(byte[] key, Map<byte[], Point> memberCoordinateMap) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(memberCoordinateMap, (String)"MemberCoordinateMap must not be null!");
        HashMap<byte[], GeoCoordinate> redisGeoCoordinateMap = new HashMap<byte[], GeoCoordinate>();
        for (byte[] mapKey : memberCoordinateMap.keySet()) {
            redisGeoCoordinateMap.put(mapKey, JedisConverters.toGeoCoordinate(memberCoordinateMap.get(mapKey)));
        }
        try {
            return this.cluster.geoadd(key, redisGeoCoordinateMap);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long geoAdd(byte[] key, Iterable<RedisGeoCommands.GeoLocation<byte[]>> locations) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(locations, (String)"Locations must not be null!");
        HashMap<byte[], GeoCoordinate> redisGeoCoordinateMap = new HashMap<byte[], GeoCoordinate>();
        for (RedisGeoCommands.GeoLocation<byte[]> location : locations) {
            redisGeoCoordinateMap.put(location.getName(), JedisConverters.toGeoCoordinate(location.getPoint()));
        }
        try {
            return this.cluster.geoadd(key, redisGeoCoordinateMap);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member1, (String)"Member1 must not be null!");
        Assert.notNull((Object)member2, (String)"Member2 must not be null!");
        try {
            return (Distance)JedisConverters.distanceConverterForMetric(RedisGeoCommands.DistanceUnit.METERS).convert((Object)this.cluster.geodist(key, member1, member2));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2, Metric metric) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member1, (String)"Member1 must not be null!");
        Assert.notNull((Object)member2, (String)"Member2 must not be null!");
        Assert.notNull((Object)metric, (String)"Metric must not be null!");
        GeoUnit geoUnit = JedisConverters.toGeoUnit(metric);
        try {
            return (Distance)JedisConverters.distanceConverterForMetric(metric).convert((Object)this.cluster.geodist(key, member1, member2, geoUnit));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<String> geoHash(byte[] key, byte[] ... members) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)members, (String)"Members must not be null!");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null!");
        try {
            return JedisConverters.toStrings(this.cluster.geohash(key, members));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Point> geoPos(byte[] key, byte[] ... members) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)members, (String)"Members must not be null!");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null!");
        try {
            return JedisConverters.geoCoordinateToPointConverter().convert(this.cluster.geopos(key, members));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)within, (String)"Within must not be null!");
        try {
            return (GeoResults)JedisConverters.geoRadiusResponseToGeoResultsConverter(within.getRadius().getMetric()).convert((Object)this.cluster.georadius(key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), JedisConverters.toGeoUnit(within.getRadius().getMetric())));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)within, (String)"Within must not be null!");
        Assert.notNull((Object)args, (String)"Args must not be null!");
        GeoRadiusParam geoRadiusParam = JedisConverters.toGeoRadiusParam(args);
        try {
            return (GeoResults)JedisConverters.geoRadiusResponseToGeoResultsConverter(within.getRadius().getMetric()).convert((Object)this.cluster.georadius(key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), JedisConverters.toGeoUnit(within.getRadius().getMetric()), geoRadiusParam));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, double radius) {
        return this.geoRadiusByMember(key, member, new Distance(radius, (Metric)RedisGeoCommands.DistanceUnit.METERS));
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        Assert.notNull((Object)radius, (String)"Radius must not be null!");
        GeoUnit geoUnit = JedisConverters.toGeoUnit(radius.getMetric());
        try {
            return (GeoResults)JedisConverters.geoRadiusResponseToGeoResultsConverter(radius.getMetric()).convert((Object)this.cluster.georadiusByMember(key, member, radius.getValue(), geoUnit));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        Assert.notNull((Object)radius, (String)"Radius must not be null!");
        Assert.notNull((Object)args, (String)"Args must not be null!");
        GeoUnit geoUnit = JedisConverters.toGeoUnit(radius.getMetric());
        GeoRadiusParam geoRadiusParam = JedisConverters.toGeoRadiusParam(args);
        try {
            return (GeoResults)JedisConverters.geoRadiusResponseToGeoResultsConverter(radius.getMetric()).convert((Object)this.cluster.georadiusByMember(key, member, radius.getValue(), geoUnit, geoRadiusParam));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long geoRemove(byte[] key, byte[] ... members) {
        return this.zRem(key, members);
    }

    @Override
    public void select(int dbIndex) {
        if (dbIndex != 0) {
            throw new InvalidDataAccessApiUsageException("Cannot SELECT non zero index in cluster mode.");
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            return this.cluster.echo(message);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public String ping() {
        return !this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.ping();
            }
        }).resultsAsList().isEmpty() ? "PONG" : null;
    }

    @Override
    public String ping(RedisClusterNode node) {
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.ping();
            }
        }, node).getValue();
    }

    @Override
    public void bgWriteAof() {
        this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.bgrewriteaof();
            }
        });
    }

    @Override
    public void bgReWriteAof(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.bgrewriteaof();
            }
        }, node);
    }

    @Override
    public void bgReWriteAof() {
        this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.bgrewriteaof();
            }
        });
    }

    @Override
    public void bgSave() {
        this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.bgsave();
            }
        });
    }

    @Override
    public void bgSave(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.bgsave();
            }
        }, node);
    }

    @Override
    public Long lastSave() {
        ArrayList<Long> result = new ArrayList<Long>(this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<Long>(){

            @Override
            public Long doInCluster(Jedis client) {
                return client.lastsave();
            }
        }).resultsAsList());
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        Collections.sort(result, Collections.reverseOrder());
        return (Long)result.get(0);
    }

    @Override
    public Long lastSave(RedisClusterNode node) {
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<Long>(){

            @Override
            public Long doInCluster(Jedis client) {
                return client.lastsave();
            }
        }, node).getValue();
    }

    @Override
    public void save() {
        this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.save();
            }
        });
    }

    @Override
    public void save(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.save();
            }
        }, node);
    }

    @Override
    public Long dbSize() {
        List<Long> dbSizes = this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<Long>(){

            @Override
            public Long doInCluster(Jedis client) {
                return client.dbSize();
            }
        }).resultsAsList();
        if (CollectionUtils.isEmpty(dbSizes)) {
            return 0L;
        }
        Long size = 0L;
        for (Long value : dbSizes) {
            size = size + value;
        }
        return size;
    }

    @Override
    public Long dbSize(RedisClusterNode node) {
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<Long>(){

            @Override
            public Long doInCluster(Jedis client) {
                return client.dbSize();
            }
        }, node).getValue();
    }

    @Override
    public void flushDb() {
        this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.flushDB();
            }
        });
    }

    @Override
    public void flushDb(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.flushDB();
            }
        }, node);
    }

    @Override
    public void flushAll() {
        this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.flushAll();
            }
        });
    }

    @Override
    public void flushAll(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.flushAll();
            }
        }, node);
    }

    @Override
    public Properties info() {
        Properties infos = new Properties();
        List<ClusterCommandExecutor.NodeResult<Properties>> nodeResults = this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<Properties>(){

            @Override
            public Properties doInCluster(Jedis client) {
                return JedisConverters.toProperties(client.info());
            }
        }).getResults();
        for (ClusterCommandExecutor.NodeResult<Properties> nodePorperties : nodeResults) {
            for (Map.Entry<Object, Object> entry : nodePorperties.getValue().entrySet()) {
                infos.put(nodePorperties.getNode().asString() + "." + entry.getKey(), entry.getValue());
            }
        }
        return infos;
    }

    @Override
    public Properties info(RedisClusterNode node) {
        return JedisConverters.toProperties(this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.info();
            }
        }, node).getValue());
    }

    @Override
    public Properties info(final String section) {
        Properties infos = new Properties();
        List<ClusterCommandExecutor.NodeResult<Properties>> nodeResults = this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<Properties>(){

            @Override
            public Properties doInCluster(Jedis client) {
                return JedisConverters.toProperties(client.info(section));
            }
        }).getResults();
        for (ClusterCommandExecutor.NodeResult<Properties> nodePorperties : nodeResults) {
            for (Map.Entry<Object, Object> entry : nodePorperties.getValue().entrySet()) {
                infos.put(nodePorperties.getNode().asString() + "." + entry.getKey(), entry.getValue());
            }
        }
        return infos;
    }

    @Override
    public Properties info(RedisClusterNode node, final String section) {
        return JedisConverters.toProperties(this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.info(section);
            }
        }, node).getValue());
    }

    @Override
    public void shutdown() {
        this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.shutdown();
            }
        });
    }

    @Override
    public void shutdown(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.shutdown();
            }
        }, node);
    }

    @Override
    public void shutdown(RedisServerCommands.ShutdownOption option) {
        if (option == null) {
            this.shutdown();
            return;
        }
        throw new IllegalArgumentException("Shutdown with options is not supported for jedis.");
    }

    @Override
    public List<String> getConfig(final String pattern) {
        List<ClusterCommandExecutor.NodeResult<List<String>>> mapResult = this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<List<String>>(){

            @Override
            public List<String> doInCluster(Jedis client) {
                return client.configGet(pattern);
            }
        }).getResults();
        ArrayList<String> result = new ArrayList<String>();
        for (ClusterCommandExecutor.NodeResult<List<String>> entry : mapResult) {
            String prefix = entry.getNode().asString();
            int i = 0;
            for (String value : entry.getValue()) {
                result.add((i++ % 2 == 0 ? prefix + "." : "") + value);
            }
        }
        return result;
    }

    @Override
    public List<String> getConfig(RedisClusterNode node, final String pattern) {
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<List<String>>(){

            @Override
            public List<String> doInCluster(Jedis client) {
                return client.configGet(pattern);
            }
        }, node).getValue();
    }

    @Override
    public void setConfig(final String param, final String value) {
        this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.configSet(param, value);
            }
        });
    }

    @Override
    public void setConfig(RedisClusterNode node, final String param, final String value) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.configSet(param, value);
            }
        }, node);
    }

    @Override
    public void resetConfigStats() {
        this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.configResetStat();
            }
        });
    }

    @Override
    public void resetConfigStats(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.configResetStat();
            }
        }, node);
    }

    @Override
    public Long time() {
        return this.convertListOfStringToTime(this.clusterCommandExecutor.executeCommandOnArbitraryNode(new JedisClusterCommandCallback<List<String>>(){

            @Override
            public List<String> doInCluster(Jedis client) {
                return client.time();
            }
        }).getValue());
    }

    @Override
    public Long time(RedisClusterNode node) {
        return this.convertListOfStringToTime(this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<List<String>>(){

            @Override
            public List<String> doInCluster(Jedis client) {
                return client.time();
            }
        }, node).getValue());
    }

    private Long convertListOfStringToTime(List<String> serverTimeInformation) {
        Assert.notEmpty(serverTimeInformation, (String)"Received invalid result from server. Expected 2 items in collection.");
        Assert.isTrue((serverTimeInformation.size() == 2 ? 1 : 0) != 0, (String)("Received invalid number of arguments from redis server. Expected 2 received " + serverTimeInformation.size()));
        return Converters.toTimeMillis(serverTimeInformation.get(0), serverTimeInformation.get(1));
    }

    @Override
    public void killClient(String host, int port) {
        final String hostAndPort = String.format("%s:%s", host, port);
        this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.clientKill(hostAndPort);
            }
        });
    }

    @Override
    public void setClientName(byte[] name) {
        throw new InvalidDataAccessApiUsageException("CLIENT SETNAME is not supported in cluster environment.");
    }

    @Override
    public String getClientName() {
        throw new InvalidDataAccessApiUsageException("CLIENT GETNAME is not supported in cluster environment.");
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        List<String> map = this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.clientList();
            }
        }).resultsAsList();
        ArrayList<RedisClientInfo> result = new ArrayList<RedisClientInfo>();
        for (String infos : map) {
            result.addAll(JedisConverters.toListOfRedisClientInformation(infos));
        }
        return result;
    }

    @Override
    public List<RedisClientInfo> getClientList(RedisClusterNode node) {
        return JedisConverters.toListOfRedisClientInformation(this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.clientList();
            }
        }, node).getValue());
    }

    @Override
    public void slaveOf(String host, int port) {
        throw new InvalidDataAccessApiUsageException("SlaveOf is not supported in cluster environment. Please use CLUSTER REPLICATE.");
    }

    @Override
    public void slaveOfNoOne() {
        throw new InvalidDataAccessApiUsageException("SlaveOf is not supported in cluster environment. Please use CLUSTER REPLICATE.");
    }

    @Override
    public void scriptFlush() {
        throw new InvalidDataAccessApiUsageException("ScriptFlush is not supported in cluster environment.");
    }

    @Override
    public void scriptKill() {
        throw new InvalidDataAccessApiUsageException("ScriptKill is not supported in cluster environment.");
    }

    @Override
    public String scriptLoad(byte[] script) {
        throw new InvalidDataAccessApiUsageException("ScriptLoad is not supported in cluster environment.");
    }

    @Override
    public List<Boolean> scriptExists(String ... scriptShas) {
        throw new InvalidDataAccessApiUsageException("ScriptExists is not supported in cluster environment.");
    }

    @Override
    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        throw new InvalidDataAccessApiUsageException("Eval is not supported in cluster environment.");
    }

    @Override
    public <T> T evalSha(String scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        throw new InvalidDataAccessApiUsageException("EvalSha is not supported in cluster environment.");
    }

    @Override
    public <T> T evalSha(byte[] scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        throw new InvalidDataAccessApiUsageException("EvalSha is not supported in cluster environment.");
    }

    @Override
    public Long pfAdd(byte[] key, byte[] ... values) {
        try {
            return this.cluster.pfadd(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long pfCount(byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.cluster.pfcount(keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("All keys must map to same slot for pfcount in cluster mode.");
    }

    @Override
    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        byte[][] allKeys = ByteUtils.mergeArrays(destinationKey, sourceKeys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                this.cluster.pfmerge(destinationKey, sourceKeys);
                return;
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("All keys must map to same slot for pfmerge in cluster mode.");
    }

    @Override
    public Boolean exists(byte[] key) {
        try {
            return this.cluster.exists(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void clusterSetSlot(RedisClusterNode node, final int slot, final RedisClusterCommands.AddSlots mode) {
        Assert.notNull((Object)node, (String)"Node must not be null.");
        Assert.notNull((Object)((Object)mode), (String)"AddSlots mode must not be null.");
        RedisClusterNode nodeToUse = this.topologyProvider.getTopology().lookup(node);
        final String nodeId = nodeToUse.getId();
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                switch (mode) {
                    case IMPORTING: {
                        return client.clusterSetSlotImporting(slot, nodeId);
                    }
                    case MIGRATING: {
                        return client.clusterSetSlotMigrating(slot, nodeId);
                    }
                    case STABLE: {
                        return client.clusterSetSlotStable(slot);
                    }
                    case NODE: {
                        return client.clusterSetSlotNode(slot, nodeId);
                    }
                }
                throw new IllegalArgumentException(String.format("Unknown AddSlots mode '%s'.", new Object[]{mode}));
            }
        }, node);
    }

    @Override
    public List<byte[]> clusterGetKeysInSlot(final int slot, final Integer count) {
        RedisClusterNode node = this.clusterGetNodeForSlot(slot);
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<List<byte[]>>(){

            @Override
            public List<byte[]> doInCluster(Jedis client) {
                return JedisConverters.stringListToByteList().convert(client.clusterGetKeysInSlot(slot, count != null ? count : Integer.MAX_VALUE));
            }
        }, node);
        return null;
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, final int ... slots) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.clusterAddSlots(slots);
            }
        }, node);
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)range, (String)"Range must not be null.");
        this.clusterAddSlots(node, range.getSlotsArray());
    }

    @Override
    public Long clusterCountKeysInSlot(final int slot) {
        RedisClusterNode node = this.clusterGetNodeForSlot(slot);
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<Long>(){

            @Override
            public Long doInCluster(Jedis client) {
                return client.clusterCountKeysInSlot(slot);
            }
        }, node).getValue();
    }

    @Override
    public void clusterDeleteSlots(RedisClusterNode node, final int ... slots) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.clusterDelSlots(slots);
            }
        }, node);
    }

    @Override
    public void clusterDeleteSlotsInRange(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)range, (String)"Range must not be null.");
        this.clusterDeleteSlots(node, range.getSlotsArray());
    }

    @Override
    public void clusterForget(final RedisClusterNode node) {
        LinkedHashSet<RedisClusterNode> nodes = new LinkedHashSet<RedisClusterNode>(this.topologyProvider.getTopology().getActiveMasterNodes());
        RedisClusterNode nodeToRemove = this.topologyProvider.getTopology().lookup(node);
        nodes.remove(nodeToRemove);
        this.clusterCommandExecutor.executeCommandAsyncOnNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.clusterForget(node.getId());
            }
        }, nodes);
    }

    @Override
    public void clusterMeet(final RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"Cluster node must not be null for CLUSTER MEET command!");
        Assert.hasText((String)node.getHost(), (String)"Node to meet cluster must have a host!");
        Assert.isTrue((node.getPort() > 0 ? 1 : 0) != 0, (String)"Node to meet cluster must have a port greater 0!");
        this.clusterCommandExecutor.executeCommandOnAllNodes(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.clusterMeet(node.getHost(), node.getPort().intValue());
            }
        });
    }

    @Override
    public void clusterReplicate(RedisClusterNode master, RedisClusterNode slave) {
        final RedisClusterNode masterNode = this.topologyProvider.getTopology().lookup(master);
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.clusterReplicate(masterNode.getId());
            }
        }, slave);
    }

    @Override
    public Integer clusterGetSlotForKey(final byte[] key) {
        return this.clusterCommandExecutor.executeCommandOnArbitraryNode(new JedisClusterCommandCallback<Integer>(){

            @Override
            public Integer doInCluster(Jedis client) {
                return client.clusterKeySlot(JedisConverters.toString(key)).intValue();
            }
        }).getValue();
    }

    @Override
    public RedisClusterNode clusterGetNodeForSlot(int slot) {
        for (RedisClusterNode node : this.topologyProvider.getTopology().getSlotServingNodes(slot)) {
            if (!node.isMaster()) continue;
            return node;
        }
        return null;
    }

    public Set<RedisClusterNode> clusterGetNodes() {
        return this.topologyProvider.getTopology().getNodes();
    }

    public Set<RedisClusterNode> clusterGetSlaves(RedisClusterNode master) {
        Assert.notNull((Object)master, (String)"Master cannot be null!");
        final RedisClusterNode nodeToUse = this.topologyProvider.getTopology().lookup(master);
        return JedisConverters.toSetOfRedisClusterNodes((Collection<String>)this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<List<String>>(){

            @Override
            public List<String> doInCluster(Jedis client) {
                return client.clusterSlaves(nodeToUse.getId());
            }
        }, master).getValue());
    }

    @Override
    public Map<RedisClusterNode, Collection<RedisClusterNode>> clusterGetMasterSlaveMap() {
        List<ClusterCommandExecutor.NodeResult<Collection<RedisClusterNode>>> nodeResults = this.clusterCommandExecutor.executeCommandAsyncOnNodes(new JedisClusterCommandCallback<Collection<RedisClusterNode>>(){

            @Override
            public Set<RedisClusterNode> doInCluster(Jedis client) {
                return JedisConverters.toSetOfRedisClusterNodes(client.clusterSlaves((String)client.eval("return redis.call('cluster', 'myid')", 0, new String[0])));
            }
        }, this.topologyProvider.getTopology().getActiveMasterNodes()).getResults();
        LinkedHashMap<RedisClusterNode, Collection<RedisClusterNode>> result = new LinkedHashMap<RedisClusterNode, Collection<RedisClusterNode>>();
        for (ClusterCommandExecutor.NodeResult<Collection<RedisClusterNode>> nodeResult : nodeResults) {
            result.put(nodeResult.getNode(), nodeResult.getValue());
        }
        return result;
    }

    @Override
    public RedisClusterNode clusterGetNodeForKey(byte[] key) {
        return this.clusterGetNodeForSlot(this.clusterGetSlotForKey(key));
    }

    @Override
    public ClusterInfo clusterGetClusterInfo() {
        return new ClusterInfo(JedisConverters.toProperties(this.clusterCommandExecutor.executeCommandOnArbitraryNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.clusterInfo();
            }
        }).getValue()));
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option) {
        this.migrate(key, target, dbIndex, option, Long.MAX_VALUE);
    }

    @Override
    public void migrate(final byte[] key, final RedisNode target, final int dbIndex, RedisServerCommands.MigrateOption option, long timeout) {
        final int timeoutToUse = timeout <= Integer.MAX_VALUE ? (int)timeout : Integer.MAX_VALUE;
        RedisClusterNode node = this.topologyProvider.getTopology().lookup(target.getHost(), target.getPort());
        this.clusterCommandExecutor.executeCommandOnSingleNode(new JedisClusterCommandCallback<String>(){

            @Override
            public String doInCluster(Jedis client) {
                return client.migrate(JedisConverters.toBytes(target.getHost()), target.getPort().intValue(), key, dbIndex, timeoutToUse);
            }
        }, node);
    }

    protected DataAccessException convertJedisAccessException(Exception ex) {
        DataAccessException translated = EXCEPTION_TRANSLATION.translate(ex);
        return translated != null ? translated : new RedisSystemException(ex.getMessage(), ex);
    }

    @Override
    public void close() throws DataAccessException {
        if (!this.closed && this.disposeClusterCommandExecutorOnClose) {
            try {
                this.clusterCommandExecutor.destroy();
            }
            catch (Exception ex) {
                this.log.warn((Object)"Cannot properly close cluster command executor", (Throwable)ex);
            }
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public JedisCluster getNativeConnection() {
        return this.cluster;
    }

    @Override
    public boolean isQueueing() {
        return false;
    }

    @Override
    public boolean isPipelined() {
        return false;
    }

    @Override
    public void openPipeline() {
        throw new UnsupportedOperationException("Pipeline is currently not supported for JedisClusterConnection.");
    }

    @Override
    public List<Object> closePipeline() throws RedisPipelineException {
        throw new UnsupportedOperationException("Pipeline is currently not supported for JedisClusterConnection.");
    }

    @Override
    public RedisSentinelConnection getSentinelConnection() {
        throw new UnsupportedOperationException("Sentinel is currently not supported for JedisClusterConnection.");
    }

    static class JedisClusterTopologyProvider
    implements ClusterTopologyProvider {
        private final Object lock = new Object();
        private final JedisCluster cluster;
        private long time = 0L;
        private ClusterTopology cached;

        public JedisClusterTopologyProvider(JedisCluster cluster) {
            this.cluster = cluster;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterTopology getTopology() {
            if (this.cached != null && this.time + 100L > System.currentTimeMillis()) {
                return this.cached;
            }
            LinkedHashMap errors = new LinkedHashMap();
            for (Map.Entry entry : this.cluster.getClusterNodes().entrySet()) {
                Jedis jedis = null;
                try {
                    jedis = ((JedisPool)entry.getValue()).getResource();
                    this.time = System.currentTimeMillis();
                    Set<RedisClusterNode> nodes = Converters.toSetOfRedisClusterNodes(jedis.clusterNodes());
                    Object object = this.lock;
                    synchronized (object) {
                        this.cached = new ClusterTopology(nodes);
                    }
                    object = this.cached;
                    return object;
                }
                catch (Exception ex) {
                    errors.put(entry.getKey(), ex);
                }
                finally {
                    if (jedis == null) continue;
                    jedis.close();
                }
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : errors.entrySet()) {
                sb.append(String.format("\r\n\t- %s failed: %s", entry.getKey(), ((Exception)entry.getValue()).getMessage()));
            }
            throw new ClusterStateFailureException("Could not retrieve cluster information. CLUSTER NODES returned with error." + sb.toString());
        }
    }

    static class JedisClusterNodeResourceProvider
    implements ClusterNodeResourceProvider {
        private final JedisCluster cluster;
        private final ClusterTopologyProvider topologyProvider;
        private final JedisClusterConnectionHandler connectionHandler;

        JedisClusterNodeResourceProvider(JedisCluster cluster, ClusterTopologyProvider topologyProvider) {
            DirectFieldAccessFallbackBeanWrapper accessor;
            this.cluster = cluster;
            this.topologyProvider = topologyProvider;
            this.connectionHandler = cluster != null ? ((accessor = new DirectFieldAccessFallbackBeanWrapper((Object)cluster)).isReadableProperty("connectionHandler") ? (JedisClusterConnectionHandler)accessor.getPropertyValue("connectionHandler") : null) : null;
        }

        public Jedis getResourceForSpecificNode(RedisClusterNode node) {
            Assert.notNull((Object)node, (String)"Cannot get Pool for 'null' node!");
            JedisPool pool = this.getResourcePoolForSpecificNode(node);
            if (pool != null) {
                return pool.getResource();
            }
            Jedis connection = this.getConnectionForSpecificNode(node);
            if (connection != null) {
                return connection;
            }
            throw new IllegalStateException(String.format("Node %s is unknown to cluster", node));
        }

        private JedisPool getResourcePoolForSpecificNode(RedisClusterNode node) {
            Map clusterNodes = this.cluster.getClusterNodes();
            if (clusterNodes.containsKey(node.asString())) {
                return (JedisPool)clusterNodes.get(node.asString());
            }
            return null;
        }

        private Jedis getConnectionForSpecificNode(RedisClusterNode node) {
            RedisClusterNode member = this.topologyProvider.getTopology().lookup(node);
            if (member != null && this.connectionHandler != null) {
                return this.connectionHandler.getConnectionFromNode(new HostAndPort(member.getHost(), member.getPort().intValue()));
            }
            return null;
        }

        @Override
        public void returnResourceForSpecificNode(RedisClusterNode node, Object client) {
            ((Jedis)client).close();
        }
    }

    protected static interface JedisMultiKeyClusterCommandCallback<T>
    extends ClusterCommandExecutor.MultiKeyClusterCommandCallback<Jedis, T> {
    }

    protected static interface JedisClusterCommandCallback<T>
    extends ClusterCommandExecutor.ClusterCommandCallback<Jedis, T> {
    }
}

