/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import org.springframework.mock.web.portlet.MockPortletRequest;

public class MockClientDataRequest
extends MockPortletRequest
implements ClientDataRequest {
    private String characterEncoding;
    private byte[] content;
    private String contentType;
    private String method;

    public MockClientDataRequest() {
    }

    public MockClientDataRequest(PortletContext portletContext) {
        super(portletContext);
    }

    public MockClientDataRequest(PortalContext portalContext, PortletContext portletContext) {
        super(portalContext, portletContext);
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public InputStream getPortletInputStream() throws IOException {
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        return null;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this.content != null) {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(this.content);
            InputStreamReader sourceReader = this.characterEncoding != null ? new InputStreamReader((InputStream)sourceStream, this.characterEncoding) : new InputStreamReader(sourceStream);
            return new BufferedReader(sourceReader);
        }
        return null;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getContentLength() {
        return this.content != null ? this.content.length : -1;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }
}

