/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.ClassUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;

public class RequestPartServletServerHttpRequest
extends ServletServerHttpRequest {
    private final MultipartHttpServletRequest multipartRequest;
    private final String partName;
    private final HttpHeaders headers;

    public RequestPartServletServerHttpRequest(HttpServletRequest request, String partName) throws MissingServletRequestPartException {
        super(request);
        this.multipartRequest = RequestPartServletServerHttpRequest.asMultipartRequest(request);
        this.partName = partName;
        this.headers = this.multipartRequest.getMultipartHeaders(this.partName);
        if (this.headers == null) {
            if (request instanceof MultipartHttpServletRequest) {
                throw new MissingServletRequestPartException(partName);
            }
            throw new IllegalArgumentException("Failed to obtain request part: " + partName + ". " + "The part is missing or multipart processing is not configured. " + "Check for a MultipartResolver bean or if Servlet 3.0 multipart processing is enabled.");
        }
    }

    private static MultipartHttpServletRequest asMultipartRequest(HttpServletRequest request) {
        MultipartHttpServletRequest unwrapped = WebUtils.getNativeRequest((ServletRequest)request, MultipartHttpServletRequest.class);
        if (unwrapped != null) {
            return unwrapped;
        }
        if (ClassUtils.hasMethod(HttpServletRequest.class, (String)"getParts", (Class[])new Class[0])) {
            return new StandardMultipartHttpServletRequest(request);
        }
        throw new IllegalArgumentException("Expected MultipartHttpServletRequest: is a MultipartResolver configured?");
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public InputStream getBody() throws IOException {
        if (this.multipartRequest instanceof StandardMultipartHttpServletRequest) {
            try {
                return this.multipartRequest.getPart(this.partName).getInputStream();
            }
            catch (Exception ex) {
                throw new MultipartException("Could not parse multipart servlet request", ex);
            }
        }
        MultipartFile file = this.multipartRequest.getFile(this.partName);
        if (file != null) {
            return file.getInputStream();
        }
        String paramValue = this.multipartRequest.getParameter(this.partName);
        return new ByteArrayInputStream(paramValue.getBytes(this.determineEncoding()));
    }

    private String determineEncoding() {
        Charset charset;
        MediaType contentType = this.getHeaders().getContentType();
        if (contentType != null && (charset = contentType.getCharSet()) != null) {
            return charset.name();
        }
        String encoding = this.multipartRequest.getCharacterEncoding();
        return encoding != null ? encoding : "UTF-8";
    }
}

