/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.sftp;

import com.sshtools.daemon.platform.InvalidHandleException;
import com.sshtools.daemon.platform.NativeFileSystemProvider;
import com.sshtools.daemon.platform.PermissionDeniedException;
import com.sshtools.daemon.platform.UnsupportedFileOperationException;
import com.sshtools.daemon.session.SessionChannelServer;
import com.sshtools.daemon.subsystem.SubsystemServer;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SshFxpAttrs;
import com.sshtools.j2ssh.sftp.SshFxpClose;
import com.sshtools.j2ssh.sftp.SshFxpData;
import com.sshtools.j2ssh.sftp.SshFxpFSetStat;
import com.sshtools.j2ssh.sftp.SshFxpFStat;
import com.sshtools.j2ssh.sftp.SshFxpHandle;
import com.sshtools.j2ssh.sftp.SshFxpInit;
import com.sshtools.j2ssh.sftp.SshFxpLStat;
import com.sshtools.j2ssh.sftp.SshFxpMkdir;
import com.sshtools.j2ssh.sftp.SshFxpName;
import com.sshtools.j2ssh.sftp.SshFxpOpen;
import com.sshtools.j2ssh.sftp.SshFxpOpenDir;
import com.sshtools.j2ssh.sftp.SshFxpRead;
import com.sshtools.j2ssh.sftp.SshFxpReadDir;
import com.sshtools.j2ssh.sftp.SshFxpReadlink;
import com.sshtools.j2ssh.sftp.SshFxpRealPath;
import com.sshtools.j2ssh.sftp.SshFxpRemove;
import com.sshtools.j2ssh.sftp.SshFxpRename;
import com.sshtools.j2ssh.sftp.SshFxpRmdir;
import com.sshtools.j2ssh.sftp.SshFxpSetStat;
import com.sshtools.j2ssh.sftp.SshFxpStat;
import com.sshtools.j2ssh.sftp.SshFxpStatus;
import com.sshtools.j2ssh.sftp.SshFxpSymlink;
import com.sshtools.j2ssh.sftp.SshFxpVersion;
import com.sshtools.j2ssh.sftp.SshFxpWrite;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SftpSubsystemServer
extends SubsystemServer {
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    private static Log log = LogFactory.getLog((Class)SftpSubsystemServer.class);
    private NativeFileSystemProvider nfs;

    public SftpSubsystemServer() {
        this.registerMessage(1, SshFxpInit.class);
        this.registerMessage(14, SshFxpMkdir.class);
        this.registerMessage(16, SshFxpRealPath.class);
        this.registerMessage(11, SshFxpOpenDir.class);
        this.registerMessage(3, SshFxpOpen.class);
        this.registerMessage(5, SshFxpRead.class);
        this.registerMessage(6, SshFxpWrite.class);
        this.registerMessage(12, SshFxpReadDir.class);
        this.registerMessage(4, SshFxpClose.class);
        this.registerMessage(7, SshFxpLStat.class);
        this.registerMessage(17, SshFxpStat.class);
        this.registerMessage(13, SshFxpRemove.class);
        this.registerMessage(18, SshFxpRename.class);
        this.registerMessage(15, SshFxpRmdir.class);
        this.registerMessage(9, SshFxpSetStat.class);
        this.registerMessage(8, SshFxpFStat.class);
        this.registerMessage(10, SshFxpFSetStat.class);
        this.registerMessage(19, SshFxpReadlink.class);
        this.registerMessage(20, SshFxpSymlink.class);
    }

    public void setSession(SessionChannelServer sessionChannelServer) {
        sessionChannelServer.addEventListener(new ChannelEventListener(){

            public void onChannelOpen(Channel channel) {
            }

            public void onChannelEOF(Channel channel) {
                try {
                    SftpSubsystemServer.this.session.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void onChannelClose(Channel channel) {
            }

            public void onDataReceived(Channel channel, byte[] byArray) {
            }

            public void onDataSent(Channel channel, byte[] byArray) {
            }
        });
        super.setSession(sessionChannelServer);
    }

    protected void onMessageReceived(SubsystemMessage subsystemMessage) {
        switch (subsystemMessage.getMessageType()) {
            case 1: {
                this.onInitialize((SshFxpInit)subsystemMessage);
                break;
            }
            case 14: {
                this.onMakeDirectory((SshFxpMkdir)subsystemMessage);
                break;
            }
            case 16: {
                this.onRealPath((SshFxpRealPath)subsystemMessage);
                break;
            }
            case 11: {
                this.onOpenDirectory((SshFxpOpenDir)subsystemMessage);
                break;
            }
            case 3: {
                this.onOpenFile((SshFxpOpen)subsystemMessage);
                break;
            }
            case 5: {
                this.onReadFile((SshFxpRead)subsystemMessage);
                break;
            }
            case 6: {
                this.onWriteFile((SshFxpWrite)subsystemMessage);
                break;
            }
            case 12: {
                this.onReadDirectory((SshFxpReadDir)subsystemMessage);
                break;
            }
            case 7: {
                this.onLStat((SshFxpLStat)subsystemMessage);
                break;
            }
            case 17: {
                this.onStat((SshFxpStat)subsystemMessage);
                break;
            }
            case 8: {
                this.onFStat((SshFxpFStat)subsystemMessage);
                break;
            }
            case 4: {
                this.onCloseFile((SshFxpClose)subsystemMessage);
                break;
            }
            case 13: {
                this.onRemoveFile((SshFxpRemove)subsystemMessage);
                break;
            }
            case 18: {
                this.onRenameFile((SshFxpRename)subsystemMessage);
                break;
            }
            case 15: {
                this.onRemoveDirectory((SshFxpRmdir)subsystemMessage);
                break;
            }
            case 9: {
                this.onSetAttributes((SshFxpSetStat)subsystemMessage);
                break;
            }
            case 10: {
                this.onSetAttributes((SshFxpFSetStat)subsystemMessage);
                break;
            }
            case 19: {
                this.onReadlink((SshFxpReadlink)subsystemMessage);
                break;
            }
            case 20: {
                this.onSymlink((SshFxpSymlink)subsystemMessage);
                break;
            }
        }
    }

    private void onSetAttributes(SshFxpSetStat sshFxpSetStat) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.setFileAttributes(this.checkDefaultPath(sshFxpSetStat.getPath()), sshFxpSetStat.getAttributes());
            sshFxpStatus = new SshFxpStatus(sshFxpSetStat.getId(), new UnsignedInteger32(0L), "The attributes were set", "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSetStat.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSetStat.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSetStat.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private void onSetAttributes(SshFxpFSetStat sshFxpFSetStat) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.setFileAttributes(sshFxpFSetStat.getHandle(), sshFxpFSetStat.getAttributes());
            sshFxpStatus = new SshFxpStatus(sshFxpFSetStat.getId(), new UnsignedInteger32(0L), "The attributes were set", "");
        }
        catch (InvalidHandleException invalidHandleException) {
            sshFxpStatus = new SshFxpStatus(sshFxpFSetStat.getId(), new UnsignedInteger32(4L), invalidHandleException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpFSetStat.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpFSetStat.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private void onReadlink(SshFxpReadlink sshFxpReadlink) {
        SshFxpStatus sshFxpStatus;
        try {
            sshFxpStatus = new SshFxpName(sshFxpReadlink.getId(), new SftpFile[]{this.nfs.readSymbolicLink(this.checkDefaultPath(sshFxpReadlink.getPath()))});
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpReadlink.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpReadlink.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        catch (UnsupportedFileOperationException unsupportedFileOperationException) {
            sshFxpStatus = new SshFxpStatus(sshFxpReadlink.getId(), new UnsignedInteger32(8L), unsupportedFileOperationException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpReadlink.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private void onSymlink(SshFxpSymlink sshFxpSymlink) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.createSymbolicLink(this.checkDefaultPath(sshFxpSymlink.getLinkPath()), this.checkDefaultPath(sshFxpSymlink.getTargetPath()));
            sshFxpStatus = new SshFxpStatus(sshFxpSymlink.getId(), new UnsignedInteger32(0L), "The symbolic link was created", "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSymlink.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSymlink.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSymlink.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        catch (UnsupportedFileOperationException unsupportedFileOperationException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSymlink.getId(), new UnsignedInteger32(8L), unsupportedFileOperationException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private void onRemoveDirectory(SshFxpRmdir sshFxpRmdir) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.removeDirectory(this.checkDefaultPath(sshFxpRmdir.getPath()));
            sshFxpStatus = new SshFxpStatus(sshFxpRmdir.getId(), new UnsignedInteger32(0L), "The directory was removed", "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRmdir.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRmdir.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRmdir.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private void onRenameFile(SshFxpRename sshFxpRename) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.renameFile(this.checkDefaultPath(sshFxpRename.getOldPath()), this.checkDefaultPath(sshFxpRename.getNewPath()));
            sshFxpStatus = new SshFxpStatus(sshFxpRename.getId(), new UnsignedInteger32(0L), "The file was removed", "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRename.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRename.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRename.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private void onRemoveFile(SshFxpRemove sshFxpRemove) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.removeFile(this.checkDefaultPath(sshFxpRemove.getFilename()));
            sshFxpStatus = new SshFxpStatus(sshFxpRemove.getId(), new UnsignedInteger32(0L), "The file was removed", "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRemove.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRemove.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRemove.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private void onOpenFile(SshFxpOpen sshFxpOpen) {
        SshFxpStatus sshFxpStatus;
        try {
            sshFxpStatus = new SshFxpHandle(sshFxpOpen.getId(), this.nfs.openFile(this.checkDefaultPath(sshFxpOpen.getFilename()), sshFxpOpen.getPflags(), sshFxpOpen.getAttributes()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpOpen.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpOpen.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpOpen.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private void onReadFile(SshFxpRead sshFxpRead) {
        SshFxpData sshFxpData;
        try {
            sshFxpData = new SshFxpData(sshFxpRead.getId(), this.nfs.readFile(sshFxpRead.getHandle(), sshFxpRead.getOffset(), sshFxpRead.getLength()));
        }
        catch (EOFException eOFException) {
            sshFxpData = new SshFxpStatus(sshFxpRead.getId(), new UnsignedInteger32(1L), eOFException.getMessage(), "");
        }
        catch (InvalidHandleException invalidHandleException) {
            sshFxpData = new SshFxpStatus(sshFxpRead.getId(), new UnsignedInteger32(4L), invalidHandleException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpData = new SshFxpStatus(sshFxpRead.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpData);
    }

    private void onWriteFile(SshFxpWrite sshFxpWrite) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.writeFile(sshFxpWrite.getHandle(), sshFxpWrite.getOffset(), sshFxpWrite.getData(), 0, sshFxpWrite.getData().length);
            sshFxpStatus = new SshFxpStatus(sshFxpWrite.getId(), new UnsignedInteger32(0L), "The write completed successfully", "");
        }
        catch (InvalidHandleException invalidHandleException) {
            sshFxpStatus = new SshFxpStatus(sshFxpWrite.getId(), new UnsignedInteger32(4L), invalidHandleException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpWrite.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private void onCloseFile(SshFxpClose sshFxpClose) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.closeFile(sshFxpClose.getHandle());
            sshFxpStatus = new SshFxpStatus(sshFxpClose.getId(), new UnsignedInteger32(0L), "The operation completed", "");
        }
        catch (InvalidHandleException invalidHandleException) {
            sshFxpStatus = new SshFxpStatus(sshFxpClose.getId(), new UnsignedInteger32(4L), invalidHandleException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpClose.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private void onFStat(SshFxpFStat sshFxpFStat) {
        SshFxpAttrs sshFxpAttrs;
        try {
            sshFxpAttrs = new SshFxpAttrs(sshFxpFStat.getId(), this.nfs.getFileAttributes(sshFxpFStat.getHandle()));
        }
        catch (InvalidHandleException invalidHandleException) {
            sshFxpAttrs = new SshFxpStatus(sshFxpFStat.getId(), new UnsignedInteger32(4L), invalidHandleException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpAttrs = new SshFxpStatus(sshFxpFStat.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpAttrs);
    }

    private void onStat(SshFxpStat sshFxpStat) {
        SshFxpStatus sshFxpStatus;
        try {
            String string = this.checkDefaultPath(sshFxpStat.getPath());
            if (this.nfs.fileExists(string)) {
                SftpFile[] sftpFileArray = new SftpFile[1];
                sshFxpStatus = new SshFxpAttrs(sshFxpStat.getId(), this.nfs.getFileAttributes(sshFxpStat.getPath()));
            } else {
                sshFxpStatus = new SshFxpStatus(sshFxpStat.getId(), new UnsignedInteger32(2L), string + " is not a valid file path", "");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpStat.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpStat.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private void onLStat(SshFxpLStat sshFxpLStat) {
        SshFxpStatus sshFxpStatus;
        try {
            String string = this.checkDefaultPath(sshFxpLStat.getPath());
            if (this.nfs.fileExists(string)) {
                SftpFile[] sftpFileArray = new SftpFile[1];
                sshFxpStatus = new SshFxpAttrs(sshFxpLStat.getId(), this.nfs.getFileAttributes(this.nfs.getCanonicalPath(sshFxpLStat.getPath())));
            } else {
                sshFxpStatus = new SshFxpStatus(sshFxpLStat.getId(), new UnsignedInteger32(2L), string + " is not a valid file path", "");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpLStat.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpLStat.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private void onReadDirectory(SshFxpReadDir sshFxpReadDir) {
        SshFxpName sshFxpName;
        try {
            SftpFile[] sftpFileArray = this.nfs.readDirectory(sshFxpReadDir.getHandle());
            sshFxpName = new SshFxpName(sshFxpReadDir.getId(), sftpFileArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpName = new SshFxpStatus(sshFxpReadDir.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (InvalidHandleException invalidHandleException) {
            sshFxpName = new SshFxpStatus(sshFxpReadDir.getId(), new UnsignedInteger32(4L), invalidHandleException.getMessage(), "");
        }
        catch (EOFException eOFException) {
            sshFxpName = new SshFxpStatus(sshFxpReadDir.getId(), new UnsignedInteger32(1L), eOFException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpName = new SshFxpStatus(sshFxpReadDir.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpName);
    }

    private void onOpenDirectory(SshFxpOpenDir sshFxpOpenDir) {
        SshFxpHandle sshFxpHandle;
        try {
            String string = this.checkDefaultPath(sshFxpOpenDir.getPath());
            sshFxpHandle = new SshFxpHandle(sshFxpOpenDir.getId(), this.nfs.openDirectory(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpHandle = new SshFxpStatus(sshFxpOpenDir.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpHandle = new SshFxpStatus(sshFxpOpenDir.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpHandle = new SshFxpStatus(sshFxpOpenDir.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpHandle);
    }

    private void onRealPath(SshFxpRealPath sshFxpRealPath) {
        SshFxpStatus sshFxpStatus;
        try {
            String string = this.nfs.getRealPath(this.checkDefaultPath(sshFxpRealPath.getPath()));
            if (string != null) {
                SftpFile[] sftpFileArray = new SftpFile[]{new SftpFile(string)};
                sshFxpStatus = new SshFxpName(sshFxpRealPath.getId(), sftpFileArray);
            } else {
                sshFxpStatus = new SshFxpStatus(sshFxpRealPath.getId(), new UnsignedInteger32(4L), sshFxpRealPath.getPath() + " could not be translated into a system dependent path", "");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRealPath.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRealPath.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private void onMakeDirectory(SshFxpMkdir sshFxpMkdir) {
        SshFxpStatus sshFxpStatus;
        try {
            String string = this.checkDefaultPath(sshFxpMkdir.getPath());
            sshFxpStatus = this.nfs.makeDirectory(string) ? new SshFxpStatus(sshFxpMkdir.getId(), new UnsignedInteger32(0L), "The operation completed sucessfully", "") : new SshFxpStatus(sshFxpMkdir.getId(), new UnsignedInteger32(4L), "The operation failed", "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpMkdir.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpMkdir.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpMkdir.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage((SubsystemMessage)sshFxpStatus);
    }

    private String checkDefaultPath(String string) throws IOException {
        if (string.equals("")) {
            return this.nfs.getDefaultPath(SshThread.getCurrentThreadUser());
        }
        return string;
    }

    private void onInitialize(SshFxpInit sshFxpInit) {
        this.nfs = NativeFileSystemProvider.getInstance();
        if (sshFxpInit.getVersion().intValue() == 3) {
            SshFxpVersion sshFxpVersion = new SshFxpVersion(new UnsignedInteger32(3L), null);
            this.sendMessage((SubsystemMessage)sshFxpVersion);
        }
    }
}

