/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.transport;

import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.AlgorithmInitializationException;
import com.sshtools.j2ssh.transport.AlgorithmNotAgreedException;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.MessageAlreadyRegisteredException;
import com.sshtools.j2ssh.transport.Service;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.SshMsgKexInit;
import com.sshtools.j2ssh.transport.SshMsgServiceRequest;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.j2ssh.transport.TransportProtocolCommon;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmac;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.kex.KeyExchangeException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportProtocolServer
extends TransportProtocolCommon {
    private static Log log = LogFactory.getLog((Class)TransportProtocolServer.class);
    private Map acceptServices = new HashMap();
    private ServerConfiguration config = (ServerConfiguration)ConfigurationLoader.getConfiguration((Class)ServerConfiguration.class);
    private boolean refuse = false;

    public TransportProtocolServer() throws IOException {
    }

    public TransportProtocolServer(boolean bl) throws IOException {
        this();
        this.refuse = bl;
    }

    protected void onDisconnect() {
        this.acceptServices.clear();
    }

    public void acceptService(Service service) throws IOException {
        this.acceptServices.put(service.getServiceName(), service);
    }

    public void refuseConnection() throws IOException {
        log.info((Object)"Refusing connection");
        this.sendDisconnect(12, "Too many connections");
    }

    public void registerTransportMessages() throws MessageAlreadyRegisteredException {
        this.messageStore.registerMessage(5, SshMsgServiceRequest.class);
    }

    protected void startBinaryPacketProtocol() throws IOException {
        if (this.refuse) {
            this.sendKeyExchangeInit();
            this.refuseConnection();
        } else {
            super.startBinaryPacketProtocol();
        }
    }

    protected String getDecryptionAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSEncryption(), this.serverKexInit.getSupportedCSEncryption());
    }

    protected String getEncryptionAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCEncryption(), this.serverKexInit.getSupportedSCEncryption());
    }

    protected String getInputStreamCompAlgortihm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSComp(), this.serverKexInit.getSupportedCSComp());
    }

    protected String getInputStreamMacAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSMac(), this.serverKexInit.getSupportedCSMac());
    }

    protected void setLocalIdent() {
        this.serverIdent = "SSH-2.0-" + SOFTWARE_VERSION_COMMENTS + " [SERVER]";
    }

    public String getLocalId() {
        return this.serverIdent;
    }

    protected void setLocalKexInit(SshMsgKexInit sshMsgKexInit) {
        log.debug((Object)sshMsgKexInit.toString());
        this.serverKexInit = sshMsgKexInit;
    }

    protected SshMsgKexInit getLocalKexInit() {
        return this.serverKexInit;
    }

    protected String getOutputStreamCompAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCComp(), this.serverKexInit.getSupportedSCComp());
    }

    protected String getOutputStreamMacAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCMac(), this.serverKexInit.getSupportedSCMac());
    }

    protected void setRemoteIdent(String string) {
        this.clientIdent = string;
    }

    public String getRemoteId() {
        return this.clientIdent;
    }

    protected void setRemoteKexInit(SshMsgKexInit sshMsgKexInit) {
        log.debug((Object)sshMsgKexInit.toString());
        this.clientKexInit = sshMsgKexInit;
    }

    protected SshMsgKexInit getRemoteKexInit() {
        return this.clientKexInit;
    }

    protected SshMsgKexInit createLocalKexInit() throws IOException {
        ArrayList arrayList;
        SshMsgKexInit sshMsgKexInit = new SshMsgKexInit(this.properties);
        Map map = this.config.getServerHostKeys();
        if (map.size() > 0) {
            Iterator iterator = map.entrySet().iterator();
            arrayList = new ArrayList();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (SshKeyPairFactory.supportsKey((String)entry.getKey().toString())) {
                    arrayList.add(entry.getKey());
                    continue;
                }
                log.warn((Object)("Server host key algorithm '" + entry.getKey().toString() + "' not supported"));
            }
            if (arrayList.size() <= 0) {
                throw new TransportProtocolException("No server host keys available");
            }
        } else {
            throw new TransportProtocolException("There are no server host keys available");
        }
        sshMsgKexInit.setSupportedPK(arrayList);
        return sshMsgKexInit;
    }

    protected void onStartTransportProtocol() throws IOException {
    }

    protected void performKeyExchange(SshKeyExchange sshKeyExchange) throws IOException {
        String string = this.determineAlgorithm(this.clientKexInit.getSupportedPublicKeys(), this.serverKexInit.getSupportedPublicKeys());
        Map map = this.config.getServerHostKeys();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getKey().equals(string)) continue;
            SshPrivateKey sshPrivateKey = (SshPrivateKey)entry.getValue();
            sshKeyExchange.performServerExchange(this.clientIdent, this.serverIdent, this.clientKexInit.toByteArray(), this.serverKexInit.toByteArray(), sshPrivateKey);
            return;
        }
        throw new KeyExchangeException("No host key available for the determined public key algorithm");
    }

    protected void onMessageReceived(SshMessage sshMessage) throws IOException {
        switch (sshMessage.getMessageId()) {
            case 5: {
                this.onMsgServiceRequest((SshMsgServiceRequest)sshMessage);
            }
        }
    }

    protected void setupNewKeys(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) throws AlgorithmNotAgreedException, AlgorithmOperationException, AlgorithmNotSupportedException, AlgorithmInitializationException {
        SshCipher sshCipher = SshCipherFactory.newInstance((String)this.getEncryptionAlgorithm());
        sshCipher.init(0, byArray4, byArray3);
        this.algorithmsOut.setCipher(sshCipher);
        sshCipher = SshCipherFactory.newInstance((String)this.getDecryptionAlgorithm());
        sshCipher.init(1, byArray2, byArray);
        this.algorithmsIn.setCipher(sshCipher);
        SshHmac sshHmac = SshHmacFactory.newInstance((String)this.getOutputStreamMacAlgorithm());
        sshHmac.init(byArray6);
        this.algorithmsOut.setHmac(sshHmac);
        sshHmac = SshHmacFactory.newInstance((String)this.getInputStreamMacAlgorithm());
        sshHmac.init(byArray5);
        this.algorithmsIn.setHmac(sshHmac);
    }

    private void onMsgServiceRequest(SshMsgServiceRequest sshMsgServiceRequest) throws IOException {
        if (this.acceptServices.containsKey(sshMsgServiceRequest.getServiceName())) {
            Service service = (Service)this.acceptServices.get(sshMsgServiceRequest.getServiceName());
            service.init(2, (TransportProtocol)this);
            service.start();
        } else {
            this.sendDisconnect(7, sshMsgServiceRequest.getServiceName() + " is not available");
        }
    }
}

