/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.Constant;
import java.util.HashMap;
import java.util.Map;

public class AttrName {
    private static String VERSION = "$Id: AttrName.java,v 1.11 2005/09/30 18:34:08 solomon Exp $";
    private final String raw;
    private final String canon;
    private String pname;
    static final AttrName PARENT = new AttrName("parent");
    private static Map instanceMap = new HashMap();

    private AttrName(String v) {
        this.raw = v.intern();
        this.canon = v.toLowerCase().intern();
    }

    public String toString() {
        if (this.pname == null) {
            this.pname = this == PARENT ? "parent" : (this.raw.matches("\\A[A-Za-z_]\\w*\\z") && !this.raw.equalsIgnoreCase("error") && !this.raw.equalsIgnoreCase("false") && !this.raw.equalsIgnoreCase("is") && !this.raw.equalsIgnoreCase("isnt") && !this.raw.equalsIgnoreCase("parent") && !this.raw.equalsIgnoreCase("true") && !this.raw.equalsIgnoreCase("undefined") ? this.raw : Constant.escapeString(new StringBuffer(), this.raw, '\'').toString());
        }
        return this.pname;
    }

    public boolean needsQuoting() {
        if (this == PARENT) {
            return false;
        }
        if (this.pname == null) {
            this.toString();
        }
        return this.pname != this.raw;
    }

    public String rawString() {
        return this.raw;
    }

    public boolean equals(Object o) {
        return this == PARENT ? o == PARENT : this.canon == ((AttrName)o).canon;
    }

    public int hashCode() {
        return System.identityHashCode(this.canon);
    }

    public static AttrName fromText(String v) {
        if (v == null || v.length() == 0) {
            return null;
        }
        if (v.charAt(0) == '\'') {
            int end = v.length() - 1;
            if (v.charAt(end) != '\'') {
                return null;
            }
            char[] tmp = new char[end - 1];
            v.getChars(1, end, tmp, 0);
            v = Constant.unquoteString(tmp, 0, end - 1);
        } else if (!v.matches("\\A[A-Za-z_]\\w*\\z")) {
            return null;
        }
        return AttrName.fromString(v, false);
    }

    public static AttrName fromString(String v) {
        return AttrName.fromString(v, true);
    }

    private static AttrName fromString(String v, boolean parentIsSpecial) {
        if (v == null) {
            return null;
        }
        if (parentIsSpecial && v.equalsIgnoreCase("parent")) {
            return PARENT;
        }
        AttrName result = (AttrName)instanceMap.get(v);
        if (result == null) {
            result = new AttrName(v);
            instanceMap.put(v, result);
        }
        return result;
    }
}

