/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.Constant;
import condor.classad.Env;
import condor.classad.Expr;
import condor.classad.ListExpr;
import condor.classad.Op;
import condor.classad.RecordExpr;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class Builtin {
    private static String VERSION = "$Id: Builtin.java,v 1.17 2007/12/10 12:07:56 solomon Exp $";
    private static Random rand = new Random();

    private Builtin() {
        throw new RuntimeException();
    }

    public static Expr isUndefined(Env env, Expr expr) {
        if (!expr.isConstant()) {
            expr = expr.eval(env);
        }
        return Constant.bool(expr.type == 0);
    }

    public static Expr isError(Env env, Expr expr) {
        if (!expr.isConstant()) {
            expr = expr.eval(env);
        }
        return Constant.bool(expr.type == 1);
    }

    public static Expr isString(Env env, Expr expr) {
        if (!expr.isConstant()) {
            expr = expr.eval(env);
        }
        return Constant.bool(expr.type == 5);
    }

    public static Expr isInteger(Env env, Expr expr) {
        if (!expr.isConstant()) {
            expr = expr.eval(env);
        }
        return Constant.bool(expr.type == 3);
    }

    public static Expr isReal(Env env, Expr expr) {
        if (!expr.isConstant()) {
            expr = expr.eval(env);
        }
        return Constant.bool(expr.type == 4);
    }

    public static Expr isList(Env env, Expr expr) {
        if (!expr.isConstant()) {
            expr = expr.eval(env);
        }
        return Constant.bool(expr.type == -2);
    }

    public static Expr isClassad(Env env, Expr expr) {
        if (!expr.isConstant()) {
            expr = expr.eval(env);
        }
        return Constant.bool(expr.type == -1);
    }

    public static Expr isBoolean(Env env, Expr expr) {
        if (!expr.isConstant()) {
            expr = expr.eval(env);
        }
        return Constant.bool(expr.type == 2);
    }

    public static Expr isAbstime(Env env, Expr expr) {
        if (!expr.isConstant()) {
            expr = expr.eval(env);
        }
        return Constant.bool(expr.type == 6);
    }

    public static Expr isReltime(Env env, Expr expr) {
        if (!expr.isConstant()) {
            expr = expr.eval(env);
        }
        return Constant.bool(expr.type == 7);
    }

    public static Expr Int(Expr arg) {
        switch (arg.type) {
            case 3: {
                return arg;
            }
            case 4: {
                return Constant.getInstance((int)arg.realValue());
            }
            case 2: {
                return Constant.getInstance(arg.isTrue() ? 1 : 0);
            }
            case 6: 
            case 7: {
                long ms = ((Constant)arg).milliseconds();
                int secs = (int)(ms / 1000L);
                return Constant.getInstance(secs);
            }
            case 5: {
                String s = arg.stringValue();
                try {
                    return Constant.getInstance((int)Constant.stringToDouble(s));
                }
                catch (NumberFormatException e) {
                    return Constant.error("ill-formed integer " + s);
                }
            }
        }
        return Constant.error("int(" + arg.typeName() + " " + arg.type + ")");
    }

    public static Expr real(Expr arg) {
        if (arg.type == 4) {
            return arg;
        }
        try {
            return Constant.getInstance(Builtin.toReal(arg));
        }
        catch (NumberFormatException e) {
            return Constant.error("ill-formed real " + arg.stringValue());
        }
        catch (ClassCastException e) {
            return Constant.error("real(" + arg.typeName() + ")");
        }
    }

    public static Expr string(Expr s) {
        return s.type == 5 ? s : Constant.getInstance(Builtin.getString(s));
    }

    public static Expr floor(Expr arg) {
        if (arg.type == 3) {
            return arg;
        }
        try {
            return Constant.getInstance((int)Math.floor(Builtin.toReal(arg)));
        }
        catch (NumberFormatException e) {
            return Constant.error("floor(invalid number " + arg + ")");
        }
        catch (ClassCastException e) {
            return Constant.error("floor(" + arg.typeName() + ")");
        }
    }

    public static Expr ceiling(Expr arg) {
        if (arg.type == 3) {
            return arg;
        }
        try {
            return Constant.getInstance((int)Math.ceil(Builtin.toReal(arg)));
        }
        catch (NumberFormatException e) {
            return Constant.error("ceiling(invalid number " + arg + ")");
        }
        catch (ClassCastException e) {
            return Constant.error("ceiling(" + arg.typeName() + ")");
        }
    }

    public static Expr round(Expr arg) {
        if (arg.type == 3) {
            return arg;
        }
        try {
            return Constant.getInstance((int)Math.round(Builtin.toReal(arg)));
        }
        catch (NumberFormatException e) {
            return Constant.error("round(invalid number " + arg + ")");
        }
        catch (ClassCastException e) {
            return Constant.error("round(" + arg.typeName() + ")");
        }
    }

    public static Expr random(Expr[] args) {
        if (args.length == 0) {
            return Constant.getInstance(rand.nextDouble());
        }
        if (args.length != 1) {
            return Constant.error("too many arguments to random()");
        }
        switch (args[0].type) {
            case 3: {
                int n = args[0].intValue();
                return n > 0 ? Constant.getInstance(rand.nextInt(n)) : Constant.error("non-positive argument to random()");
            }
            case 4: {
                double x = args[0].realValue();
                return x > 0.0 ? Constant.getInstance(rand.nextDouble() * x) : Constant.error("non-positive argument to random()");
            }
        }
        return Constant.error("invalid argument random(" + args[0] + ")");
    }

    public static Expr strcat(Expr[] args) {
        String res = "";
        for (int i = 0; i < args.length; ++i) {
            res = res + Builtin.getString(args[i]);
        }
        return Constant.getInstance(res);
    }

    public static Expr substr(Expr[] args) {
        if (args.length < 2 || args.length > 3) {
            return Constant.error("wrong number of args to substr");
        }
        if (args[0].type != 5) {
            return Constant.error("substr: arg 1 must be string, not " + args[0].typeName());
        }
        String str = args[0].stringValue();
        if (args[1].type != 3) {
            return Constant.error("substr: arg 2 must be int, not " + args[1].typeName());
        }
        int offset = args[1].intValue();
        int strlen = str.length();
        if (offset < 0) {
            offset += strlen;
        }
        if (offset > strlen) {
            return Constant.getInstance("");
        }
        if (offset < 0) {
            offset = 0;
        }
        if (args.length == 3) {
            if (args[2].type != 3) {
                return Constant.error("substr: arg 3 must be int, not " + args[2].typeName());
            }
            int len = args[2].intValue();
            if (len < 0) {
                len += strlen - offset;
            }
            return Constant.getInstance(len + offset > strlen ? str.substring(offset) : str.substring(offset, len + offset));
        }
        return Constant.getInstance(str.substring(offset));
    }

    public static Expr strcmp(Expr s1, Expr s2) {
        return Constant.getInstance(Builtin.getString(s1).compareTo(Builtin.getString(s2)));
    }

    public static Expr stricmp(Expr s1, Expr s2) {
        return Constant.getInstance(Builtin.getString(s1).compareToIgnoreCase(Builtin.getString(s2)));
    }

    public static Expr toUpper(Expr expr) {
        return Constant.getInstance(Builtin.getString(expr).toUpperCase());
    }

    public static Expr toLower(Expr expr) {
        return Constant.getInstance(Builtin.getString(expr).toLowerCase());
    }

    public static Expr size(Expr obj) {
        switch (obj.type) {
            case 5: {
                return Constant.getInstance(Builtin.getString(obj).length());
            }
            case -2: {
                return Constant.getInstance(((ListExpr)obj).size());
            }
            case -1: {
                return Constant.getInstance(((RecordExpr)obj).size());
            }
        }
        return Constant.error("invalid argument to size: " + obj);
    }

    public static Expr sum(Expr l) {
        if (l.type != -2) {
            return Constant.error("invalid argument to sum: " + l);
        }
        ListExpr le = (ListExpr)l;
        int ival = 0;
        double rval = 0.0;
        boolean anyReal = false;
        Iterator i = le.iterator();
        block4: while (i.hasNext()) {
            Expr e = ((Expr)i.next()).eval();
            switch (e.type) {
                case 3: {
                    ival += e.intValue();
                    continue block4;
                }
                case 4: {
                    rval += e.realValue();
                    anyReal = true;
                    continue block4;
                }
            }
            return Constant.error("non-number in sum of list: " + e);
        }
        return anyReal ? Constant.getInstance((double)ival + rval) : Constant.getInstance(ival);
    }

    public static Expr avg(Expr l) {
        if (l.type != -2) {
            return Constant.error("invalid argument to avg: " + l);
        }
        ListExpr le = (ListExpr)l;
        if (le.size() == 0) {
            return Constant.getInstance(0.0);
        }
        double sum = 0.0;
        Iterator i = le.iterator();
        block4: while (i.hasNext()) {
            Expr e = ((Expr)i.next()).eval();
            switch (e.type) {
                case 3: {
                    sum += (double)e.intValue();
                    continue block4;
                }
                case 4: {
                    sum += e.realValue();
                    continue block4;
                }
            }
            return Constant.error("non-number in avg of list: " + e);
        }
        return Constant.getInstance(sum / (double)le.size());
    }

    public static Expr min(Expr l) {
        if (l.type != -2) {
            return Constant.error("invalid argument to min: " + l);
        }
        ListExpr le = (ListExpr)l;
        if (le.size() == 0) {
            return Constant.undefined("min of empty list");
        }
        int ival = Integer.MAX_VALUE;
        double rval = Double.MAX_VALUE;
        boolean anyReal = false;
        Iterator i = le.iterator();
        block4: while (i.hasNext()) {
            Expr e = ((Expr)i.next()).eval();
            switch (e.type) {
                case 3: {
                    ival = Math.min(ival, e.intValue());
                    continue block4;
                }
                case 4: {
                    rval = Math.min(rval, e.realValue());
                    continue block4;
                }
            }
            return Constant.error("non-number in min of list: " + e);
        }
        return anyReal ? Constant.getInstance(Math.min(rval, (double)ival)) : Constant.getInstance(ival);
    }

    public static Expr max(Expr l) {
        if (l.type != -2) {
            return Constant.error("invalid argument to max: " + l);
        }
        ListExpr le = (ListExpr)l;
        if (le.size() == 0) {
            return Constant.undefined("max of empty list");
        }
        int ival = Integer.MIN_VALUE;
        double rval = Double.MIN_VALUE;
        boolean anyReal = false;
        Iterator i = le.iterator();
        block4: while (i.hasNext()) {
            Expr e = ((Expr)i.next()).eval();
            switch (e.type) {
                case 3: {
                    ival = Math.max(ival, e.intValue());
                    continue block4;
                }
                case 4: {
                    rval = Math.max(rval, e.realValue());
                    continue block4;
                }
            }
            return Constant.error("non-number in max of list: " + e);
        }
        return anyReal ? Constant.getInstance(Math.max(rval, (double)ival)) : Constant.getInstance(ival);
    }

    public static Expr member(Env env, Expr expr, Expr list) {
        expr = expr.eval(new Env(env));
        list = list.eval(new Env(env));
        if (list.type != -2) {
            return Constant.error("member: arg 2 must be list, not " + list.typeName());
        }
        if (!(expr instanceof Constant)) {
            return Constant.error("member: arg 1 must be constant, not " + list.typeName());
        }
        Constant e = (Constant)expr;
        ListExpr l = (ListExpr)list;
        Iterator i = l.iterator();
        while (i.hasNext()) {
            try {
                Expr x = (Expr)i.next();
                if (!e.equals(x.eval(new Env(env)))) continue;
                return Constant.TRUE;
            }
            catch (ArithmeticException ignore) {
            }
        }
        return Constant.FALSE;
    }

    public static Expr identicalMember(Env env, Expr expr, Expr list) {
        expr = expr.eval(new Env(env));
        list = list.eval(new Env(env));
        if (list.type != -2) {
            return Constant.error("identicalMember: arg 2 must be list, not " + list.typeName());
        }
        if (!(expr instanceof Constant)) {
            return Constant.error("identicalMember: arg 1 must be constant, not " + list.typeName());
        }
        ListExpr l = (ListExpr)list;
        Iterator i = l.iterator();
        while (i.hasNext()) {
            try {
                Expr x = (Expr)i.next();
                if (!expr.is(x.eval(new Env(env)))) continue;
                return Constant.TRUE;
            }
            catch (ArithmeticException ignore) {
            }
        }
        return Constant.FALSE;
    }

    public static Expr regExpMember(Env env, Expr expr, Expr list) {
        expr = expr.eval(new Env(env));
        list = list.eval(new Env(env));
        if (list.type != -2) {
            return Constant.error("regexpMember: arg 2 must be a list, not " + list.typeName());
        }
        if (expr.type != 5) {
            return Constant.error("regexpMember: arg 1 must be a String, not " + list.typeName());
        }
        Pattern p = Builtin.compilePattern(expr.stringValue(), null);
        ListExpr l = (ListExpr)list;
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            e = e.eval(new Env(env));
            if (e.type != 5) {
                return Constant.error("regexpMember: non-string in list");
            }
            if (!p.matcher(e.stringValue()).find()) continue;
            return Constant.TRUE;
        }
        return Constant.FALSE;
    }

    private static int opDecode(String op) {
        if (op.equals("<")) {
            return 9;
        }
        if (op.equals("<=")) {
            return 11;
        }
        if (op.equals(">")) {
            return 10;
        }
        if (op.equals(">=")) {
            return 12;
        }
        if (op.equals("==")) {
            return 5;
        }
        if (op.equals("!=")) {
            return 6;
        }
        if (op.equalsIgnoreCase("is")) {
            return 7;
        }
        if (op.equalsIgnoreCase("isnt")) {
            return 8;
        }
        return -1;
    }

    public static Expr anycompare(Env env, Expr s, Expr l, Expr t) {
        s = s.eval(new Env(env));
        l = l.eval(new Env(env));
        t = t.eval(new Env(env));
        if (s.type != 5) {
            return Constant.error("anycompare: arg 1 must be a string, not " + s.typeName());
        }
        int op = Builtin.opDecode(s.stringValue());
        if (op < 0) {
            return Constant.error("anycompare: unrecognized operator " + s);
        }
        if (l.type != -2) {
            return Constant.error("anycompare: arg 2 must be a string, not " + l.typeName());
        }
        ListExpr le = (ListExpr)l;
        Iterator i = le.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            if ((e = new Op(op, e, t)).eval(new Env(env)) != Constant.TRUE) continue;
            return Constant.TRUE;
        }
        return Constant.FALSE;
    }

    public static Expr allcompare(Expr s, Expr l, Expr t) {
        if (s.type != 5) {
            return Constant.error("allcompare: arg 1 must be a string, not " + s.typeName());
        }
        int op = Builtin.opDecode(s.stringValue());
        if (op < 0) {
            return Constant.error("allcompare: unrecognized operator " + s);
        }
        if (l.type != -2) {
            return Constant.error("allcompare: arg 2 must be a string, not " + l.typeName());
        }
        ListExpr le = (ListExpr)l;
        Iterator i = le.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            if ((e = new Op(op, e.eval(), t)).eval() == Constant.TRUE) continue;
            return Constant.FALSE;
        }
        return Constant.TRUE;
    }

    public static Expr regexp(Expr[] args) {
        if (args.length < 2 || args.length > 3) {
            return Constant.error("wrong number of args to regexp");
        }
        if (args[0].type != 5) {
            return Constant.error("regexp: arg 1 must be string, not " + args[0].typeName());
        }
        String pat = args[0].stringValue();
        if (args[1].type != 5) {
            return Constant.error("regexp: arg 2 must be string, not " + args[1].typeName());
        }
        String str = args[1].stringValue();
        String opts = null;
        if (args.length > 2) {
            if (args[2].type != 5) {
                return Constant.error("regexp: arg 3 must be string, not " + args[2].typeName());
            }
            opts = args[2].stringValue();
        }
        try {
            Pattern p = Builtin.compilePattern(pat, opts);
            return Constant.bool(p.matcher(str).find());
        }
        catch (IllegalArgumentException ex) {
            return Constant.error(ex.getMessage());
        }
    }

    public static Expr glob(Expr str, Expr pat) {
        if (str.type != 5) {
            return Constant.error("glob: arg 1 must be string, not " + str.typeName());
        }
        if (pat.type != 5) {
            return Constant.error("glob: arg 2 must be string, not " + pat.typeName());
        }
        return Constant.bool(Builtin.glob(str.stringValue(), pat.stringValue(), false));
    }

    public static Expr iglob(Expr str, Expr pat) {
        if (str.type != 5) {
            return Constant.error("glob: arg 1 must be string, not " + str.typeName());
        }
        if (pat.type != 5) {
            return Constant.error("glob: arg 2 must be string, not " + pat.typeName());
        }
        return Constant.bool(Builtin.glob(str.stringValue(), pat.stringValue(), true));
    }

    public static Expr time() {
        return Constant.getInstance((int)(System.currentTimeMillis() / 1000L));
    }

    public static Expr interval(Expr secs) {
        if (secs.type != 3) {
            return Constant.error("timeInterval(" + secs.typeName() + ")");
        }
        int time = secs.intValue();
        int[] base = new int[]{60, 60, 24};
        char[] sep = new char[]{':', ':', '+'};
        String res = "";
        for (int i = 0; i < 3; ++i) {
            int n = time % base[i];
            res = n + res;
            if ((time /= base[i]) == 0) break;
            if (n < 10) {
                res = "0" + res;
            }
            res = sep[i] + res;
        }
        if (time > 0) {
            res = time + res;
        }
        return Constant.getInstance(res);
    }

    public static Expr absTime(Expr[] args) {
        if (args.length > 0 && args[0].type == 5) {
            if (args.length > 1) {
                return Constant.error("wrong number of args to absTime");
            }
            return Constant.stringToAbsTime(args[0].stringValue());
        }
        if (args.length > 2) {
            return Constant.error("wrong number of args to absTime");
        }
        long t = 0L;
        int z = 0;
        if (args.length == 0) {
            t = System.currentTimeMillis();
            z = TimeZone.getDefault().getOffset(t) / 1000;
        } else {
            try {
                t = Math.round(Builtin.toReal(args[0]) * 1000.0);
            }
            catch (NumberFormatException e) {
                return Constant.error("absTime(invalid number " + args[0] + ")");
            }
            catch (ClassCastException e) {
                return Constant.error("absTime(" + args[0].typeName() + ")");
            }
            if (args.length == 1) {
                z = TimeZone.getDefault().getOffset(t) / 1000;
            } else {
                if (args[1].type != 3) {
                    return Constant.error("invalid " + args[1].typeName() + " second argument to absTime");
                }
                z = args[1].intValue();
            }
        }
        return Constant.getInstance(t, z);
    }

    public static Expr relTime(Expr arg) {
        if (arg.type == 5) {
            return Constant.stringToRelTime(arg.stringValue());
        }
        try {
            return Constant.getInstance(Math.round(Builtin.toReal(arg) * 1000.0));
        }
        catch (NumberFormatException e) {
            return Constant.error("relTime(invalid number " + arg + ")");
        }
        catch (ClassCastException e) {
            return Constant.error("relTime(" + arg.typeName() + ")");
        }
    }

    public static Expr splitTime(Expr[] args) {
        if (args.length != 1) {
            return Constant.error("wrong number of args to splitTime");
        }
        if (!(args[0] instanceof Constant)) {
            return Constant.error("splitTime arg is not a constant");
        }
        Constant arg = (Constant)args[0];
        switch (arg.type) {
            case 6: {
                GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                cal.setTimeInMillis(arg.milliseconds() + (long)(1000 * arg.zone()));
                RecordExpr res = new RecordExpr(8);
                res.insertAttribute("Type", (Expr)Constant.getInstance("AbsoluteTime"));
                res.insertAttribute("Year", (Expr)Constant.getInstance(cal.get(1)));
                res.insertAttribute("Month", (Expr)Constant.getInstance(cal.get(2) + 1));
                res.insertAttribute("Day", (Expr)Constant.getInstance(cal.get(5)));
                res.insertAttribute("Hours", (Expr)Constant.getInstance(cal.get(11)));
                res.insertAttribute("Minutes", (Expr)Constant.getInstance(cal.get(12)));
                res.insertAttribute("Seconds", (Expr)Constant.getInstance((double)cal.get(13) + (double)cal.get(14) / 1000.0));
                res.insertAttribute("Offset", (Expr)Constant.getInstance(arg.zone()));
                return res;
            }
            case 7: {
                int i;
                Constant sec;
                RecordExpr res = new RecordExpr(5);
                long l = arg.milliseconds();
                if (l % 1000L == 0L) {
                    sec = Constant.getInstance((l /= 1000L) % 60L);
                    i = (int)(l / 60L);
                } else {
                    sec = Constant.getInstance((double)(l % 60000L) / 1000.0);
                    i = (int)(l / 60000L);
                }
                Constant min = Constant.getInstance(i % 60);
                Constant hr = Constant.getInstance((i /= 60) % 24);
                Constant d = Constant.getInstance(i / 24);
                res.insertAttribute("Type", (Expr)Constant.getInstance("RelativeTime"));
                res.insertAttribute("Days", (Expr)d);
                res.insertAttribute("Hours", (Expr)hr);
                res.insertAttribute("Minutes", (Expr)min);
                res.insertAttribute("Seconds", (Expr)sec);
                return res;
            }
        }
        return Constant.error("splitTime arg is not a time constant");
    }

    public static Expr formatTime(Expr t, Expr f) {
        switch (t.type) {
            case 3: {
                t = Builtin.absTime(new Expr[]{t});
                if (t.type == 6) break;
                return t;
            }
            case 6: {
                break;
            }
            default: {
                return Constant.error("invalid first argument to formatTime: " + t);
            }
        }
        Constant time = (Constant)t;
        if (f.type != 5) {
            return Constant.error("invalid second argument to formatTime: " + f);
        }
        String fmt = f.stringValue();
        fmt = Builtin.strftimeToSimpleDateFormat(fmt);
        SimpleDateFormat df = new SimpleDateFormat(fmt);
        return Constant.getInstance(df.format(new Date(time.milliseconds())));
    }

    public static Expr gmtTimeString(Expr secs) {
        if (secs.type != 3) {
            return Constant.error("gmtTimeString(" + secs.typeName() + ")");
        }
        Date when = new Date(1000L * (long)secs.intValue());
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss 'UTC' yyyy");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        String s = df.format(when);
        if (s.charAt(8) == '0') {
            s = s.substring(0, 8) + ' ' + s.substring(9);
        }
        return Constant.getInstance(s);
    }

    public static Expr localTimeString(Expr secs) {
        if (secs.type != 3) {
            return Constant.error("localTimeString(" + secs.typeName() + ")");
        }
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        Date when = new Date(1000L * (long)secs.intValue());
        String s = df.format(when);
        if (s.charAt(8) == '0') {
            s = s.substring(0, 8) + ' ' + s.substring(9);
        }
        return Constant.getInstance(s);
    }

    private static String getString(Expr e) {
        if (e.type == 5) {
            return e.stringValue();
        }
        return e.toString();
    }

    private static boolean glob(String pat, String str, boolean ignoreCase) {
        if (pat.length() == 0) {
            return str.length() == 0;
        }
        char c = pat.charAt(0);
        switch (c) {
            case '?': {
                return str.length() > 0 && Builtin.glob(pat.substring(1), str.substring(1), ignoreCase);
            }
            case '*': {
                return Builtin.glob(pat.substring(1), str, ignoreCase) || str.length() > 0 && Builtin.glob(pat, str.substring(1), ignoreCase);
            }
            case '\\': {
                if (pat.length() == 1) {
                    return str.equals("\\");
                }
                c = pat.charAt(1);
                return str.length() > 0 && str.charAt(0) == c && Builtin.glob(pat.substring(2), str.substring(1), ignoreCase);
            }
        }
        return str.length() > 0 && (str.charAt(0) == c || ignoreCase && str.charAt(0) == Character.toUpperCase(c)) && Builtin.glob(pat.substring(1), str.substring(1), ignoreCase);
    }

    private static double toReal(Expr arg) {
        switch (arg.type) {
            case 4: {
                return arg.realValue();
            }
            case 3: {
                return arg.intValue();
            }
            case 2: {
                return arg.isTrue() ? 1.0 : 0.0;
            }
            case 6: {
                return ((Constant)arg).milliseconds() / 1000L;
            }
            case 7: {
                Long l = (Long)((Constant)arg).value;
                return (double)l.longValue() / 1000.0;
            }
            case 5: {
                return Constant.stringToDouble(arg.stringValue());
            }
        }
        throw new ClassCastException("unknown type");
    }

    private static String strftimeToSimpleDateFormat(String fmt) {
        StringBuffer sb = new StringBuffer();
        boolean literal = false;
        for (int i = 0; i < fmt.length(); ++i) {
            char c = fmt.charAt(i);
            if (c == '%' && i < fmt.length() - 1) {
                c = fmt.charAt(++i);
                String op = null;
                switch (fmt.charAt(i)) {
                    case 'a': {
                        op = "EEE";
                        break;
                    }
                    case 'A': {
                        op = "EEEE";
                        break;
                    }
                    case 'b': {
                        op = "MMM";
                        break;
                    }
                    case 'B': {
                        op = "MMMM";
                        break;
                    }
                    case 'c': {
                        op = "EEE MMM dd HH:mm:ss yyyy";
                        break;
                    }
                    case 'd': {
                        op = "dd";
                        break;
                    }
                    case 'H': {
                        op = "HH";
                        break;
                    }
                    case 'I': {
                        op = "hh";
                        break;
                    }
                    case 'j': {
                        op = "D";
                        break;
                    }
                    case 'm': {
                        op = "MM";
                        break;
                    }
                    case 'M': {
                        op = "mm";
                        break;
                    }
                    case 'p': {
                        op = "a";
                        break;
                    }
                    case 'S': {
                        op = "ss";
                        break;
                    }
                    case 'w': {
                        op = "E";
                        break;
                    }
                    case 'x': {
                        op = "MM/dd/yy";
                        break;
                    }
                    case 'X': {
                        op = "HH:mm:ss";
                        break;
                    }
                    case 'y': {
                        op = "yy";
                        break;
                    }
                    case 'Y': {
                        op = "yyyy";
                        break;
                    }
                    case 'Z': {
                        op = "zzz";
                    }
                }
                if (op == null) {
                    if (!literal) {
                        sb.append('\'');
                        literal = true;
                    }
                    if (c == '%') {
                        sb.append('%');
                        continue;
                    }
                    sb.append(c);
                    if (c != '\'') continue;
                    sb.append('\'');
                    continue;
                }
                if (literal) {
                    sb.append('\'');
                    literal = false;
                }
                sb.append(op);
                continue;
            }
            if (!literal) {
                sb.append('\'');
                literal = true;
            }
            sb.append(c);
            if (c != '\'') continue;
            sb.append(c);
        }
        if (literal) {
            sb.append('\'');
            literal = false;
        }
        return sb.toString();
    }

    private static Pattern compilePattern(String pat, String opts) {
        int flags = 0;
        if (opts != null) {
            block8: for (int i = 0; i < opts.length(); ++i) {
                switch (opts.charAt(i)) {
                    case 'I': 
                    case 'i': {
                        flags |= 2;
                        continue block8;
                    }
                    case 'M': 
                    case 'm': {
                        flags |= 8;
                        continue block8;
                    }
                    case 'S': 
                    case 's': {
                        flags |= 0x20;
                        continue block8;
                    }
                    case 'X': 
                    case 'x': {
                        flags |= 4;
                        continue block8;
                    }
                }
            }
        }
        try {
            return Pattern.compile(pat, flags);
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            int i = msg.indexOf(10);
            if (i >= 0) {
                msg = msg.substring(0, i);
            }
            throw new IllegalArgumentException("regexp: bad pattern '" + pat + "': " + msg);
        }
    }
}

