/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.AttrName;
import condor.classad.AttrRef;
import condor.classad.Constant;
import condor.classad.Expr;
import condor.classad.FuncCall;
import condor.classad.RecordExpr;
import condor.classad.SelectExpr;

public class ClassAd {
    private static String VERSION = "$Id: ClassAd.java,v 1.18 2005/09/30 18:34:36 solomon Exp $";
    private static final String[] AD1_SELF_REQUIREMENTS = new String[]{"Ad1", "self", "requirements"};
    private static final String[] AD2_SELF_REQUIREMENTS = new String[]{"Ad2", "self", "requirements"};
    private static final String[] AD1_SELF_RANK = new String[]{"Ad1", "self", "rank"};
    private static final String[] AD2_SELF_RANK = new String[]{"Ad2", "self", "rank"};

    private ClassAd() {
        throw new RuntimeException();
    }

    public static RecordExpr bind(RecordExpr ad1, RecordExpr ad2) {
        RecordExpr env = new RecordExpr();
        RecordExpr env1 = new RecordExpr();
        env1.insertAttribute("other", (Expr)new AttrRef("Ad2").selectExpr("self")).insertAttribute("self", (Expr)ad1);
        RecordExpr env2 = new RecordExpr();
        env2.insertAttribute("other", (Expr)new AttrRef("Ad1").selectExpr("self")).insertAttribute("self", (Expr)ad2);
        env.insertAttribute("Ad1", (Expr)env1);
        env.insertAttribute("Ad2", (Expr)env2);
        return env;
    }

    public static Expr eval(RecordExpr ad, String[] attrs) {
        Expr sel = ad;
        for (int i = 0; i < attrs.length; ++i) {
            sel = sel.selectExpr(attrs[i]);
        }
        return sel.eval();
    }

    public static Expr eval(RecordExpr ad, String attr) {
        SelectExpr sel = ad.selectExpr(attr);
        return sel.eval();
    }

    public static Expr eval(String name, Expr expr, RecordExpr ad) {
        AttrName n = AttrName.fromString(name);
        ad.insertAttribute(n, expr);
        Expr result = ad.selectExpr(name).eval();
        ad.removeAttribute(n);
        return result;
    }

    public static Expr eval(String attr, RecordExpr ad1, RecordExpr ad2) {
        return ClassAd.eval(ClassAd.bind(ad1, ad2), new String[]{"Ad1", "self", attr});
    }

    public static int[] match(Expr expr1, Expr expr2) {
        if (expr1.type != -1 || expr2.type != -1) {
            return null;
        }
        RecordExpr ad = ClassAd.bind((RecordExpr)expr1, (RecordExpr)expr2);
        if (!ClassAd.eval(ad, AD1_SELF_REQUIREMENTS).isTrue() || !ClassAd.eval(ad, AD2_SELF_REQUIREMENTS).isTrue()) {
            return null;
        }
        try {
            return new int[]{ClassAd.eval(ad, AD1_SELF_RANK).intValue(), ClassAd.eval(ad, AD2_SELF_RANK).intValue()};
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    public static boolean loadJavaLibrary(String className) {
        return FuncCall.loadJavaLibrary(className);
    }

    public static Constant constant(int i) {
        return Constant.getInstance(i);
    }

    public static Constant constant(double x) {
        return Constant.getInstance(x);
    }

    public static Constant constant(String s) {
        return Constant.getInstance(s);
    }
}

