/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.ClassAdSAXHandler;
import condor.classad.Expr;
import condor.classad.Parser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ClassAdParser {
    private static String VERSION = "$Id: ClassAdParser.java,v 1.20 2005/05/06 20:54:06 solomon Exp $";
    public static final int TEXT = 0;
    public static final int XML = 1;
    public final int format;
    private Parser parser;
    private SAXParser saxParser;
    private InputSource source;
    private ClassAdSAXHandler saxHandler;
    private int verbosity = 3;
    private PrintStream errs = System.err;

    public ClassAdParser() {
        this(0);
    }

    public ClassAdParser(int format) {
        this.format = format;
        switch (format) {
            case 0: {
                break;
            }
            case 1: {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                try {
                    this.saxParser = factory.newSAXParser();
                }
                catch (ParserConfigurationException e) {
                    throw new IllegalArgumentException("Cannot create parser: " + e);
                }
                catch (SAXException e) {
                    throw new IllegalArgumentException("Cannot create parser: " + e);
                }
                this.saxHandler = new ClassAdSAXHandler();
                this.saxHandler.setVerbosity(this.verbosity, this.errs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid format " + format);
            }
        }
    }

    public ClassAdParser(String s) {
        this(0);
        this.reset(s);
    }

    public ClassAdParser(String s, int format) {
        this(format);
        this.reset(s);
    }

    public ClassAdParser(InputStream str) {
        this(0);
        this.reset(str);
    }

    public ClassAdParser(InputStream str, int format) {
        this(format);
        this.reset(str);
    }

    public ClassAdParser(Reader rdr) {
        this(0);
        this.reset(rdr);
    }

    public ClassAdParser(Reader rdr, int format) {
        this(format);
        this.reset(rdr);
    }

    public void reset(String s) {
        this.reset(new StringReader(s));
    }

    public void reset(InputStream str) {
        switch (this.format) {
            case 0: {
                this.parser = new Parser(new InputStreamReader(str));
                this.parser.verbosity = this.verbosity;
                this.parser.errs = this.errs;
                break;
            }
            case 1: {
                this.source = new InputSource(str);
            }
        }
    }

    public void reset(Reader rdr) {
        switch (this.format) {
            case 0: {
                this.parser = new Parser(rdr);
                this.parser.verbosity = this.verbosity;
                this.parser.errs = this.errs;
                break;
            }
            case 1: {
                this.source = new InputSource(rdr);
            }
        }
    }

    public Expr parse(boolean acceptPrefix) {
        Expr result = null;
        switch (this.format) {
            case 0: {
                if (this.parser == null) {
                    throw new IllegalStateException("No input source has been specified");
                }
                result = (Expr)this.parser.parse(acceptPrefix);
                break;
            }
            case 1: {
                if (this.source == null) {
                    throw new IllegalStateException("Input stream exhausted");
                }
                try {
                    this.saxParser.parse(this.source, (DefaultHandler)this.saxHandler);
                    result = this.saxHandler.getResult();
                    this.source.getCharacterStream().close();
                    this.source = null;
                    break;
                }
                catch (Exception e) {
                    if (this.verbosity > 1) {
                        e.printStackTrace(this.errs);
                        break;
                    }
                    if (this.verbosity <= 0) break;
                    this.errs.println(e.getMessage());
                }
            }
        }
        return result;
    }

    public Expr parse() {
        return this.parse(true);
    }

    public int nextToken() {
        return this.format == 0 ? this.parser.nextToken() : 0;
    }

    public Object nextValue() {
        return this.format == 0 ? this.parser.nextValue() : null;
    }

    public int getNextToken() {
        return this.format == 0 ? this.parser.getNextToken() : 0;
    }

    public int curLine() {
        return this.parser == null ? 0 : this.parser.curLine();
    }

    public int curColumn() {
        return this.parser == null ? 0 : this.parser.curColumn();
    }

    public boolean enableTracing(boolean on) {
        if (this.parser == null) {
            return false;
        }
        return this.parser.enableTracing(on);
    }

    public int setVerbosity(int level) {
        if (this.verbosity < 0) {
            throw new IllegalArgumentException("bad verbosity level " + level);
        }
        if (this.verbosity > 0 && this.errs == null) {
            throw new IllegalArgumentException("parser has no error stream");
        }
        int result = this.verbosity;
        this.verbosity = level;
        if (this.parser != null) {
            this.parser.verbosity = level;
        }
        if (this.saxHandler != null) {
            this.saxHandler.setVerbosity(this.verbosity, this.errs);
        }
        return result;
    }

    public PrintStream setErrorStream(PrintStream dest) {
        PrintStream result = this.errs;
        if (dest == null) {
            this.setVerbosity(0);
        } else {
            this.errs = dest;
            if (this.parser != null) {
                this.parser.errs = dest;
            }
            if (this.saxHandler != null) {
                this.saxHandler.setVerbosity(this.verbosity, this.errs);
            }
        }
        return result;
    }

    public void printMessage(String msg) {
        if (this.parser != null) {
            this.parser.printMessage(msg);
        }
        if (this.saxHandler != null) {
            this.saxHandler.printMessage(msg);
        }
    }
}

