/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.cedar.CedarInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class ClassAdReader
extends Reader {
    private static String VERSION = "$Id: ClassAdReader.java,v 1.9 2005/05/06 20:54:06 solomon Exp $";
    private CedarInputStream in;
    private String pushBack = null;
    private int pushBackPos = 0;
    private int attrCount = -1;
    private boolean atEOF = false;

    public ClassAdReader(CedarInputStream in) {
        this.in = in;
    }

    public int read() throws IOException {
        if (this.atEOF) {
            return -1;
        }
        if (this.pushBack != null) {
            char result = this.pushBack.charAt(this.pushBackPos++);
            if (this.pushBackPos >= this.pushBack.length()) {
                this.pushBack = null;
                this.pushBackPos = 0;
            }
            return result;
        }
        if (this.attrCount < 0) {
            try {
                if (this.in.readInt() == 0) {
                    this.atEOF = true;
                    return -1;
                }
            }
            catch (EOFException e) {
                this.atEOF = true;
                return -1;
            }
            this.attrCount = this.in.readInt() + 1;
            if (this.attrCount == 1) {
                this.pushBack = "MyType=\"";
            }
            return 91;
        }
        int c = this.in.readUTFchar();
        if (c >= 0) {
            return c;
        }
        switch (this.attrCount--) {
            case 0: {
                this.pushBack = "];\n";
                return 34;
            }
            case 1: {
                this.pushBack = ";\nTargetType=\"";
                return 34;
            }
            case 2: {
                this.pushBack = "\nMyType=\"";
                return 59;
            }
        }
        this.pushBack = "\n";
        return 59;
    }

    public int read(char[] buf, int offset, int len) throws IOException {
        if (this.atEOF) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c < 0) {
                return i > 0 ? i : -1;
            }
            buf[offset + i] = (char)c;
        }
        return len;
    }

    public void close() throws IOException {
        this.in.close();
        this.atEOF = true;
    }

    public int getByteCount() {
        return this.in.getByteCount();
    }
}

