/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.AttrName;
import condor.classad.ClassAdParser;
import condor.classad.Constant;
import condor.classad.Expr;
import condor.classad.ListExpr;
import condor.classad.RecordExpr;
import java.io.PrintStream;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ClassAdSAXHandler
extends DefaultHandler {
    private static String VERSION = "$Id: ClassAdSAXHandler.java,v 1.13 2005/05/06 20:54:07 solomon Exp $";
    private Stack stack = new Stack();
    private StringBuffer pcdata = new StringBuffer();
    private Expr element;
    private ClassAdParser caParser;
    Locator locator;
    private int verbosity = 2;
    private PrintStream errs = System.err;
    static /* synthetic */ Class class$condor$classad$AttrName;

    ClassAdSAXHandler() {
    }

    public Expr getResult() {
        if (this.stack.empty()) {
            return null;
        }
        return (Expr)this.stack.pop();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void warning(SAXParseException e) {
        this.printMessage("Warning", e);
    }

    public void error(SAXParseException e) {
        this.printMessage("Error", e);
    }

    public void characters(char[] ch, int start, int length) {
        this.pcdata.append(ch, start, length);
    }

    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        this.pcdata.setLength(0);
        if ("classads".equals(name) || "l".equals(name)) {
            this.stack.push(new ListExpr());
        } else if ("c".equals(name)) {
            this.stack.push(new RecordExpr());
        } else if ("a".equals(name)) {
            this.stack.push(AttrName.fromString(Constant.unquoteString(attrs.getValue(0))));
        } else if ("b".equals(name)) {
            this.addElement(attrs.getValue(0).charAt(0) == 't' ? Constant.TRUE : Constant.FALSE);
        } else if ("un".equals(name)) {
            this.addElement(Constant.undefined(attrs.getValue(0)));
        } else if ("er".equals(name)) {
            this.addElement(Constant.error(attrs.getValue(0)));
        }
    }

    public void endElement(String uri, String localName, String name) {
        try {
            if ("i".equals(name)) {
                String data = this.pcdata.toString().trim();
                try {
                    this.addElement(Constant.getInstance(Integer.parseInt(data)));
                }
                catch (NumberFormatException e) {
                    this.addElement(ClassAdSAXHandler.errorConstant("ill-formed integer '" + data + "'", this.locator));
                }
            } else if ("r".equals(name)) {
                String data = this.pcdata.toString().trim();
                try {
                    this.addElement(Constant.getInstance(Constant.stringToDouble(data)));
                }
                catch (NumberFormatException e) {
                    this.addElement(ClassAdSAXHandler.errorConstant("ill-formed real '" + data + "'", this.locator));
                }
            } else if ("s".equals(name)) {
                this.addElement(Constant.getInstance(Constant.unquoteString(this.pcdata.toString())));
            } else if ("at".equals(name)) {
                String data = this.pcdata.toString().trim();
                this.addElement(Constant.stringToAbsTime(data));
            } else if ("rt".equals(name)) {
                String data = this.pcdata.toString().trim();
                this.addElement(Constant.stringToRelTime(data));
            } else if ("e".equals(name)) {
                String data = this.pcdata.toString().trim();
                if (this.caParser == null) {
                    this.caParser = new ClassAdParser(data);
                    this.caParser.setVerbosity(this.verbosity);
                    this.caParser.setErrorStream(this.errs);
                } else {
                    this.caParser.reset(data);
                }
                Expr value = this.caParser.parse();
                if (value == null) {
                    value = ClassAdSAXHandler.errorConstant("invalid expression '" + data + "'", this.locator);
                }
                this.addElement(value);
            } else if ("c".equals(name) || "l".equals(name)) {
                Expr elt = (Expr)this.stack.pop();
                this.addElement(elt);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private final void addElement(Expr e) {
        if (this.stack.empty()) {
            this.stack.push(e);
        } else {
            Object top = this.stack.peek();
            if (top.getClass() == (class$condor$classad$AttrName == null ? (class$condor$classad$AttrName = ClassAdSAXHandler.class$("condor.classad.AttrName")) : class$condor$classad$AttrName)) {
                AttrName a = (AttrName)this.stack.pop();
                ((RecordExpr)this.stack.peek()).insertAttribute(a, e);
            } else {
                ((ListExpr)top).add(e);
            }
        }
    }

    private void printMessage(String msg, SAXParseException e) {
        String id;
        if (this.verbosity == 0) {
            return;
        }
        this.errs.print(msg + " at line " + e.getLineNumber());
        int col = e.getColumnNumber();
        if (col > 0) {
            this.errs.print(" col " + col);
        }
        if ((id = e.getPublicId()) == null) {
            id = e.getSystemId();
        }
        if (this.verbosity > 1) {
            this.errs.println(" of " + id + ":\n    " + e);
        } else {
            this.errs.println(e.getMessage());
        }
    }

    void printMessage(String msg) {
        if (this.verbosity == 0) {
            return;
        }
        this.errs.print(msg);
        if (this.locator != null) {
            this.errs.print(" at line ");
            this.errs.print(this.locator.getLineNumber());
            int col = this.locator.getColumnNumber();
            if (col > 0) {
                this.errs.print(" col" + col);
            }
        }
        if (this.verbosity > 1) {
            String id = this.locator.getPublicId();
            if (id == null) {
                id = this.locator.getSystemId();
            }
            if (id != null) {
                this.errs.print(" of " + id);
            }
        }
        this.errs.println();
    }

    private static Expr errorConstant(String msg, Locator locator) {
        StringBuffer sb = new StringBuffer(msg);
        if (locator != null) {
            sb.append(" at line ").append(locator.getLineNumber());
            int col = locator.getColumnNumber();
            if (col > 0) {
                sb.append(" col" + col);
            }
        }
        return Constant.error(sb.toString());
    }

    void setVerbosity(int level, PrintStream dest) {
        this.verbosity = level;
        this.errs = dest;
        if (this.caParser != null) {
            this.caParser.setVerbosity(level);
            this.caParser.setErrorStream(dest);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

