/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.AttrName;
import condor.classad.AttrRef;
import condor.classad.CondExpr;
import condor.classad.Constant;
import condor.classad.Expr;
import condor.classad.FuncCall;
import condor.classad.ListExpr;
import condor.classad.Op;
import condor.classad.RecordExpr;
import condor.classad.SelectExpr;
import condor.classad.SubscriptExpr;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public class ClassAdWriter
extends PrintWriter {
    private static String VERSION = "$Id: ClassAdWriter.java,v 1.15 2005/05/06 20:54:07 solomon Exp $";
    private int rep;
    private boolean needTrailer;
    private int formatFlags = 0;
    private int indentLevel = 0;
    public static final int NATIVE = 1;
    public static final int XML = 2;
    public static final int NO_ESCAPE_STRINGS = 1;
    public static final int SHOW_ERROR_DETAIL = 2;
    public static final int MINIMAL_PARENTHESES = 4;
    public static final int MULTI_LINE_ADS = 8;
    public static final int MULTI_LINE_LISTS = 16;
    public static final int JAVA_REALS = 32;
    public static final int BRIEF = 37;
    public static final int COMPACT = 36;
    public static final int READABLE = 63;

    public ClassAdWriter(OutputStream out, int representation, boolean autoFlush) {
        super(out, autoFlush);
        this.rep = representation;
        if (this.rep == 2) {
            this.println("<?xml version=\"1.0\"?>");
            this.println("<!DOCTYPE classads>");
            this.println("<classads>");
            this.needTrailer = true;
        }
    }

    public ClassAdWriter(OutputStream out, int representation) {
        this(out, representation, false);
    }

    public ClassAdWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
        this.rep = 1;
    }

    public ClassAdWriter(OutputStream out) {
        super(out);
        this.rep = 1;
    }

    public ClassAdWriter(Writer out, int representation, boolean autoFlush) {
        super(out, autoFlush);
        this.rep = representation;
        if (this.rep == 2) {
            this.println("<?xml version=\"1.0\"?>");
            this.println("<!DOCTYPE classads>");
            this.println("<classads>");
            this.needTrailer = true;
        }
    }

    public ClassAdWriter(Writer out, int representation) {
        this(out, representation, false);
    }

    public ClassAdWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
        this.rep = 1;
    }

    public ClassAdWriter(Writer out) {
        super(out);
        this.rep = 1;
    }

    public void setRepresentation(int representation) {
        switch (representation) {
            case 1: 
            case 2: {
                this.rep = representation;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid representation code " + representation);
            }
        }
    }

    public int getRepresentation() {
        return this.rep;
    }

    public void setFormatFlags(int flags) {
        this.formatFlags = flags;
    }

    public int getFormatFlags() {
        return this.formatFlags;
    }

    public void enableFormatFlags(int flags) {
        this.formatFlags |= flags;
    }

    public void disableFormatFlags(int flags) {
        this.formatFlags &= ~flags;
    }

    public void println(Expr exp) {
        this.print(exp);
        this.println();
    }

    public void print(Expr exp) {
        switch (this.rep) {
            case 1: {
                this.printNative(exp, false);
                return;
            }
            case 2: {
                this.printXML(exp);
                return;
            }
        }
        throw new RuntimeException("Internal error, unknown representation " + this.rep);
    }

    public void close() {
        if (this.needTrailer) {
            this.println("</classads>");
        }
        super.close();
    }

    private void indent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.print("    ");
        }
    }

    private void printNative(Expr exp, boolean escapeXML) {
        if (exp == null) {
            super.print(exp);
            return;
        }
        Constant c = exp instanceof Constant ? (Constant)exp : null;
        switch (exp.type) {
            case -6: {
                FuncCall e = (FuncCall)exp;
                String comma = "";
                this.print(e.func);
                this.print('(');
                Iterator i = e.args.iterator();
                while (i.hasNext()) {
                    this.print(comma);
                    this.printNative((Expr)i.next(), escapeXML);
                    comma = ",";
                }
                this.print(')');
                break;
            }
            case -8: {
                CondExpr e = (CondExpr)exp;
                if ((this.formatFlags & 4) == 0) break;
                if (e.ec.prec() <= e.prec()) {
                    this.print('(');
                    this.printNative(e.ec, escapeXML);
                    this.print(')');
                } else {
                    this.printNative(e.ec, escapeXML);
                }
                this.print('?');
                this.printNative(e.et, escapeXML);
                this.print(':');
                this.printNative(e.ef, escapeXML);
                break;
            }
            case -2: {
                ListExpr e = (ListExpr)exp;
                if ((this.formatFlags & 0x10) == 0) {
                    this.print('{');
                    for (int i = 0; i < e.size(); ++i) {
                        if (i > 0) {
                            this.print(',');
                        }
                        this.printNative(e.sub(i), escapeXML);
                    }
                    this.print('}');
                    break;
                }
                this.println('{');
                ++this.indentLevel;
                this.indent();
                for (int i = 0; i < e.size(); ++i) {
                    if (i > 0) {
                        this.println(',');
                        this.indent();
                    }
                    this.printNative(e.sub(i), escapeXML);
                }
                this.println();
                --this.indentLevel;
                this.indent();
                this.print('}');
                break;
            }
            case -7: {
                String op;
                Op e = (Op)exp;
                String string = op = escapeXML ? Expr.opNameXML[e.op] : Expr.opName[e.op];
                if ((this.formatFlags & 4) == 0) {
                    this.print('(');
                    if (e.arg2 == null) {
                        this.print(op);
                    }
                    this.printNative(e.arg1, escapeXML);
                    if (e.arg2 != null) {
                        this.print(op);
                        this.printNative(e.arg2, escapeXML);
                    }
                    this.print(')');
                    break;
                }
                if (e.arg2 == null) {
                    this.print(op);
                }
                if (e.arg1.prec() < e.prec()) {
                    this.print('(');
                    this.printNative(e.arg1, escapeXML);
                    this.print(')');
                } else {
                    this.printNative(e.arg1, escapeXML);
                }
                if (e.arg2 == null) break;
                this.print(op);
                if (e.arg2.prec() <= e.prec()) {
                    this.print('(');
                    this.printNative(e.arg2, escapeXML);
                    this.print(')');
                    break;
                }
                this.printNative(e.arg2, escapeXML);
                break;
            }
            case -1: {
                RecordExpr e = (RecordExpr)exp;
                boolean first = true;
                if ((this.formatFlags & 8) == 0) {
                    this.print('[');
                    Iterator i = e.attributes();
                    while (i.hasNext()) {
                        if (first) {
                            first = false;
                        } else {
                            this.print(';');
                        }
                        AttrName attr = (AttrName)i.next();
                        this.printNativeAttrName(attr, escapeXML);
                        this.print("=");
                        this.printNative(e.lookup(attr), escapeXML);
                    }
                    this.print(']');
                    break;
                }
                this.println('[');
                ++this.indentLevel;
                this.indent();
                Iterator i = e.attributes();
                while (i.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        this.println(';');
                        this.indent();
                    }
                    AttrName attr = (AttrName)i.next();
                    this.printNativeAttrName(attr, escapeXML);
                    this.print(" = ");
                    this.printNative(e.lookup(attr), escapeXML);
                }
                this.println();
                --this.indentLevel;
                this.indent();
                this.print(']');
                break;
            }
            case -5: {
                SelectExpr e = (SelectExpr)exp;
                this.printNative(e.base, escapeXML);
                this.print('.');
                this.print(e.selector);
                break;
            }
            case -4: {
                SubscriptExpr e = (SubscriptExpr)exp;
                this.printNative(e.base, escapeXML);
                this.print('[');
                this.printNative(e.selector, escapeXML);
                this.print(']');
                break;
            }
            case -3: {
                this.printNativeAttrName(((AttrRef)exp).name, escapeXML);
                break;
            }
            case 6: {
                this.print("absTime(\"");
                this.print(c.value);
                this.print("\")");
                break;
            }
            case 7: {
                this.print("relTime(\"");
                this.print(Constant.relTimeToString(c.milliseconds()));
                this.print("\")");
                break;
            }
            case 2: {
                this.print(c.isTrue());
                break;
            }
            case 1: {
                if ((this.formatFlags & 2) == 0) {
                    this.print("ERROR");
                    break;
                }
                this.print("ERROR(");
                this.print(c.value);
                this.print(')');
                break;
            }
            case 0: {
                if ((this.formatFlags & 2) == 0) {
                    this.print("UNDEFINED");
                    break;
                }
                this.print("UNDEFINED(");
                this.print(c.value);
                this.print(')');
                break;
            }
            case 3: {
                this.print(c.value);
                break;
            }
            case 4: {
                this.print((this.formatFlags & 0x20) == 0 ? Constant.doubleToString(c.realValue()) : c.value);
                break;
            }
            case 5: {
                if ((this.formatFlags & 1) == 0) {
                    this.print('\"');
                    this.printQuotedString((String)c.value, '\"', escapeXML);
                    this.print('\"');
                    break;
                }
                this.print(c.value);
            }
        }
    }

    private void printNativeAttrName(AttrName attr, boolean escapeXML) {
        if (attr.needsQuoting()) {
            this.print("'");
            this.printQuotedString(attr.rawString(), '\'', escapeXML);
            this.print("'");
        } else {
            this.printQuotedString(attr.rawString(), '\u0000', escapeXML);
        }
    }

    private void printXML(Expr exp) {
        if (exp == null) {
            super.print(exp);
            return;
        }
        Constant c = exp instanceof Constant ? (Constant)exp : null;
        switch (exp.type) {
            case -2: {
                ListExpr e = (ListExpr)exp;
                if ((this.formatFlags & 0x10) == 0) {
                    this.print("<l>");
                    for (int i = 0; i < e.size(); ++i) {
                        this.printXML(e.sub(i));
                    }
                    this.print("</l>");
                    break;
                }
                this.println("<l>");
                ++this.indentLevel;
                for (int i = 0; i < e.size(); ++i) {
                    this.indent();
                    this.printXML(e.sub(i));
                    this.println();
                }
                --this.indentLevel;
                this.indent();
                this.print("</l>");
                break;
            }
            case -1: {
                RecordExpr e = (RecordExpr)exp;
                boolean first = true;
                if ((this.formatFlags & 8) == 0) {
                    this.print("<c>");
                    Iterator i = e.attributes();
                    while (i.hasNext()) {
                        AttrName attr = (AttrName)i.next();
                        this.print("<a n=\"");
                        this.printQuotedString(attr.rawString(), 'q', true);
                        this.print("\">");
                        this.printXML(e.lookup(attr));
                        this.print("</a>");
                    }
                    this.print("</c>");
                    break;
                }
                this.println("<c>");
                ++this.indentLevel;
                Iterator i = e.attributes();
                while (i.hasNext()) {
                    this.indent();
                    AttrName attr = (AttrName)i.next();
                    this.print("<a n=\"");
                    this.printQuotedString(attr.rawString(), 'q', true);
                    this.print("\">");
                    this.printXML(e.lookup(attr));
                    this.println("</a>");
                }
                --this.indentLevel;
                this.print("</c>");
                break;
            }
            case 6: {
                this.print("<at>");
                this.print(c.value);
                this.print("</at>");
                break;
            }
            case 7: {
                this.print("<rt>");
                this.print(Constant.relTimeToString(c.milliseconds()));
                this.print("</rt>");
                break;
            }
            case 2: {
                this.print(c.isTrue() ? "<b v=\"t\"/>" : "<b v=\"f\"/>");
                break;
            }
            case 1: {
                String a = c.annotation();
                if (a.length() > 0) {
                    this.print("<er a=\"");
                    this.printQuotedString(a, 'q', true);
                    this.print("\"/>");
                    break;
                }
                this.print("<er/>");
                break;
            }
            case 0: {
                String a = c.annotation();
                if (a.length() > 0) {
                    this.print("<un a=\"");
                    this.printQuotedString(a, 'q', true);
                    this.print("\"/>");
                    break;
                }
                this.print("<un/>");
                break;
            }
            case 3: {
                this.print("<i>");
                this.print(c.value);
                this.print("</i>");
                break;
            }
            case 4: {
                this.print("<r>");
                this.print(Constant.doubleToString(c.realValue()));
                this.print("</r>");
                break;
            }
            case 5: {
                this.print("<s>");
                this.printQuotedString((String)c.value, '\u0000', true);
                this.print("</s>");
                break;
            }
            default: {
                this.print("<e>");
                this.printNative(exp, true);
                this.print("</e>");
            }
        }
    }

    private final void printQuotedString(String s, char quote, boolean escapeXML) {
        block13: for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i) & 0xFF;
            switch (c) {
                case 10: {
                    this.print("\\n");
                    continue block13;
                }
                case 9: {
                    this.print("\\t");
                    continue block13;
                }
                case 8: {
                    this.print("\\b");
                    continue block13;
                }
                case 13: {
                    this.print("\\r");
                    continue block13;
                }
                case 12: {
                    this.print("\\f");
                    continue block13;
                }
                case 92: {
                    this.print("\\\\");
                    continue block13;
                }
                case 34: {
                    if (quote == '\"') {
                        this.print("\\\"");
                        continue block13;
                    }
                    if (quote == 'q') {
                        this.print("&quot;");
                        continue block13;
                    }
                    this.print('\"');
                    continue block13;
                }
                case 39: {
                    if (quote == '\'') {
                        this.print("\\'");
                        continue block13;
                    }
                    this.print('\'');
                    continue block13;
                }
                case 60: {
                    this.print(escapeXML ? "&lt;" : "<");
                    continue block13;
                }
                case 62: {
                    this.print(escapeXML ? "&gt;" : ">");
                    continue block13;
                }
                case 38: {
                    this.print(escapeXML ? "&amp;" : "&");
                    continue block13;
                }
                default: {
                    if (c < 32 || c > 126) {
                        this.print('\\');
                        this.print((char)(48 + (c >> 6 & 7)));
                        this.print((char)(48 + (c >> 3 & 7)));
                        this.print((char)(48 + (c & 7)));
                        continue block13;
                    }
                    this.print((char)c);
                }
            }
        }
    }

    private void printHex(double x) {
        long l = Double.doubleToLongBits(x);
        for (int i = 60; i >= 0; i -= 4) {
            this.print(Character.forDigit((int)(l >> i & 0xFL), 16));
        }
    }
}

