/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.Constant;
import condor.classad.Env;
import condor.classad.Expr;

public class CondExpr
extends Expr {
    private static String VERSION = "$Id: CondExpr.java,v 1.21 2005/05/06 20:54:07 solomon Exp $";
    public final Expr ec;
    public final Expr et;
    public final Expr ef;

    public CondExpr(Expr ec, Expr et, Expr ef) {
        super(-8);
        this.ec = ec;
        this.et = et;
        this.ef = ef;
    }

    public StringBuffer toString(StringBuffer sb) {
        sb.append('(');
        this.ec.toString(sb);
        sb.append('?');
        this.et.toString(sb);
        sb.append(':');
        this.ef.toString(sb);
        return sb.append(')');
    }

    public boolean sameAs(Expr other) {
        if (this.type != other.type) {
            return false;
        }
        CondExpr o = (CondExpr)other;
        return this.ec.sameAs(o.ec) && this.et.sameAs(o.et) && this.ef.sameAs(o.ef);
    }

    public int prec() {
        return -1;
    }

    protected Expr eval1(Env env) {
        Env env1 = new Env(env);
        Expr ecv = this.ec.eval(env1);
        switch (ecv.type) {
            case 2: {
                return ecv.isTrue() ? this.et.eval(env) : this.ef.eval(env);
            }
            case 0: 
            case 1: {
                env.clear();
                return ecv;
            }
        }
        env.clear();
        return Constant.error("type " + ecv.typeName() + " found where boolean expected" + " in conditional expression");
    }
}

