/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.Env;
import condor.classad.Expr;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Constant
extends Expr {
    private static String VERSION = "$Id: Constant.java,v 1.33 2008/10/06 21:40:13 roy Exp $";
    private static Map instanceMap = Collections.synchronizedMap(new WeakHashMap());
    public static final Constant Undef = new Constant("", 0);
    public static final Constant Error = new Constant("", 1);
    public static final Constant TRUE = new Constant(null, 2);
    public static final Constant FALSE = new Constant(null, 2);
    public final Object value;
    private static final Constant INT_ZERO = new Constant(new Integer(0), 3);
    private static final Constant INT_ONE = new Constant(new Integer(1), 3);
    private static final Constant REAL_ZERO = new Constant(new Double(0.0), 4);
    private static final Constant REAL_NEG_ZERO = new Constant(new Double(-0.0), 4);
    private static final Constant REAL_ONE = new Constant(new Double(1.0), 4);
    private static final Constant EMPTY_STRING = new Constant("", 5);
    private static final int[] threshold = new int[]{86400000, 3600000, 60000, 1000};
    private static DecimalFormat fmt = new DecimalFormat("0.000000000000000E00");
    private static final char[] seperator;
    private static final Pattern reltimePattern;
    private static final Pattern timeZonePattern;
    private static final Pattern dateTimePattern;
    private static final int[] groupToField;

    public boolean sameAs(Expr other) {
        try {
            if (other == null) {
                return false;
            }
            if (this.type == 4 || this.type == 3) {
                return this.realValue() == other.realValue();
            }
            return this.is(other);
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    private Constant(Object value, int type) {
        super(type);
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Constant getInstance(Object val, int type) {
        Constant result = null;
        Map map = instanceMap;
        synchronized (map) {
            result = (Constant)instanceMap.get(val);
            if (result == null) {
                result = new Constant(val, type);
                instanceMap.put(val, result);
            }
        }
        return result;
    }

    public static final Constant getInstance(int value) {
        if (value == 0) {
            return INT_ZERO;
        }
        if (value == 1) {
            return INT_ONE;
        }
        return Constant.getInstance(new Integer(value), 3);
    }

    public static final Constant getInstance(double value) {
        if (value == 0.0) {
            return (Double.doubleToLongBits(value) & Long.MIN_VALUE) != 0L ? REAL_NEG_ZERO : REAL_ZERO;
        }
        if (value == 1.0) {
            return REAL_ONE;
        }
        return Constant.getInstance(new Double(value), 4);
    }

    public static final Constant getInstance(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static final Constant getInstance(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return EMPTY_STRING;
        }
        return Constant.getInstance(value, 5);
    }

    public static final Constant getInstance(char[] buf, int start, int stop) {
        return Constant.getInstance(Constant.unquoteString(buf, start, stop));
    }

    public static final Constant getInstance(Date date) {
        int off = TimeZone.getDefault().getOffset(date.getTime()) / 1000;
        return Constant.getInstance(new Timestamp(date.getTime(), off), 6);
    }

    public static final Constant getInstance(Date date, int tz) {
        return Constant.getInstance(new Timestamp(date.getTime(), tz), 6);
    }

    public static final Constant getInstance(long t, int z) {
        return Constant.getInstance(new Timestamp(t, z), 6);
    }

    public static final Constant getInstance(long value) {
        return Constant.getInstance(new Long(value), 7);
    }

    public static Constant error(String msg) {
        if (msg == null) {
            msg = "";
        }
        return new Constant(msg, 1);
    }

    public static Constant undefined(String msg) {
        if (msg == null) {
            msg = "";
        }
        return new Constant(msg, 0);
    }

    public static Constant bool(boolean b) {
        return b ? TRUE : FALSE;
    }

    protected Expr eval1(Env env) {
        env.clear();
        return this;
    }

    public int prec() {
        return 12;
    }

    public StringBuffer toString(StringBuffer sb) {
        switch (this.type) {
            case 0: {
                return sb.append("UNDEFINED");
            }
            case 1: {
                return sb.append("ERROR");
            }
            case 2: {
                return sb.append(this == TRUE ? "true" : "false");
            }
            case 3: {
                return sb.append(this.value);
            }
            case 4: {
                return sb.append(Constant.doubleToString(this.realValue()));
            }
            case 5: {
                return Constant.escapeString(sb, (String)this.value, '\"');
            }
            case 6: {
                return sb.append("absTime(\"").append(this.value).append("\")");
            }
            case 7: {
                long v = (Long)this.value;
                return sb.append("relTime(\"").append(Constant.relTimeToString(v)).append("\")");
            }
        }
        throw new RuntimeException("unknown type");
    }

    public int intValue() throws ArithmeticException {
        if (this.type != 3) {
            throw new ArithmeticException(this.typeName() + " " + this + " in integer context");
        }
        return (Integer)this.value;
    }

    public double realValue() throws ArithmeticException {
        switch (this.type) {
            case 4: {
                return (Double)this.value;
            }
            case 3: {
                return ((Integer)this.value).doubleValue();
            }
        }
        throw new ArithmeticException(this.typeName() + " " + this + " in real context");
    }

    public String stringValue() throws ArithmeticException {
        if (this.type != 5) {
            throw new ArithmeticException(this.typeName() + " " + this + " in string context");
        }
        return (String)this.value;
    }

    public boolean booleanValue() throws ArithmeticException {
        if (this.type != 2) {
            throw new ArithmeticException(this.typeName() + " " + this + " in boolean context");
        }
        return this == TRUE;
    }

    public boolean isTrue() {
        return this == TRUE;
    }

    public long milliseconds() throws ArithmeticException {
        if (this.type == 6) {
            return ((Timestamp)this.value).ms;
        }
        if (this.type == 7) {
            return (Long)this.value;
        }
        throw new ArithmeticException(this.typeName() + " " + this + " in integer context");
    }

    public int zone() throws ArithmeticException {
        if (this.type != 6) {
            throw new ArithmeticException("zone(" + this.typeName() + ")");
        }
        return ((Timestamp)this.value).offset;
    }

    public String annotation() throws ArithmeticException {
        if (this.type != 1 && this.type != 0) {
            throw new ArithmeticException("annotation(" + this.typeName() + ")");
        }
        return (String)this.value;
    }

    static final String doubleToString(double d) {
        String v = fmt.format(d);
        if (Double.isNaN(d)) {
            return "real(\"NaN\")";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "real(\"-INF\")" : "real(\"INF\")";
        }
        if (d == 0.0) {
            return (Double.doubleToLongBits(d) & Long.MIN_VALUE) == 0L ? "0.0" : "-0.0";
        }
        int ePos = v.indexOf(69);
        if (ePos >= 0 && v.charAt(ePos + 1) != '-') {
            v = v.substring(0, ++ePos) + '+' + v.substring(ePos);
        }
        return v;
    }

    static final double stringToDouble(String s) {
        if ((s = s.trim()).equalsIgnoreCase("inf")) {
            return Double.POSITIVE_INFINITY;
        }
        if (s.equalsIgnoreCase("-inf")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (s.equalsIgnoreCase("nan")) {
            return Double.NaN;
        }
        return Double.parseDouble(s);
    }

    static final String unquoteString(char[] buf, int start, int stop) {
        char[] result = new char[stop - start];
        int i = start;
        int j = 0;
        while (i < stop) {
            char c;
            if ((c = buf[i++]) == '\\') {
                int val;
                if (i >= stop) {
                    return null;
                }
                if ((val = Character.digit(c = buf[i++], 8)) >= 0) {
                    int n;
                    int maxDigits;
                    int n2 = maxDigits = val < 52 ? 2 : 1;
                    if (stop - i < maxDigits) {
                        maxDigits = stop - i;
                    }
                    for (int k = 0; k < maxDigits && (n = Character.digit(c = buf[i], 8)) >= 0; ++k) {
                        val = (val << 3) + n;
                        ++i;
                    }
                    if (val == 0) {
                        return null;
                    }
                    c = (char)val;
                } else {
                    switch (c) {
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case '\"': 
                        case '\'': 
                        case '\\': {
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                }
            }
            result[j++] = c;
        }
        return new String(result, 0, j);
    }

    static final String unquoteString(String s) {
        int l = s.length();
        char[] v = new char[l];
        s.getChars(0, l, v, 0);
        return Constant.unquoteString(v, 0, l);
    }

    static StringBuffer escapeString(StringBuffer sb, String s, char quote) {
        sb.append(quote);
        block8: for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i) & 0xFF;
            if (c == quote) {
                sb.append('\\');
            }
            switch (c) {
                case 10: {
                    sb.append('\\').append('n');
                    continue block8;
                }
                case 9: {
                    sb.append('\\').append('t');
                    continue block8;
                }
                case 8: {
                    sb.append('\\').append('b');
                    continue block8;
                }
                case 13: {
                    sb.append('\\').append('r');
                    continue block8;
                }
                case 12: {
                    sb.append('\\').append('f');
                    continue block8;
                }
                case 92: {
                    sb.append('\\').append('\\');
                    continue block8;
                }
                default: {
                    if (c < 32 || c > 126) {
                        sb.append('\\');
                        sb.append((char)(48 + (c >> 6 & 7)));
                        sb.append((char)(48 + (c >> 3 & 7)));
                        sb.append((char)(48 + (c & 7)));
                        continue block8;
                    }
                    sb.append((char)c);
                }
            }
        }
        return sb.append(quote);
    }

    static final String relTimeToString(long t) {
        if (t == 0L) {
            return "0";
        }
        StringBuffer buf = new StringBuffer();
        if (t < 0L) {
            buf.append('-');
            t = -t;
        }
        int i = 0;
        if (t < 1000L) {
            buf.append("0");
        } else {
            while (t < (long)threshold[i]) {
                ++i;
            }
            Constant.formatDecimal(buf, (int)(t / (long)threshold[i]), 1);
            while (true) {
                t %= (long)threshold[i];
                if (i >= seperator.length) break;
                buf.append(seperator[i]);
                Constant.formatDecimal(buf, (int)(t / (long)threshold[++i]), 10);
            }
        }
        if (t > 0L) {
            buf.append('.');
            Constant.formatDecimal(buf, (int)t, 100);
        }
        return buf.toString();
    }

    public static Constant stringToRelTime(String s) {
        if (s == null) {
            return Constant.error("invalid RelTime string: null");
        }
        boolean negative = false;
        String[] val = new String[5];
        String[] sep = new String[5];
        int nFields = 0;
        boolean dotSeen = false;
        int end = 0;
        Matcher m = reltimePattern.matcher(s);
        while (m.find()) {
            if (m.group(1) != null) {
                negative = true;
            } else {
                if (nFields >= val.length) {
                    return Constant.error("invalid RelTime string \"" + s + "\": too many fields");
                }
                val[nFields] = m.group(2);
                String g = m.group(3);
                if (g != null && g.charAt(0) == '.') {
                    if (dotSeen) {
                        return Constant.error("invalid RelTime string \"" + s + "\": two dots");
                    }
                    dotSeen = true;
                }
                sep[nFields] = g;
                ++nFields;
            }
            end = m.end();
        }
        if (end != s.length()) {
            return Constant.error("invalid RelTime string \"" + s + "\": extra characters at the end");
        }
        String[] pos = new String[5];
        int field = dotSeen ? 5 : 4;
        for (int i = nFields - 1; i >= 0; --i) {
            --field;
            if (sep[i] != null) {
                switch (sep[i].charAt(0)) {
                    case '+': 
                    case 'D': 
                    case 'd': {
                        field = 0;
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        field = 1;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        field = 2;
                        break;
                    }
                    case '.': {
                        field = 3;
                    }
                }
            }
            pos[field] = val[i];
        }
        long result = 0L;
        String v = pos[4];
        if (v != null) {
            int l = v.length();
            for (int i = 0; i < 3; ++i) {
                if (i < l) {
                    result = 10L * result + (long)Character.getNumericValue(v.charAt(i));
                    continue;
                }
                result *= 10L;
            }
            if (l > 3 && v.charAt(3) >= '5') {
                ++result;
            }
        }
        for (int i = 3; i >= 0; --i) {
            if (pos[i] == null) continue;
            result += (long)(Integer.parseInt(pos[i]) * threshold[i]);
        }
        if (negative) {
            result = -result;
        }
        return Constant.getInstance(result);
    }

    public static Constant stringToAbsTime(String s) {
        GregorianCalendar cal;
        if (s == null) {
            return Constant.error("Null abstime");
        }
        Matcher m = timeZonePattern.matcher(s);
        int last = s.length() - 1;
        if (last < 0) {
            return Constant.error("Invalid absTime \"" + s + "\"");
        }
        if (s.charAt(last) == 'z' || s.charAt(last) == 'Z') {
            cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            s = s.substring(0, last);
        } else if (m.find()) {
            String zone = m.group(1) + m.group(2);
            cal = new GregorianCalendar(TimeZone.getTimeZone("GMT" + zone));
            s = s.substring(0, m.start(0));
        } else {
            cal = new GregorianCalendar();
        }
        cal.clear();
        m = dateTimePattern.matcher(s);
        if (!m.matches()) {
            return Constant.error("Invalid absTime \"" + s + "\"");
        }
        for (int i = 1; i <= 6; ++i) {
            String g = m.group(i);
            if (g == null) continue;
            int v = Integer.parseInt(g);
            if (i == 2) {
                --v;
            }
            cal.set(groupToField[i], v);
        }
        int offset = cal.get(15) + cal.get(16);
        return Constant.getInstance(new Timestamp(cal.getTimeInMillis(), offset / 1000), 6);
    }

    private static final void formatDecimal(StringBuffer buf, int n, int m) {
        buf.append(n / m);
        while (m > 1) {
            buf.append((n %= m) / (m /= 10));
        }
    }

    public boolean equals(Object other) {
        Constant c;
        try {
            c = (Constant)other;
        }
        catch (ClassCastException e) {
            throw new ArithmeticException("attempt to compare " + this.typeName() + " == " + other);
        }
        switch (this.type) {
            case 3: {
                if (c.type == 3) {
                    return this.intValue() == c.intValue();
                }
                return (double)this.intValue() == c.realValue();
            }
            case 4: {
                return this.realValue() == c.realValue();
            }
            case 2: {
                if (c.type != 2) {
                    throw new ArithmeticException("attempt to compare " + this.typeName() + " == " + c.typeName());
                }
                return this == c;
            }
            case 5: {
                return this.stringValue().equalsIgnoreCase(c.stringValue());
            }
            case 6: 
            case 7: {
                if (this.type != c.type) {
                    throw new ArithmeticException("attempt to compare " + this.typeName() + " == " + c.typeName());
                }
                return this.milliseconds() == c.milliseconds();
            }
        }
        throw new ArithmeticException("attempt to compare " + this.typeName() + " == " + c.typeName());
    }

    public int hashCode() {
        switch (this.type) {
            case 3: {
                return this.intValue();
            }
            case 4: {
                return (int)Double.doubleToLongBits(this.realValue());
            }
            case 2: {
                return this.booleanValue() ? 1 : 0;
            }
            case 5: {
                return this.stringValue().toLowerCase().hashCode();
            }
            case 6: 
            case 7: {
                return (int)this.milliseconds();
            }
            case 0: {
                return Integer.MAX_VALUE;
            }
            case 1: {
                return Integer.MIN_VALUE;
            }
        }
        throw new RuntimeException("unknown type");
    }

    static {
        DecimalFormatSymbols syms = new DecimalFormatSymbols();
        syms.setInfinity("INF");
        syms.setNaN("NaN");
        fmt.setDecimalFormatSymbols(syms);
        seperator = new char[]{'+', ':', ':'};
        reltimePattern = Pattern.compile("^\\s*(-)|\\G\\s*(\\d+)\\s*(([+:.dDhHmMsS]))?");
        timeZonePattern = Pattern.compile("\\D*([+-]\\d\\d):?(\\d\\d)$");
        dateTimePattern = Pattern.compile("^\\D*(\\d\\d\\d\\d)(?:\\D*(\\d\\d)(?:\\D*(\\d\\d)(?:\\D*(\\d\\d)(?:\\D*(\\d\\d)(?:\\D*(\\d\\d))?)?)?)?)?");
        groupToField = new int[]{-1, 1, 2, 5, 11, 12, 13};
    }

    private static class Timestamp {
        private static final SimpleDateFormat dateAndTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        public long ms;
        public int offset;

        public Timestamp(long ms, int offset) {
            this.ms = ms;
            this.offset = offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof Timestamp)) {
                return false;
            }
            Timestamp ts = (Timestamp)o;
            return this.ms == ts.ms && this.offset == ts.offset;
        }

        public String toString() {
            char[] zone = new char[6];
            int off = this.offset;
            String dt = dateAndTimeFormat.format(new Date(this.ms + (long)(1000 * off)));
            if (off < 0) {
                off = -off;
                zone[0] = 45;
            } else {
                zone[0] = 43;
            }
            zone[5] = Character.forDigit((off /= 60) % 10, 10);
            zone[4] = Character.forDigit((off /= 10) % 6, 10);
            zone[3] = 58;
            zone[2] = Character.forDigit((off /= 6) % 10, 10);
            zone[1] = Character.forDigit((off /= 10) % 6, 10);
            off /= 60;
            return dt + new String(zone);
        }

        static {
            dateAndTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }
}

