/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.AttrName;
import condor.classad.Expr;
import condor.classad.RecordExpr;

public class Env {
    private RecordExpr recEx;
    private Env next;

    public Env(RecordExpr recEx, Env next) {
        this.recEx = recEx;
        this.next = next;
    }

    public Env() {
    }

    public Env(Env env) {
        this.recEx = env.recEx;
        this.next = env.next;
    }

    public void clear() {
        this.recEx = null;
        this.next = null;
    }

    public void push(RecordExpr recEx) {
        this.next = new Env(recEx, this.next);
    }

    public RecordExpr pop(int n) {
        RecordExpr result = null;
        while (n-- > 0) {
            if (this.next == null) {
                return null;
            }
            result = this.next.recEx;
            this.next = this.next.next;
        }
        return result;
    }

    public Expr search(AttrName name) {
        while (this.next != null) {
            Expr result = this.next.recEx.lookup(name);
            if (result != null) {
                return result;
            }
            this.next = this.next.next;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Env{");
        String sep = "";
        Env p = this.next;
        while (p != null) {
            String s = p.recEx.toString();
            sb.append(sep);
            sep = "|";
            if (s.length() > 20) {
                sb.append(s.substring(0, 20)).append("...");
            } else {
                sb.append(s);
            }
            p = p.next;
        }
        return sb.append('}').toString();
    }
}

