/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.ClassAd;
import condor.classad.Constant;
import condor.classad.Env;
import condor.classad.SelectExpr;
import condor.classad.SubscriptExpr;
import java.util.HashSet;

public abstract class Expr {
    private static String VERSION = "$Id: Expr.java,v 1.30 2005/05/06 20:54:07 solomon Exp $";
    public final int type;
    public static int dblevel = 0;
    public static final int COND = -8;
    public static final int OP = -7;
    public static final int CALL = -6;
    public static final int SELECTION = -5;
    public static final int SUBSCRIPT = -4;
    public static final int ATTRIBUTE = -3;
    public static final int LIST = -2;
    public static final int RECORD = -1;
    public static final int UNDEFINED = 0;
    public static final int ERROR = 1;
    public static final int BOOLEAN = 2;
    public static final int INTEGER = 3;
    public static final int REAL = 4;
    public static final int STRING = 5;
    public static final int ABSOLUTE_TIME = 6;
    public static final int RELATIVE_TIME = 7;
    private static final String[] tNames = new String[]{"conditional expression", "operator expression", "function call", "selection", "subscripted expression", "attribute reference", "list", "record", "undefined", "error", "boolean", "integer", "real", "string", "timestamp", "time interval"};
    private static final Constant CYCLIC_REF = Constant.undefined("Cyclic attribute definition");
    public static final String[] opName = new String[]{"||", "&&", "|", "^", "&", "==", "!=", " is ", " isnt ", "<", ">", "<=", ">=", "<<", ">>", ">>>", "+", "-", "*", "/", "%", "+", "-", "~", "!"};
    public static final String[] opNameXML = new String[]{"||", "&amp;&amp;", "|", "^", "&amp;", "==", "!=", " is ", " isnt ", "&lt;", "&gt;", "&lt;=", "&gt;=", "&lt;&lt;", "&gt;&gt;", "&gt;&gt;&gt;", "+", "-", "*", "/", "%", "+", "-", "~", "!"};
    public static final int OR = 0;
    public static final int AND = 1;
    public static final int BITOR = 2;
    public static final int BITXOR = 3;
    public static final int BITAND = 4;
    public static final int EQUAL = 5;
    public static final int NOT_EQUAL = 6;
    public static final int SAME = 7;
    public static final int DIFFERENT = 8;
    public static final int LESS = 9;
    public static final int GREATER = 10;
    public static final int LESS_EQ = 11;
    public static final int GREATER_EQ = 12;
    public static final int LEFT_SHIFT = 13;
    public static final int RIGHT_SHIFT = 14;
    public static final int URIGHT_SHIFT = 15;
    public static final int PLUS = 16;
    public static final int MINUS = 17;
    public static final int TIMES = 18;
    public static final int DIV = 19;
    public static final int MOD = 20;
    public static final int UPLUS = 21;
    public static final int UMINUS = 22;
    public static final int BIT_COMPLEMENT = 23;
    public static final int NOT = 24;
    protected static final int MAXPREC = 11;

    protected Expr(int type) {
        this.type = type;
    }

    public SelectExpr selectExpr(String selector) {
        return new SelectExpr(this, selector);
    }

    public SubscriptExpr subExpr(int subscript) {
        return new SubscriptExpr(this, ClassAd.constant(subscript));
    }

    protected String typeName() {
        return tNames[this.type - -8];
    }

    public final boolean isConstant() {
        return this.type >= -2;
    }

    public int intValue() throws ArithmeticException {
        throw new ArithmeticException(this.typeName() + " " + this + " in integer context");
    }

    public double realValue() throws ArithmeticException {
        throw new ArithmeticException(this.typeName() + " " + this + " in real context");
    }

    public String stringValue() throws ArithmeticException {
        throw new ArithmeticException(this.typeName() + " " + this + " in string context");
    }

    public boolean isTrue() {
        return false;
    }

    public abstract boolean sameAs(Expr var1);

    public boolean is(Expr other) {
        if (!(other instanceof Expr)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (!(this instanceof Constant)) {
            return this == other;
        }
        Constant const1 = (Constant)this;
        Constant const2 = (Constant)other;
        switch (const1.type) {
            case 5: {
                String s1 = const1.stringValue();
                String s2 = const2.stringValue();
                return s1.equals(s2);
            }
            case 3: {
                return const1.intValue() == const2.intValue();
            }
            case 4: {
                return const1.realValue() == const2.realValue();
            }
            case 2: {
                return this == other;
            }
        }
        return true;
    }

    protected abstract Expr eval1(Env var1);

    public Expr eval(Env env) {
        if (this.isConstant()) {
            return this;
        }
        Expr e = this;
        HashSet<Expr> seen = new HashSet<Expr>();
        while (e.type < -2) {
            if (seen.contains(e)) {
                return CYCLIC_REF;
            }
            seen.add(e);
            e = e.eval1(env);
        }
        return e;
    }

    public Expr eval() {
        if (this.type == -3) {
            return Constant.undefined("attribute " + this + " not found");
        }
        if (this.isConstant()) {
            return this;
        }
        return this.eval(new Env());
    }

    public String toString() {
        return this.toString(new StringBuffer()).toString();
    }

    public abstract StringBuffer toString(StringBuffer var1);

    abstract int prec();

    public static void db(Object msg) {
        System.out.println(msg);
    }

    public static void db(boolean newline, Object msg) {
        if (newline) {
            System.out.println(msg);
        } else {
            System.out.print(msg);
        }
    }
}

