/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.AttrName;
import condor.classad.Builtin;
import condor.classad.Constant;
import condor.classad.Env;
import condor.classad.Expr;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FuncCall
extends Expr {
    private static String VERSION = "$Id: FuncCall.java,v 1.11 2005/05/06 20:54:07 solomon Exp $";
    private static Map functions = new HashMap();
    public final AttrName func;
    private int argc;
    private boolean strict;
    private Method method;
    private Constant unknownFunction = null;
    public final List args;
    private static final AttrName REL_TIME;
    private static final AttrName ABS_TIME;
    private static final AttrName REAL;
    static /* synthetic */ Class class$condor$classad$Expr;
    static /* synthetic */ Class class$condor$classad$Env;

    private FuncCall(AttrName func, List params) {
        super(-6);
        this.func = func;
        this.args = params;
        FunctionInfo info = (FunctionInfo)functions.get(func);
        if (info != null) {
            this.method = info.method;
            this.argc = info.argc;
            this.strict = info.strict;
            return;
        }
        this.unknownFunction = Constant.error("unknown function " + func);
    }

    public static Expr getInstance(AttrName func, List params) {
        if (params != null && params.size() == 1) {
            Expr arg = (Expr)params.get(0);
            if (arg.type == 5) {
                if (func.equals(REL_TIME)) {
                    return Builtin.relTime(arg);
                }
                if (func.equals(ABS_TIME)) {
                    return Constant.stringToAbsTime(arg.stringValue());
                }
            }
        }
        return new FuncCall(func, params);
    }

    public StringBuffer toString(StringBuffer sb) {
        sb.append(this.func).append("(");
        String comma = "";
        Iterator i = this.args.iterator();
        while (i.hasNext()) {
            Expr arg = (Expr)i.next();
            sb.append(comma);
            comma = ",";
            arg.toString(sb);
        }
        return sb.append(")");
    }

    public boolean sameAs(Expr other) {
        if (this.type != other.type) {
            return false;
        }
        FuncCall o = (FuncCall)other;
        if (!this.func.equals(o.func) || this.args.size() != o.args.size()) {
            return false;
        }
        Iterator i1 = this.args.iterator();
        Iterator i2 = o.args.iterator();
        while (i1.hasNext()) {
            Expr e2;
            Expr e1 = (Expr)i1.next();
            if (e1.sameAs(e2 = (Expr)i2.next())) continue;
            return false;
        }
        return true;
    }

    protected Expr eval1(Env env) {
        if (this.method == null) {
            return this.unknownFunction;
        }
        int nargs = this.args.size();
        if (this.argc >= 0 && this.argc != nargs) {
            return Constant.error("wrong number of args to " + this.func);
        }
        if (!this.strict) {
            try {
                int argp;
                Object[] inner;
                Object[] outer;
                if (this.argc < 0) {
                    outer = new Object[2];
                    outer[1] = inner = new Object[this.args.size()];
                    argp = 0;
                } else {
                    outer = new Object[this.args.size() + 1];
                    inner = outer;
                    argp = 1;
                }
                outer[0] = env;
                Iterator itr = this.args.iterator();
                while (itr.hasNext()) {
                    inner[argp++] = (Expr)itr.next();
                }
                return (Expr)this.method.invoke(null, outer);
            }
            catch (Exception e) {
                return Constant.error(this.func + ": " + e.getMessage());
            }
        }
        Expr errVal = null;
        Expr undefVal = null;
        Iterator itr = this.args.iterator();
        Expr[] inner = new Expr[nargs];
        Object[] outer = this.argc < 0 ? new Object[]{inner} : inner;
        for (int i = 0; i < nargs; ++i) {
            Expr arg = (Expr)itr.next();
            Expr argval = arg.eval(i < nargs - 1 ? new Env(env) : env);
            if (argval.type == 1 && errVal == null) {
                errVal = argval;
            }
            if (argval.type == 0 && undefVal == null) {
                undefVal = argval;
            }
            inner[i] = argval;
        }
        if (errVal != null) {
            return errVal;
        }
        if (undefVal != null) {
            return undefVal;
        }
        try {
            return (Expr)this.method.invoke(null, outer);
        }
        catch (Exception e) {
            return Constant.error(e.getMessage());
        }
    }

    public int prec() {
        return 12;
    }

    static boolean loadJavaLibrary(String className) {
        try {
            Method[] methods = Class.forName(className).getMethods();
            block3: for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!Modifier.isStatic(m.getModifiers()) || m.getReturnType() != (class$condor$classad$Expr == null ? FuncCall.class$("condor.classad.Expr") : class$condor$classad$Expr)) continue;
                Class<?>[] param = m.getParameterTypes();
                int argc = param.length;
                int argp = 0;
                boolean strict = true;
                if (argc > 0 && param[0] == (class$condor$classad$Env == null ? FuncCall.class$("condor.classad.Env") : class$condor$classad$Env)) {
                    strict = false;
                    ++argp;
                    --argc;
                }
                if (argp + 1 == param.length && param[argp].getComponentType() == (class$condor$classad$Expr == null ? FuncCall.class$("condor.classad.Expr") : class$condor$classad$Expr)) {
                    argc = -1;
                } else {
                    while (argp < param.length) {
                        if (param[argp] != (class$condor$classad$Expr == null ? FuncCall.class$("condor.classad.Expr") : class$condor$classad$Expr)) continue block3;
                        ++argp;
                    }
                }
                AttrName name = AttrName.fromString(m.getName());
                if (functions.containsKey(name)) {
                    FuncCall.db("warning: ignoring duplicate function " + name);
                    continue;
                }
                functions.put(name, new FunctionInfo(m, argc, strict));
            }
            return true;
        }
        catch (ExceptionInInitializerError e) {
            e.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (!FuncCall.loadJavaLibrary("condor.classad.Builtin")) {
            throw new RuntimeException("Cannot load the library condor.classad.Builtin");
        }
        REL_TIME = AttrName.fromString("relTime");
        ABS_TIME = AttrName.fromString("absTime");
        REAL = AttrName.fromString("real");
    }

    private static class FunctionInfo {
        public final Method method;
        public final int argc;
        public final boolean strict;

        public FunctionInfo(Method method, int argc, boolean strict) {
            this.method = method;
            this.argc = argc;
            this.strict = strict;
        }

        public String toString() {
            return "(" + this.method.getName() + "," + this.argc + "," + this.strict + ")";
        }
    }
}

