/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import java.util.StringTokenizer;

public class GetOpt {
    private static String VERSION = "$Id: GetOpt.java,v 1.12 2005/05/06 20:54:07 solomon Exp $";
    public static final int NO_ARG = 0;
    public static final int REQ_ARG = 1;
    public static final int OPT_ARG = 2;
    private String progname;
    private String[] argv;
    private String arg;
    private String shortopts;
    private LongOption[] longopts;
    private boolean longonly;
    public int optind = 0;
    private int nextchar = -1;
    public int longind;
    public String optarg;
    public boolean opterr = true;
    public char optopt = (char)63;

    public GetOpt(String progname, String[] argv, String shortopts, LongOption[] longopts, boolean longonly) {
        this.progname = progname;
        this.argv = argv;
        this.shortopts = shortopts;
        this.longopts = longopts;
        this.longonly = longonly;
    }

    public GetOpt(String progname, String[] argv, String shortopts) {
        this.progname = progname;
        this.argv = argv;
        this.shortopts = shortopts;
        this.longopts = null;
        this.longonly = false;
    }

    public GetOpt(String progname, String[] argv, String shortopts, LongOption[] longopts) {
        this.progname = progname;
        this.argv = argv;
        this.shortopts = shortopts;
        this.longopts = longopts;
        this.longonly = false;
    }

    public int nextOpt() {
        int c;
        int pos;
        this.optarg = null;
        if (this.nextchar < 0 || this.nextchar >= this.arg.length()) {
            if (this.optind >= this.argv.length) {
                return -1;
            }
            this.arg = this.argv[this.optind++];
            if (this.arg.equals("--")) {
                return -1;
            }
            if (this.arg.length() < 2 || this.arg.charAt(0) != '-') {
                --this.optind;
                return -1;
            }
            this.nextchar = 1;
            if (this.longopts != null && this.arg.charAt(1) == '-') {
                ++this.nextchar;
            }
        }
        if (this.longopts != null && (this.arg.charAt(1) == '-' || this.longonly && (this.arg.length() > 2 || this.shortopts.indexOf(this.arg.charAt(1)) == -1))) {
            boolean exact = false;
            boolean ambig = false;
            int indfound = -1;
            int eq = this.arg.indexOf(61, this.nextchar);
            String optGiven = eq == -1 ? this.arg.substring(this.nextchar) : this.arg.substring(this.nextchar, eq);
            String optWanted = null;
            for (int i = 0; i < this.longopts.length; ++i) {
                optWanted = this.longopts[i].name;
                if (!optWanted.startsWith(optGiven)) continue;
                if (optWanted.length() == optGiven.length()) {
                    indfound = i;
                    exact = true;
                    break;
                }
                if (indfound == -1) {
                    indfound = i;
                    continue;
                }
                ambig = true;
            }
            if (ambig && !exact) {
                this.printErr("option", optGiven, "is ambiguous");
                this.nextchar = -1;
                this.optopt = '\u0000';
                return 63;
            }
            if (indfound != -1) {
                int hasArg = this.longopts[indfound].hasArg;
                if (eq != -1) {
                    if (hasArg == 0) {
                        String bad = this.arg.charAt(1) == '-' ? "--" + optWanted : this.arg.charAt(0) + optWanted;
                        this.printErr("option", bad, "doesn't allow an argument");
                        this.nextchar = -1;
                        this.optopt = this.longopts[indfound].val;
                        return 63;
                    }
                    this.optarg = this.arg.substring(eq + 1);
                } else if (hasArg == 1) {
                    if (this.optind < this.argv.length) {
                        this.optarg = this.argv[this.optind++];
                    } else {
                        this.printErr("option", optGiven, "requires an argument");
                        this.nextchar = -1;
                        this.optopt = this.longopts[indfound].val;
                        return this.shortopts.charAt(0) == ':' ? 58 : 63;
                    }
                }
                this.nextchar = -1;
                this.longind = indfound;
                return this.longopts[indfound].val;
            }
            if (!this.longonly || this.arg.charAt(1) == '-' || this.shortopts.indexOf(this.arg.charAt(this.nextchar)) == -1) {
                String bad = this.arg.charAt(1) == '-' ? "--" + optGiven : this.argv[this.optind - 1].charAt(0) + optGiven;
                this.printErr("unrecognized option", bad, "");
                this.nextchar = -1;
                this.optopt = '\u0000';
                return 63;
            }
        }
        if ((pos = this.shortopts.indexOf(c = this.arg.charAt(this.nextchar++))) == -1 || c == 58) {
            if (this.opterr) {
                System.err.println(this.progname + ": illegal option -- " + (char)c);
            }
            this.optopt = c;
            return 63;
        }
        if (this.shortopts.length() > pos + 1 && this.shortopts.charAt(pos + 1) == ':') {
            if (this.shortopts.length() > pos + 2 && this.shortopts.charAt(pos + 2) == ':') {
                this.optarg = this.nextchar < this.arg.length() ? this.arg.substring(this.nextchar) : null;
            } else if (this.nextchar < this.arg.length()) {
                this.optarg = this.arg.substring(this.nextchar);
            } else if (this.optind >= this.argv.length) {
                if (this.opterr) {
                    System.err.println(this.progname + ": option requires an argument -- " + (char)c);
                }
                this.optopt = c;
                c = this.shortopts.charAt(0) == ':' ? 58 : 63;
            } else {
                this.optarg = this.argv[this.optind++];
            }
            this.nextchar = -1;
        }
        return c;
    }

    private void printErr(String a, String b, String c) {
        if (this.opterr) {
            System.err.println(this.progname + ": " + a + " `" + b + "' " + c);
        }
    }

    private static void pl(Object o) {
        System.err.println(o);
    }

    public static void main(String[] ignore) {
        int i;
        int c;
        GetOpt.pl("--------- Testing short options");
        String opts = "ab:c::";
        GetOpt.pl("shortopts = '" + opts + "'");
        String[] args = GetOpt.tokenize("-aabarg1 -b arg2 -carg3 -q -c one two");
        GetOpt opt = new GetOpt("GetOpt", args, opts);
        while ((c = opt.nextOpt()) != -1) {
            GetOpt.pl("option " + (char)(c == 63 ? (int)opt.optopt : c) + "(" + opt.optarg + ")");
        }
        GetOpt.pl("non-option args:");
        for (int i2 = opt.optind; i2 < args.length; ++i2) {
            GetOpt.pl("'" + args[i2] + "'");
        }
        GetOpt.pl("--------- Testing long options");
        GetOpt.pl("shortopts = '" + opts + "'");
        LongOption[] lopts = new LongOption[]{new LongOption("argless", 0, 'x'), new LongOption("hasarg", 1, 'y'), new LongOption("arg", 2, 'z')};
        GetOpt.pl("longopts =");
        for (i = 0; i < lopts.length; ++i) {
            GetOpt.pl("   " + lopts[i]);
        }
        args = GetOpt.tokenize("--argless --hasarg=arg1 --hasarg arg2 --arg --arg=arg3 --a --foobar --argless=bad one two");
        opt = new GetOpt("GetOpt", args, opts, lopts);
        while ((c = opt.nextOpt()) != -1) {
            GetOpt.pl("option " + (char)c + "[" + lopts[opt.longind].name + "]" + "(" + opt.optarg + ")");
        }
        GetOpt.pl("non-option args:");
        for (i = opt.optind; i < args.length; ++i) {
            GetOpt.pl("'" + args[i] + "'");
        }
    }

    private static String[] tokenize(String str) {
        StringTokenizer st = new StringTokenizer(str);
        String[] res = new String[st.countTokens()];
        System.err.print("argv = ");
        for (int i = 0; i < res.length; ++i) {
            res[i] = st.nextToken();
            System.err.print(" '" + res[i] + "'");
        }
        System.err.println();
        return res;
    }

    public static class LongOption {
        private static String VERSION = "$Id: GetOpt.java,v 1.12 2005/05/06 20:54:07 solomon Exp $";
        public String name;
        public int hasArg;
        public char val;

        public LongOption(String name, int hasArg, char val) {
            this.name = name;
            this.hasArg = hasArg;
            this.val = val;
        }

        public String toString() {
            return "{ \"" + this.name + "\", " + (this.hasArg == 0 ? "NO_ARG" : (this.hasArg == 1 ? "REQ_ARG" : (this.hasArg == 2 ? "OPT_ARG" : "" + this.hasArg))) + ", '" + this.val + "' }";
        }
    }
}

