/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.Constant;
import condor.classad.Env;
import condor.classad.Expr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListExpr
extends Expr {
    private static String VERSION = "$Id: ListExpr.java,v 1.21 2005/05/06 20:54:07 solomon Exp $";
    private final List contents;

    public int size() {
        return this.contents.size();
    }

    public ListExpr() {
        super(-2);
        this.contents = new ArrayList();
    }

    public ListExpr(List l) {
        super(-2);
        this.contents = l == null ? new ArrayList(0) : new ArrayList(l);
    }

    public Expr sub(int i) {
        try {
            return (Expr)this.contents.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            return Constant.error("subscript " + i + " is out of bounds");
        }
    }

    public Expr add(Expr e) {
        this.contents.add(e);
        return this;
    }

    public Iterator iterator() {
        return this.contents.iterator();
    }

    protected String typeName() {
        return "list";
    }

    protected Expr eval1(Env env) {
        return this;
    }

    public StringBuffer toString(StringBuffer sb) {
        int sep = 123;
        Iterator exprs = this.contents.iterator();
        while (exprs.hasNext()) {
            Expr expr = (Expr)exprs.next();
            expr.toString(sb.append((char)sep));
            sep = 44;
        }
        if (sep == 123) {
            sb.append((char)sep);
        }
        return sb.append('}');
    }

    public boolean sameAs(Expr other) {
        if (this.type != other.type) {
            return false;
        }
        ListExpr o = (ListExpr)other;
        if (this.contents.size() != o.contents.size()) {
            return false;
        }
        Iterator i = this.contents.iterator();
        Iterator j = o.contents.iterator();
        while (i.hasNext()) {
            Expr e2;
            Expr e1 = (Expr)i.next();
            if (e1.sameAs(e2 = (Expr)j.next())) continue;
            return false;
        }
        return true;
    }

    public int prec() {
        return 12;
    }
}

