/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.Constant;
import condor.classad.Env;
import condor.classad.Expr;
import java.util.Date;

public class Op
extends Expr {
    private static String VERSION = "$Id: Op.java,v 1.24 2005/05/06 20:54:07 solomon Exp $";
    public final int op;
    public final Expr arg1;
    public final Expr arg2;
    private static final char[] opType = new char[]{'s', 's', 'b', 'b', 'b', 'c', 'c', 'c', 'c', 'c', 'c', 'c', 'c', 'i', 'i', 'i', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'i', 'i'};
    private static final int[] precedence = new int[]{0, 1, 2, 3, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 10, 10};
    private static final Constant notError = Constant.error("!: argument must be boolean");
    private static final Constant andError = Constant.error("&&: argument must be boolean");
    private static final Constant orError = Constant.error("||: argument must be boolean");
    private static final Expr[] andTable = new Expr[]{Constant.FALSE, Constant.FALSE, Constant.FALSE, Constant.FALSE, Constant.FALSE, Constant.Undef, Constant.Undef, andError, Constant.FALSE, Constant.Undef, Constant.TRUE, andError, andError, andError, andError, andError};
    private static final Expr[] orTable = new Expr[]{Constant.FALSE, Constant.Undef, Constant.TRUE, Constant.FALSE, Constant.Undef, Constant.Undef, Constant.TRUE, orError, Constant.TRUE, Constant.TRUE, Constant.TRUE, Constant.TRUE, orError, orError, orError, orError};
    private static final Expr[] notTable = new Expr[]{Constant.TRUE, Constant.Undef, Constant.FALSE, notError};

    public Op(int op, Expr arg1, Expr arg2) {
        super(-7);
        this.op = op;
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    public Op(int op, Expr arg1) {
        super(-7);
        this.op = op;
        this.arg1 = arg1;
        this.arg2 = null;
    }

    public StringBuffer toString(StringBuffer sb) {
        sb.append('(');
        if (this.arg2 == null) {
            sb.append(opName[this.op]);
            this.arg1.toString(sb);
        } else {
            this.arg1.toString(sb);
            sb.append(opName[this.op]);
            this.arg2.toString(sb);
        }
        return sb.append(')');
    }

    public boolean sameAs(Expr other) {
        if (this.type != other.type) {
            return false;
        }
        Op o = (Op)other;
        if (this.op != o.op) {
            return false;
        }
        return this.arg1.sameAs(o.arg1) && (this.arg2 == null || this.arg2.sameAs(o.arg2));
    }

    public int prec() {
        return precedence[this.op];
    }

    private static final int classify(Expr val) {
        switch (val.type) {
            case 2: {
                return val.isTrue() ? 2 : 0;
            }
            case 0: {
                return 1;
            }
        }
        return 3;
    }

    /*
     * Unable to fully structure code
     */
    protected Expr eval1(Env env) {
        if (this.arg2 == null) {
            val1 = this.arg1.eval(env);
            val2 = null;
        } else {
            val1 = this.arg1.eval(new Env(env));
            val2 = this.arg2.eval(env);
        }
        env.clear();
        try {
            if (this.op == 7) {
                return val1.is(val2) != false ? Constant.TRUE : Constant.FALSE;
            }
            if (this.op == 8) {
                return val1.is(val2) != false ? Constant.FALSE : Constant.TRUE;
            }
            if (val1.type == 1) {
                return val1;
            }
            if (this.op == 1) {
                return Op.andTable[4 * Op.classify(val1) + Op.classify(val2)];
            }
            if (this.op == 0) {
                return Op.orTable[4 * Op.classify(val1) + Op.classify(val2)];
            }
            if (this.op == 24) {
                return Op.notTable[Op.classify(val1)];
            }
            if (!(val1 instanceof Constant)) {
                return Constant.error(Op.opName[this.op] + " applied to List or ClassAd");
            }
            const1 = (Constant)val1;
            if (const1.type == 0) {
                return const1;
            }
            switch (this.op) {
                case 21: {
                    switch (const1.type) {
                        case 3: 
                        case 4: 
                        case 6: 
                        case 7: {
                            return const1;
                        }
                    }
                    return Constant.error("Unary + of " + const1.typeName() + " value");
                }
                case 22: {
                    switch (const1.type) {
                        case 4: {
                            return Constant.getInstance(-const1.realValue());
                        }
                        case 3: {
                            return Constant.getInstance(-const1.intValue());
                        }
                        case 6: {
                            return Constant.getInstance(new Date(-const1.milliseconds()));
                        }
                        case 7: {
                            return Constant.getInstance(-const1.milliseconds());
                        }
                    }
                    return Constant.error("Unary - of " + const1.typeName() + " value");
                }
                case 23: {
                    if (const1.type == 3) {
                        return Constant.getInstance(~const1.intValue());
                    }
                    return Constant.error("Unary ~ of " + const1.typeName() + " value");
                }
                case 24: {
                    if (const1.type == 2) {
                        return const1.isTrue() != false ? Constant.FALSE : Constant.TRUE;
                    }
                    return Constant.error("Unary ! of " + const1.typeName() + " value");
                }
            }
            if (!(val2 instanceof Constant)) {
                return Constant.error(Op.opName[this.op] + " applied to List or ClassAd");
            }
            const2 = (Constant)val2;
            if (const2.type == 0 || const2.type == 1) {
                return const2;
            }
            switch (Op.opType[this.op]) {
                case 'b': {
                    if (const1.type != 3) ** GOTO lbl69
                    liv = const1.intValue();
                    riv = const2.intValue();
                    switch (this.op) {
                        case 2: {
                            return Constant.getInstance(liv | riv);
                        }
                        case 3: {
                            return Constant.getInstance(liv ^ riv);
                        }
                        case 4: {
                            return Constant.getInstance(liv & riv);
                        }
                    }
                    ** GOTO lbl80
lbl69:
                    // 1 sources

                    if (const1.type != 2 || const1.type != 2) {
                        return Constant.error("type error: " + const1.typeName() + Op.opName[this.op] + const2.typeName());
                    }
                    liv = (int)const1.isTrue();
                    riv = (int)const2.isTrue();
                    switch (this.op) {
                        case 2: {
                            return Constant.bool((boolean)(liv | riv));
                        }
                        case 3: {
                            return Constant.bool((boolean)(liv ^ riv));
                        }
                        case 4: {
                            return Constant.bool((boolean)(liv & riv));
                        }
                    }
                }
lbl80:
                // 3 sources

                case 'i': {
                    liv = const1.intValue();
                    riv = const2.intValue();
                    switch (this.op) {
                        case 2: {
                            return Constant.getInstance(liv | riv);
                        }
                        case 3: {
                            return Constant.getInstance(liv ^ riv);
                        }
                        case 4: {
                            return Constant.getInstance(liv & riv);
                        }
                        case 13: {
                            return Constant.getInstance(liv << riv);
                        }
                        case 14: {
                            return Constant.getInstance(liv >> riv);
                        }
                        case 15: {
                            return Constant.getInstance(liv >>> riv);
                        }
                    }
                    throw new RuntimeException("unknown integer operator " + Op.opName[this.op]);
                }
                case 'n': {
                    if (const1.type == 6) {
                        ms1 = const1.milliseconds();
                        ms2 = const2.milliseconds();
                        if (const2.type == 6) {
                            if (this.op != 17) {
                                return Constant.error("type error: " + const1.typeName() + Op.opName[this.op] + const2.typeName());
                            }
                            return Constant.getInstance(ms1 - ms2);
                        }
                        switch (this.op) {
                            case 17: {
                                return Constant.getInstance(new Date(ms1 - ms2));
                            }
                            case 16: {
                                return Constant.getInstance(new Date(ms1 + ms2));
                            }
                        }
                        return Constant.error("type error: " + const1.typeName() + Op.opName[this.op] + const2.typeName());
                    }
                    if (const1.type == 7) {
                        ms1 = const1.milliseconds();
                        ms2 = const2.milliseconds();
                        if (const2.type == 6) {
                            if (this.op != 16) {
                                return Constant.error("type error: " + const1.typeName() + Op.opName[this.op] + const2.typeName());
                            }
                            return Constant.getInstance(ms1 + ms2);
                        }
                        switch (this.op) {
                            case 17: {
                                return Constant.getInstance(ms1 - ms2);
                            }
                            case 16: {
                                return Constant.getInstance(ms1 + ms2);
                            }
                        }
                        return Constant.error("type error: " + const1.typeName() + Op.opName[this.op] + const2.typeName());
                    }
                    if (const1.type == 3 && const2.type == 3) {
                        liv = const1.intValue();
                        riv = const2.intValue();
                        switch (this.op) {
                            case 16: {
                                return Constant.getInstance(liv + riv);
                            }
                            case 17: {
                                return Constant.getInstance(liv - riv);
                            }
                            case 18: {
                                return Constant.getInstance(liv * riv);
                            }
                            case 19: {
                                return Constant.getInstance(liv / riv);
                            }
                            case 20: {
                                return Constant.getInstance(liv % riv);
                            }
                        }
                        throw new RuntimeException("unknown numeric operator " + Op.opName[this.op]);
                    }
                    lrv = const1.realValue();
                    rrv = const2.realValue();
                    switch (this.op) {
                        case 16: {
                            return Constant.getInstance(lrv + rrv);
                        }
                        case 17: {
                            return Constant.getInstance(lrv - rrv);
                        }
                        case 18: {
                            return Constant.getInstance(lrv * rrv);
                        }
                        case 19: {
                            return Constant.getInstance(lrv / rrv);
                        }
                        case 20: {
                            return Constant.getInstance(lrv % rrv);
                        }
                    }
                    throw new RuntimeException("unknown numeric operator " + Op.opName[this.op]);
                }
                case 'c': {
                    switch (const1.type) {
                        case 3: {
                            v1 = const1.intValue();
                            if (const2.type == 3) {
                                v2 = const2.intValue();
                                cmp = v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
                                break;
                            }
                            v2 = const2.realValue();
                            cmp = (double)v1 < v2 ? -1 : ((double)v1 == v2 ? 0 : 1);
                            break;
                        }
                        case 4: {
                            v1 = const1.realValue();
                            v2 = const2.realValue();
                            cmp = v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
                            break;
                        }
                        case 2: {
                            if (const2.type != 2 || this.op != 5 && this.op != 6) {
                                throw new ArithmeticException("attempt to compare " + const1.typeName() + " " + Op.opName[this.op] + " " + const2.typeName());
                            }
                            cmp = const1 == const2 ? 0 : 1;
                            break;
                        }
                        case 5: {
                            v1 = const1.stringValue();
                            v2 = const2.stringValue();
                            cmp = v1.compareToIgnoreCase(v2);
                            break;
                        }
                        case 6: 
                        case 7: {
                            if (const1.type != const2.type) {
                                return Constant.error("type error: " + const1.typeName() + Op.opName[this.op] + const2.typeName());
                            }
                            v1 = const1.milliseconds();
                            cmp = v1 < (v2 = const2.milliseconds()) ? -1 : (v1 == v2 ? 0 : 1);
                            break;
                        }
                        default: {
                            throw new ArithmeticException("attempt to compare " + const1.typeName() + " " + Op.opName[this.op] + " " + const2.typeName());
                        }
                    }
                    switch (this.op) {
                        case 5: {
                            return Constant.bool(var6_12 == false);
                        }
                        case 6: {
                            return Constant.bool(var6_12 != false);
                        }
                        case 9: {
                            return Constant.bool(var6_12 < 0);
                        }
                        case 10: {
                            return Constant.bool(var6_12 > 0);
                        }
                        case 11: {
                            return Constant.bool(var6_12 <= 0);
                        }
                        case 12: {
                            return Constant.bool(var6_12 >= 0);
                        }
                    }
                    throw new RuntimeException("unknown comparison operator " + Op.opName[this.op]);
                }
            }
            throw new RuntimeException("unknown operator " + Op.opName[this.op] + " of type " + Op.opType[this.op]);
        }
        catch (ArithmeticException ex) {
            return Constant.error(ex.getMessage());
        }
    }
}

