/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.AttrName;
import condor.classad.AttrRef;
import condor.classad.CondExpr;
import condor.classad.Constant;
import condor.classad.Expr;
import condor.classad.FuncCall;
import condor.classad.ListExpr;
import condor.classad.Op;
import condor.classad.RecordExpr;
import condor.classad.SelectExpr;
import condor.classad.SubscriptExpr;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

class Parser {
    public static final short ERROR = 257;
    public static final short FALSE = 258;
    public static final short IDENTIFIER = 259;
    public static final short INTEGER = 260;
    public static final short LEX_ERROR = 261;
    public static final short REAL = 262;
    public static final short STRING = 263;
    public static final short TRUE = 264;
    public static final short UNDEFINED = 265;
    public static final short OP_LOR = 266;
    public static final short OP_LAND = 267;
    public static final short OP_EQ = 268;
    public static final short OP_NE = 269;
    public static final short OP_IS = 270;
    public static final short OP_ISNT = 271;
    public static final short OP_LE = 272;
    public static final short OP_GE = 273;
    public static final short OP_SHL = 274;
    public static final short OP_SHR = 275;
    public static final short OP_SHRR = 276;
    public static final short UNARY = 277;
    private static final short ERROR_TOKEN = 256;
    private static final short[] lhs = new short[]{-1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 4, 4, 4, 8, 8, 13, 13, 9, 9, 7, 7, 14, 14, 10, 10, 6, 6, 5, 5, 5, 5, 5, 5, 5, 12, 12, 11};
    private static final short[] len = new short[]{2, 1, 5, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 2, 2, 2, 2, 1, 3, 4, 1, 1, 1, 1, 1, 3, 3, 2, 1, 2, 1, 3, 3, 2, 1, 2, 3, 5, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1};
    private static final short[] defred = new short[]{0, 59, 57, 62, 55, 53, 60, 56, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 30, 34, 37, 36, 35, 0, 0, 26, 27, 28, 29, 47, 0, 0, 0, 46, 0, 41, 0, 43, 0, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 48, 0, 45, 0, 38, 42, 0, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 22, 23, 0, 31, 0, 52, 0, 0, 49, 44, 0, 32, 51, 0, 0, 2, 50};
    private static final short[] dgoto = new short[]{39, 17, 18, 19, 20, 21, 22, 23, 24, 40, 33, 25, 26, 41, 35};
    private static final short[] sindex = new short[]{991, 0, 0, 0, 0, 0, 0, 0, 0, 991, 991, 991, 991, -59, 991, 923, 0, 804, 0, -38, 0, 0, 0, 0, 0, -36, -258, 0, 0, 0, 0, 0, -84, -44, -51, 0, -21, 0, -108, 0, -42, 0, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, -237, 991, 932, 0, 0, -90, 0, 991, 0, 0, 941, 0, 737, 837, 882, -31, 679, -10, -10, -10, -10, 60, 60, 60, 60, -24, -24, -24, 20, 20, 0, 0, 0, -34, 0, -67, 0, 10, -25, 0, 0, 991, 0, 0, 991, 991, 0, 0};
    private static final short[] rindex = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 494, 0, 96, 0, 0, 0, 0, 0, 1, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 440, 448, 777, 567, 729, 542, 624, 640, 669, 376, 384, 488, 534, 192, 249, 288, 123, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final short[] gindex = new short[]{41, 1041, 68, 0, 0, 0, 0, 0, 0, -26, 0, 12, 0, 16, -3};
    private static final short[] table = new short[]{32, 33, 74, 68, 66, 67, 62, 46, 64, 68, 71, 60, 58, 62, 59, 69, 61, 73, 60, 58, 72, 59, 3, 61, 105, 34, 106, 62, 54, 51, 70, 52, 60, 58, 31, 59, 109, 61, 33, 33, 101, 16, 33, 33, 33, 33, 33, 33, 33, 31, 51, 107, 52, 65, 108, 36, 75, 62, 0, 33, 33, 33, 60, 33, 33, 54, 54, 61, 0, 54, 54, 54, 54, 54, 54, 54, 98, 27, 28, 29, 30, 102, 0, 37, 0, 0, 54, 54, 54, 0, 54, 54, 33, 0, 33, 33, 25, 62, 0, 0, 0, 0, 60, 58, 97, 59, 99, 61, 0, 0, 0, 0, 103, 0, 0, 104, 0, 0, 0, 54, 0, 54, 54, 19, 0, 33, 33, 0, 0, 0, 0, 0, 0, 25, 25, 20, 0, 25, 25, 25, 25, 25, 0, 25, 0, 0, 110, 0, 0, 104, 111, 0, 54, 54, 25, 25, 25, 0, 25, 25, 0, 19, 0, 0, 19, 0, 19, 19, 19, 3, 0, 0, 0, 20, 0, 0, 20, 0, 20, 20, 20, 19, 19, 19, 0, 19, 19, 0, 0, 25, 25, 0, 16, 20, 20, 20, 0, 20, 20, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 19, 0, 0, 25, 25, 0, 0, 0, 0, 0, 0, 20, 20, 16, 0, 0, 16, 0, 0, 16, 47, 48, 49, 50, 53, 54, 55, 56, 57, 0, 19, 19, 17, 16, 16, 16, 0, 16, 16, 0, 0, 0, 20, 20, 0, 53, 54, 55, 56, 57, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 0, 0, 0, 0, 0, 0, 0, 16, 16, 17, 18, 0, 17, 0, 0, 17, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 0, 0, 17, 17, 17, 0, 17, 17, 0, 0, 0, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 18, 0, 0, 18, 0, 55, 56, 57, 0, 0, 0, 0, 0, 17, 17, 0, 0, 18, 18, 18, 0, 18, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 17, 17, 0, 12, 0, 0, 0, 0, 18, 18, 0, 13, 0, 0, 0, 0, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 0, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 18, 18, 12, 0, 0, 12, 0, 0, 12, 0, 13, 0, 0, 13, 0, 0, 13, 0, 0, 0, 0, 0, 12, 12, 12, 0, 12, 12, 3, 0, 13, 13, 13, 0, 13, 13, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 12, 12, 0, 0, 0, 0, 0, 0, 13, 13, 0, 0, 3, 0, 0, 3, 0, 0, 0, 14, 4, 0, 0, 4, 0, 1, 0, 0, 0, 3, 3, 12, 12, 0, 3, 0, 0, 4, 4, 13, 13, 0, 4, 0, 0, 0, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 14, 0, 0, 14, 0, 0, 14, 3, 15, 1, 0, 0, 1, 0, 0, 4, 8, 0, 0, 0, 14, 14, 14, 0, 14, 14, 1, 1, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 3, 0, 6, 0, 0, 0, 0, 15, 4, 0, 15, 0, 0, 15, 0, 8, 14, 14, 8, 0, 0, 8, 1, 0, 0, 0, 0, 15, 15, 15, 0, 15, 15, 0, 0, 8, 8, 0, 0, 0, 8, 0, 0, 6, 0, 0, 6, 14, 14, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 9, 6, 6, 15, 15, 0, 6, 0, 0, 0, 0, 8, 8, 0, 0, 0, 10, 0, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 15, 15, 6, 6, 9, 0, 0, 9, 8, 8, 9, 11, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 10, 9, 9, 10, 0, 0, 9, 0, 0, 0, 6, 6, 0, 0, 0, 0, 0, 10, 10, 0, 0, 0, 10, 0, 0, 3, 11, 0, 0, 11, 0, 0, 11, 4, 4, 62, 9, 9, 0, 0, 60, 58, 0, 59, 0, 61, 11, 11, 7, 0, 0, 11, 10, 10, 0, 0, 0, 0, 51, 0, 52, 0, 0, 0, 0, 0, 0, 9, 9, 0, 0, 0, 0, 14, 14, 14, 14, 14, 14, 14, 14, 11, 11, 10, 10, 0, 7, 0, 0, 7, 0, 0, 7, 62, 46, 0, 5, 0, 60, 58, 0, 59, 0, 61, 0, 0, 7, 7, 0, 0, 0, 7, 11, 11, 0, 0, 51, 0, 52, 15, 15, 15, 15, 15, 15, 15, 15, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 5, 0, 0, 5, 7, 7, 0, 0, 0, 0, 0, 0, 0, 45, 0, 6, 6, 5, 5, 0, 0, 0, 5, 62, 46, 0, 0, 0, 60, 58, 0, 59, 0, 61, 0, 7, 7, 0, 0, 0, 0, 0, 0, 44, 0, 0, 51, 0, 52, 63, 0, 0, 5, 0, 0, 0, 62, 46, 0, 0, 0, 60, 58, 0, 59, 0, 61, 0, 0, 0, 0, 0, 9, 9, 9, 9, 9, 9, 0, 51, 45, 52, 0, 5, 5, 0, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 0, 0, 0, 0, 0, 62, 46, 0, 0, 0, 60, 58, 0, 59, 44, 61, 0, 45, 0, 0, 0, 11, 11, 11, 11, 11, 11, 0, 51, 0, 52, 0, 0, 47, 48, 49, 50, 53, 54, 55, 56, 57, 11, 0, 0, 0, 0, 44, 0, 14, 0, 11, 9, 38, 10, 0, 0, 0, 14, 100, 11, 9, 45, 10, 0, 0, 0, 14, 0, 0, 9, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 0, 0, 0, 0, 0, 43, 47, 48, 49, 50, 53, 54, 55, 56, 57, 13, 0, 0, 0, 0, 0, 0, 0, 0, 13, 11, 0, 0, 0, 0, 0, 0, 14, 13, 0, 9, 0, 10, 0, 0, 0, 0, 0, 0, 5, 5, 0, 15, 0, 37, 12, 0, 0, 0, 0, 0, 15, 0, 0, 12, 0, 0, 0, 0, 0, 15, 0, 73, 12, 0, 0, 42, 43, 47, 48, 49, 50, 53, 54, 55, 56, 57, 0, 13, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 0, 47, 48, 49, 50, 53, 54, 55, 56, 57, 15, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 48, 49, 50, 53, 54, 55, 56, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 0, 5, 6, 7, 8, 1, 2, 3, 4, 0, 5, 6, 7, 8, 1, 2, 3, 4, 0, 5, 6, 7, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 0, 5, 6, 7, 8};
    private static final short[] check = new short[]{59, 0, 44, 93, 40, 263, 37, 38, 46, 93, 61, 42, 43, 37, 45, 59, 47, 125, 42, 43, 41, 45, 259, 47, 58, 13, 93, 37, 0, 60, 33, 62, 42, 43, 93, 45, 61, 47, 37, 38, 66, 0, 41, 42, 43, 44, 45, 46, 47, 93, 60, 41, 62, 91, 44, 14, 40, 37, -1, 58, 59, 60, 42, 62, 63, 37, 38, 47, -1, 41, 42, 43, 44, 45, 46, 47, 64, 9, 10, 11, 12, 69, -1, 125, -1, -1, 58, 59, 60, -1, 62, 63, 91, -1, 93, 94, 0, 37, -1, -1, -1, -1, 42, 43, 63, 45, 65, 47, -1, -1, -1, -1, 71, -1, -1, 74, -1, -1, -1, 91, -1, 93, 94, 0, -1, 124, 125, -1, -1, -1, -1, -1, -1, 37, 38, 0, -1, 41, 42, 43, 44, 45, -1, 47, -1, -1, 105, -1, -1, 108, 109, -1, 124, 125, 58, 59, 60, -1, 62, 63, -1, 38, -1, -1, 41, -1, 43, 44, 45, 259, -1, -1, -1, 38, -1, -1, 41, -1, 43, 44, 45, 58, 59, 60, -1, 62, 63, -1, -1, 93, 94, -1, 0, 58, 59, 60, -1, 62, 63, -1, 259, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 93, 94, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, 93, 94, 38, -1, -1, 41, -1, -1, 44, 268, 269, 270, 271, 272, 273, 274, 275, 276, -1, 124, 125, 0, 58, 59, 60, -1, 62, 63, -1, -1, -1, 124, 125, -1, 272, 273, 274, 275, 276, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, -1, -1, -1, -1, -1, -1, -1, 93, 94, 38, 0, -1, 41, -1, -1, 44, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, -1, -1, -1, 38, -1, -1, 41, -1, -1, 44, -1, 274, 275, 276, -1, -1, -1, -1, -1, 93, 94, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 124, 125, -1, 0, -1, -1, -1, -1, 93, 94, -1, 0, -1, -1, -1, -1, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, -1, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 124, 125, 38, -1, -1, 41, -1, -1, 44, -1, 38, -1, -1, 41, -1, -1, 44, -1, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, 0, -1, 58, 59, 60, -1, 62, 63, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 93, 94, -1, -1, -1, -1, -1, -1, 93, 94, -1, -1, 41, -1, -1, 44, -1, -1, -1, 0, 41, -1, -1, 44, -1, 0, -1, -1, -1, 58, 59, 124, 125, -1, 63, -1, -1, 58, 59, 124, 125, -1, 63, -1, -1, -1, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 38, -1, -1, 41, -1, -1, 44, 93, 0, 41, -1, -1, 44, -1, -1, 93, 0, -1, -1, -1, 58, 59, 60, -1, 62, 63, 58, 59, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 125, -1, 0, -1, -1, -1, -1, 38, 125, -1, 41, -1, -1, 44, -1, 38, 93, 94, 41, -1, -1, 44, 93, -1, -1, -1, -1, 58, 59, 60, -1, 62, 63, -1, -1, 58, 59, -1, -1, -1, 63, -1, -1, 41, -1, -1, 44, 124, 125, -1, -1, -1, -1, -1, 125, -1, -1, -1, -1, 0, 58, 59, 93, 94, -1, 63, -1, -1, -1, -1, 93, 94, -1, -1, -1, 0, -1, 266, 267, 268, 269, 270, 271, 272, 273, 266, 267, 268, 269, 270, 271, 272, 273, 124, 125, 93, 94, 38, -1, -1, 41, 124, 125, 44, 0, -1, -1, -1, -1, -1, -1, -1, -1, 38, -1, -1, 41, 58, 59, 44, -1, -1, 63, -1, -1, -1, 124, 125, -1, -1, -1, -1, -1, 58, 59, -1, -1, -1, 63, -1, -1, 266, 38, -1, -1, 41, -1, -1, 44, 266, 267, 37, 93, 94, -1, -1, 42, 43, -1, 45, -1, 47, 58, 59, 0, -1, -1, 63, 93, 94, -1, -1, -1, -1, 60, -1, 62, -1, -1, -1, -1, -1, -1, 124, 125, -1, -1, -1, -1, 266, 267, 268, 269, 270, 271, 272, 273, 93, 94, 124, 125, -1, 38, -1, -1, 41, -1, -1, 44, 37, 38, -1, 0, -1, 42, 43, -1, 45, -1, 47, -1, -1, 58, 59, -1, -1, -1, 63, 124, 125, -1, -1, 60, -1, 62, 266, 267, 268, 269, 270, 271, 272, 273, 266, 267, 268, 269, 270, 271, -1, -1, -1, -1, 41, -1, -1, 44, 93, 94, -1, -1, -1, -1, -1, -1, -1, 94, -1, 266, 267, 58, 59, -1, -1, -1, 63, 37, 38, -1, -1, -1, 42, 43, -1, 45, -1, 47, -1, 124, 125, -1, -1, -1, -1, -1, -1, 124, -1, -1, 60, -1, 62, 63, -1, -1, 93, -1, -1, -1, 37, 38, -1, -1, -1, 42, 43, -1, 45, -1, 47, -1, -1, -1, -1, -1, 266, 267, 268, 269, 270, 271, -1, 60, 94, 62, -1, 124, 125, -1, -1, -1, 266, 267, 268, 269, 270, 271, -1, -1, -1, -1, -1, -1, -1, 37, 38, -1, -1, -1, 42, 43, -1, 45, 124, 47, -1, 94, -1, -1, -1, 266, 267, 268, 269, 270, 271, -1, 60, -1, 62, -1, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, 33, -1, -1, -1, -1, 124, -1, 40, -1, 33, 43, 44, 45, -1, -1, -1, 40, 41, 33, 43, 94, 45, -1, -1, -1, 40, -1, -1, 43, -1, 45, -1, -1, -1, -1, -1, -1, -1, -1, 266, 267, -1, -1, -1, -1, -1, -1, -1, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 91, -1, -1, -1, -1, -1, -1, -1, -1, 91, 33, -1, -1, -1, -1, -1, -1, 40, 91, -1, 43, -1, 45, -1, -1, -1, -1, -1, -1, 266, 267, -1, 123, -1, 125, 126, -1, -1, -1, -1, -1, 123, -1, -1, 126, -1, -1, -1, -1, -1, 123, -1, 125, 126, -1, -1, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, -1, 91, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, 123, -1, -1, 126, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 268, 269, 270, 271, 272, 273, 274, 275, 276, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, 260, -1, 262, 263, 264, 265, 257, 258, 259, 260, -1, 262, 263, 264, 265, 257, 258, 259, 260, -1, 262, 263, 264, 265, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, 259, 260, -1, 262, 263, 264, 265};
    private static final short FINAL_STATE = 16;
    private static final String[] name = new String[]{"end-of-file", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "'!'", null, null, null, "'%'", "'&'", null, "'('", "')'", "'*'", "'+'", "','", "'-'", "'.'", "'/'", null, null, null, null, null, null, null, null, null, null, "':'", "';'", "'<'", "'='", "'>'", "'?'", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "'['", null, "']'", "'^'", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "'{'", "'|'", "'}'", "'~'", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "ERROR", "FALSE", "IDENTIFIER", "INTEGER", "LEX_ERROR", "REAL", "STRING", "TRUE", "UNDEFINED", "OP_LOR", "OP_LAND", "OP_EQ", "OP_NE", "OP_IS", "OP_ISNT", "OP_LE", "OP_GE", "OP_SHL", "OP_SHR", "OP_SHRR", "UNARY"};
    private static final String[] rule = new String[]{"$accept : Expression", "Expression : Expr", "Expression : Expr '?' Expression ':' Expression", "Expr : Expr OP_LOR Expr", "Expr : Expr OP_LAND Expr", "Expr : Expr '|' Expr", "Expr : Expr '^' Expr", "Expr : Expr '&' Expr", "Expr : Expr OP_EQ Expr", "Expr : Expr OP_NE Expr", "Expr : Expr OP_IS Expr", "Expr : Expr OP_ISNT Expr", "Expr : Expr '<' Expr", "Expr : Expr '>' Expr", "Expr : Expr OP_LE Expr", "Expr : Expr OP_GE Expr", "Expr : Expr OP_SHL Expr", "Expr : Expr OP_SHR Expr", "Expr : Expr OP_SHRR Expr", "Expr : Expr '+' Expr", "Expr : Expr '-' Expr", "Expr : Expr '*' Expr", "Expr : Expr '/' Expr", "Expr : Expr '%' Expr", "Expr : PrefixExpr", "PrefixExpr : SuffixExpr", "PrefixExpr : '+' PrefixExpr", "PrefixExpr : '-' PrefixExpr", "PrefixExpr : '!' PrefixExpr", "PrefixExpr : '~' PrefixExpr", "SuffixExpr : Atom", "SuffixExpr : SuffixExpr '.' Identifier", "SuffixExpr : SuffixExpr '[' Expression ']'", "Atom : Identifier", "Atom : Literal", "Atom : List", "Atom : Record", "Atom : Call", "Atom : '(' Expression ')'", "List : '{' ListBody ListEnd", "List : '{' ListEnd", "ListEnd : '}'", "ListEnd : ',' '}'", "ListBody : Expression", "ListBody : ListBody ',' Expression", "Record : '[' DefinitionList RecordEnd", "Record : '[' RecordEnd", "RecordEnd : ']'", "RecordEnd : ';' ']'", "DefinitionList : Identifier '=' Expression", "DefinitionList : DefinitionList ';' Identifier '=' Expression", "Call : Identifier '(' ListBody ')'", "Call : Identifier '(' ')'", "Literal : REAL", "Literal : Strings", "Literal : INTEGER", "Literal : TRUE", "Literal : FALSE", "Literal : UNDEFINED", "Literal : ERROR", "Strings : STRING", "Strings : Strings STRING", "Identifier : IDENTIFIER"};
    private static final String[] ntname = new String[]{"Expression", "Expr", "PrefixExpr", "SuffixExpr", "Atom", "Literal", "Call", "Record", "List", "ListBody", "DefinitionList", "Identifier", "Strings", "ListEnd", "RecordEnd"};
    boolean tracing = false;
    boolean acceptPrefix = false;
    private int errorLookahead;
    private int lookahead = -1;
    private int state;
    private static final int STACKSIZE = 500;
    private int[] stateStack = new int[500];
    private Object[] valStack = new Object[500];
    private int stackTop = -1;
    private Object val;
    private Object lval;
    private static String VERSION = "$Id: Parser.java,v 1.10 2005/10/01 11:33:59 solomon Exp $";
    int verbosity = 3;
    PrintStream errs = System.err;
    private LineNumberReader reader;
    private String lineStr;
    private char[] line = new char[100];
    private int lineLen;
    private int pos;
    private int tokenStart;
    private int curChar;
    private static final String[] reserved = new String[]{null, "error", "false", "is", "isnt", "parent", "true", "undefined"};
    private static final int[] reservedCode = new int[]{0, 257, 258, 270, 271, -1, 264, 265};
    private static char[] match;
    private static int[] accept;
    private static int[] alt;
    private static int[] trieStart;
    private static final int[] tolower;

    private void trace(Object msg) {
        if (this.tracing) {
            System.out.println(msg);
        }
    }

    private String showStack() {
        if (this.stackTop < 0) {
            return "EMPTY";
        }
        StringBuffer sb = new StringBuffer(Integer.toString(this.stateStack[0]));
        for (int i = 1; i <= this.stackTop; ++i) {
            sb.append(" " + this.stateStack[i]);
        }
        return sb.toString();
    }

    private String tokenName(int token) {
        if (token == 256) {
            return "$error$";
        }
        if (token < 0 || token >= name.length) {
            return "<unknown_token>";
        }
        if (name[token] != null) {
            return name[token];
        }
        if (token > 32 && token < 127) {
            return "'" + (char)token + "'";
        }
        return "<unknown_token>";
    }

    private int[] validTokens(int state) {
        int count = 0;
        for (int token = 0; token <= name.length; ++token) {
            if (token == 256 || Parser.tableLookup(sindex, state, token) < 0 && Parser.tableLookup(rindex, state, token) < 0) continue;
            ++count;
        }
        int[] result = new int[count];
        int i = 0;
        for (int token = 0; token <= name.length; ++token) {
            if (token == 256 || Parser.tableLookup(sindex, state, token) < 0 && Parser.tableLookup(rindex, state, token) < 0) continue;
            result[i++] = token;
        }
        return result;
    }

    private static final int tableLookup(short[] start, int row, int column) {
        int offset = start[row];
        if (offset == 0) {
            return -1;
        }
        if ((offset += column) < 0) {
            return -1;
        }
        if (offset >= check.length) {
            return -1;
        }
        if (check[offset] != column) {
            return -1;
        }
        return table[offset];
    }

    public Object parse(boolean acceptPrefix) {
        this.acceptPrefix = acceptPrefix;
        this.errorLookahead = 0;
        this.stackTop = 0;
        this.state = 0;
        this.stateStack[this.stackTop] = 0;
        block0: while (true) {
            int prod;
            if ((prod = defred[this.state]) != 0) {
                if (this.tracing) {
                    this.trace("Stack " + this.showStack() + " default action is reduce by " + prod);
                }
            } else {
                int nextState;
                if (this.lookahead < 0) {
                    this.lookahead = this.lex();
                }
                if (this.state == 0 && this.lookahead == 0) {
                    if (this.tracing) {
                        this.trace("Null input");
                    }
                    return null;
                }
                if (this.tracing) {
                    this.trace("Stack " + this.showStack() + " token " + this.lookahead + " (" + this.tokenName(this.lookahead) + ")");
                }
                if ((nextState = Parser.tableLookup(sindex, this.state, this.lookahead)) >= 0) {
                    this.state = nextState;
                    this.stateStack[++this.stackTop] = this.state;
                    this.valStack[this.stackTop] = this.lval;
                    this.lookahead = -1;
                    if (this.tracing) {
                        this.trace("shift to stack " + this.showStack());
                    }
                    if (this.errorLookahead > 0) {
                        --this.errorLookahead;
                    }
                    prod = -1;
                } else {
                    prod = Parser.tableLookup(rindex, this.state, this.lookahead);
                    if (prod <= 0) {
                        if (acceptPrefix) {
                            while (true) {
                                if (this.tracing) {
                                    this.trace("Stack " + this.showStack() + ": pretend lookhead EOF");
                                }
                                if ((prod = defred[this.state]) != 0) {
                                    if (this.tracing) {
                                        this.trace("Default action is reduce by " + prod);
                                    }
                                } else {
                                    prod = Parser.tableLookup(rindex, this.state, 0);
                                    if (this.tracing) {
                                        this.trace("Reduce by " + prod + " at EOF");
                                    }
                                }
                                if (prod <= 0) break;
                                this.reduceBy(prod);
                            }
                        }
                        if (this.state == 16 && (acceptPrefix || this.lookahead == 0)) {
                            if (this.tracing) {
                                this.trace("Prefix matches");
                            }
                            return this.val;
                        }
                        if (this.errorLookahead == 0) {
                            this.error("syntax error");
                        }
                        if (this.errorLookahead < 3) {
                            this.errorLookahead = 3;
                            while (true) {
                                if (this.stackTop < 0) {
                                    if (this.tracing) {
                                        this.trace("Recovery deletes all left context");
                                    }
                                    return null;
                                }
                                nextState = Parser.tableLookup(sindex, this.stateStack[this.stackTop], 256);
                                if (nextState >= 0) {
                                    if (this.tracing) {
                                        this.trace("Stack " + this.showStack() + ", error recovery shifting to state " + nextState);
                                    }
                                    this.state = nextState;
                                    this.stateStack[++this.stackTop] = this.state;
                                    this.valStack[this.stackTop] = this.lval;
                                    prod = -1;
                                    continue block0;
                                }
                                if (this.tracing) {
                                    this.trace("error recovery discarding state " + this.stateStack[this.stackTop]);
                                }
                                if (this.stackTop < 0) {
                                    if (this.tracing) {
                                        this.trace("Recovery deletes all left context");
                                    }
                                    return null;
                                }
                                --this.stackTop;
                            }
                        }
                        if (this.lookahead == 0) {
                            this.trace("Recovery hits EOF");
                            return null;
                        }
                        if (this.tracing) {
                            this.trace("Stack " + this.showStack() + ", error recovery discards token " + this.lookahead + "(" + this.tokenName(this.lookahead) + ")");
                        }
                        this.lookahead = -1;
                        continue;
                    }
                }
            }
            if (prod <= 0) continue;
            this.reduceBy(prod);
            if (this.state != 16 || this.lookahead >= 0) continue;
            this.lookahead = this.lex();
        }
    }

    public Object parse() {
        return this.parse(true);
    }

    public boolean enableTracing(boolean on) {
        boolean result = this.tracing;
        this.tracing = on;
        return result;
    }

    private void reduceBy(int prod) {
        if (this.tracing) {
            this.trace("reduce by production " + prod + " [" + rule[prod] + "]");
        }
        short rhsLength = len[prod];
        this.val = this.valStack[this.stackTop - rhsLength + 1];
        switch (prod) {
            case 2: {
                this.val = new CondExpr((Expr)this.valStack[this.stackTop - 4], (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 3: {
                this.val = new Op(0, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 4: {
                this.val = new Op(1, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 5: {
                this.val = new Op(2, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 6: {
                this.val = new Op(3, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 7: {
                this.val = new Op(4, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 8: {
                this.val = new Op(5, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 9: {
                this.val = new Op(6, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 10: {
                this.val = new Op(7, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 11: {
                this.val = new Op(8, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 12: {
                this.val = new Op(9, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 13: {
                this.val = new Op(10, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 14: {
                this.val = new Op(11, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 15: {
                this.val = new Op(12, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 16: {
                this.val = new Op(13, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 17: {
                this.val = new Op(14, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 18: {
                this.val = new Op(15, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 19: {
                this.val = new Op(16, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 20: {
                this.val = new Op(17, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 21: {
                this.val = new Op(18, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 22: {
                this.val = new Op(19, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 23: {
                this.val = new Op(20, (Expr)this.valStack[this.stackTop - 2], (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 26: {
                this.val = new Op(21, (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 27: {
                this.val = new Op(22, (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 28: {
                this.val = new Op(24, (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 29: {
                this.val = new Op(23, (Expr)this.valStack[this.stackTop - 0]);
                break;
            }
            case 31: {
                this.val = new SelectExpr((Expr)this.valStack[this.stackTop - 2], (AttrName)this.valStack[this.stackTop - 0]);
                break;
            }
            case 32: {
                this.val = new SubscriptExpr((Expr)this.valStack[this.stackTop - 3], (Expr)this.valStack[this.stackTop - 1]);
                break;
            }
            case 33: {
                this.val = new AttrRef((AttrName)this.valStack[this.stackTop - 0]);
                break;
            }
            case 35: {
                this.val = (ListExpr)this.valStack[this.stackTop - 0];
                break;
            }
            case 36: {
                this.val = (RecordExpr)this.valStack[this.stackTop - 0];
                break;
            }
            case 37: {
                this.val = (Expr)this.valStack[this.stackTop - 0];
                break;
            }
            case 38: {
                this.val = (Expr)this.valStack[this.stackTop - 1];
                break;
            }
            case 39: {
                this.val = new ListExpr((List)this.valStack[this.stackTop - 1]);
                break;
            }
            case 40: {
                this.val = new ListExpr(null);
                break;
            }
            case 43: {
                List<Expr> l = new ArrayList<Object>();
                l.add((Expr)this.valStack[this.stackTop - 0]);
                this.val = l;
                break;
            }
            case 44: {
                List<Expr> l = (List)this.valStack[this.stackTop - 2];
                l.add((Expr)this.valStack[this.stackTop - 0]);
                this.val = l;
                break;
            }
            case 45: {
                List<Expr> l = (List)this.valStack[this.stackTop - 1];
                RecordExpr r = new RecordExpr(l.size());
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    AttrName n = (AttrName)i.next();
                    if (n == AttrName.PARENT) {
                        this.error("Attribute name \"parent\" is reserved", false);
                        i.next();
                        continue;
                    }
                    Expr e = (Expr)i.next();
                    if (r.lookup(n) != null) {
                        this.error("Duplicate definition of attribute " + n + " in Record", false);
                        continue;
                    }
                    r.insertAttribute(n, e);
                }
                this.val = r;
                break;
            }
            case 46: {
                this.val = new RecordExpr();
                break;
            }
            case 49: {
                List<Expr> l = new ArrayList();
                l.add((Expr)((Object)((AttrName)this.valStack[this.stackTop - 2])));
                l.add((Expr)this.valStack[this.stackTop - 0]);
                this.val = l;
                break;
            }
            case 50: {
                List<Expr> l = (List)this.valStack[this.stackTop - 4];
                l.add((Expr)((Object)((AttrName)this.valStack[this.stackTop - 2])));
                l.add((Expr)this.valStack[this.stackTop - 0]);
                this.val = l;
                break;
            }
            case 51: {
                this.val = FuncCall.getInstance((AttrName)this.valStack[this.stackTop - 3], (List)this.valStack[this.stackTop - 1]);
                break;
            }
            case 52: {
                this.val = FuncCall.getInstance((AttrName)this.valStack[this.stackTop - 2], new ArrayList());
                break;
            }
            case 53: {
                this.val = (Constant)this.valStack[this.stackTop - 0];
                break;
            }
            case 54: {
                this.val = (Constant)this.valStack[this.stackTop - 0];
                break;
            }
            case 55: {
                this.val = (Constant)this.valStack[this.stackTop - 0];
                break;
            }
            case 56: {
                this.val = Constant.TRUE;
                break;
            }
            case 57: {
                this.val = Constant.FALSE;
                break;
            }
            case 58: {
                this.val = Constant.Undef;
                break;
            }
            case 59: {
                this.val = Constant.Error;
                break;
            }
            case 61: {
                this.val = Constant.getInstance(((Constant)this.valStack[this.stackTop - 1]).stringValue() + ((Constant)this.valStack[this.stackTop - 0]).stringValue());
            }
        }
        if (this.tracing) {
            this.trace("Pop " + rhsLength + " state" + (rhsLength == 1 ? "" : "s") + " from stack " + this.showStack());
        }
        this.stackTop -= rhsLength;
        this.state = this.stateStack[this.stackTop];
        short target = lhs[prod];
        if (this.state == 0 && rhsLength == 0) {
            this.trace("Special EOF case: shifting state 16");
            this.state = 16;
        } else {
            int nextState = Parser.tableLookup(gindex, target, this.state);
            if (nextState >= 0) {
                if (this.tracing) {
                    this.trace("Goto(" + this.showStack() + "," + ntname[target] + ") = " + nextState);
                }
                this.state = nextState;
            } else {
                if (this.tracing) {
                    this.trace("DefaultGoto(" + ntname[target] + ") = " + dgoto[target]);
                }
                this.state = dgoto[target];
            }
        }
        this.stateStack[++this.stackTop] = this.state;
        this.valStack[this.stackTop] = this.val;
    }

    public Parser(Reader rdr) {
        this.reader = new LineNumberReader(rdr);
    }

    public Parser(InputStream str) {
        this.reader = new LineNumberReader(new InputStreamReader(str));
    }

    public Parser(String str) {
        this.reader = new LineNumberReader(new StringReader(str));
    }

    public void reset(Reader rdr) {
        this.reader = new LineNumberReader(rdr);
        this.lookahead = -1;
    }

    public void reset(InputStream str) {
        this.reader = new LineNumberReader(new InputStreamReader(str));
        this.lookahead = -1;
    }

    public void reset(String str) {
        this.reader = new LineNumberReader(new StringReader(str));
        this.lookahead = -1;
    }

    public int curLine() {
        if (this.reader == null) {
            return 0;
        }
        return this.reader.getLineNumber();
    }

    public int curColumn() {
        return this.tokenStart + 1;
    }

    private void lexdebug(Object msg) {
        System.out.println("LEX: line " + this.reader.getLineNumber() + " column " + (this.tokenStart + 1) + " " + msg);
    }

    private static int trieAdd(int n, int next) {
        int pos;
        String s = reserved[n];
        char c = s.charAt(0);
        if (trieStart[c] == 0) {
            Parser.trieStart[c] = next;
            Parser.trieStart[Character.toUpperCase((char)c)] = next;
            pos = next;
        } else {
            pos = trieStart[c];
        }
        for (int i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (match[pos] == ' ') {
                Parser.match[pos++] = c;
                continue;
            }
            if (match[pos] == c) {
                ++pos;
                continue;
            }
            Parser.alt[pos] = next;
            pos = next;
            Parser.match[pos++] = c;
        }
        Parser.accept[pos++] = n;
        if (pos > next) {
            next = pos;
        }
        return next;
    }

    private static final boolean isSpace(char c) {
        return c == ' ' || c >= '\t' && c <= '\r';
    }

    public int nextToken() {
        if (this.lookahead < 0) {
            this.lookahead = this.lex();
        }
        return this.lookahead;
    }

    public Object nextValue() {
        if (this.lookahead < 0) {
            this.lookahead = this.lex();
        }
        return this.lval;
    }

    public int getNextToken() {
        if (this.lookahead < 0) {
            this.lookahead = this.lex();
        }
        int result = this.lookahead;
        this.lookahead = -1;
        return result;
    }

    private final int getLine() {
        try {
            this.lineStr = this.reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        if (this.lineStr == null) {
            return 0;
        }
        this.lineLen = this.lineStr.length();
        if (this.line.length < this.lineLen + 1) {
            this.line = new char[this.lineLen + 20];
        }
        this.lineStr.getChars(0, this.lineLen, this.line, 0);
        this.pos = 0;
        this.line[this.lineLen] = 32;
        return 1;
    }

    private final int reservedLookup() {
        int c = this.line[this.tokenStart];
        if (c >= trieStart.length) {
            return 0;
        }
        int triePos = trieStart[c];
        if (triePos++ == 0) {
            return 0;
        }
        int i = this.tokenStart + 1;
        while ((c = this.line[i]) < tolower.length && (c = tolower[c]) != 0) {
            while (match[triePos] != c) {
                if ((triePos = alt[triePos]) != 0) continue;
                return 0;
            }
            ++triePos;
            ++i;
        }
        return accept[triePos];
    }

    private int lex() {
        this.lval = null;
        block9: while (true) {
            int n;
            if (this.pos == this.lineLen || this.line[this.pos] == '/' && this.line[this.pos + 1] == '/') {
                n = this.getLine();
                if (n > 0) continue;
                return n;
            }
            if (this.line[this.pos] == '/' && this.line[this.pos + 1] == '*') {
                this.pos += 2;
                while (true) {
                    if (this.pos >= this.lineLen) {
                        n = this.getLine();
                        if (n <= 0) {
                            return n;
                        }
                        this.pos = -1;
                    } else if (this.pos < this.lineLen - 1 && this.line[this.pos] == '*' && this.line[this.pos + 1] == '/') {
                        this.pos += 2;
                        continue block9;
                    }
                    ++this.pos;
                }
            }
            if (!Parser.isSpace(this.line[this.pos])) break;
            ++this.pos;
        }
        this.tokenStart = this.pos;
        if (Character.isJavaIdentifierStart(this.line[this.pos])) {
            do {
                ++this.pos;
            } while (Character.isJavaIdentifierPart(this.line[this.pos]));
            int i = this.reservedLookup();
            if (i > 0) {
                if (this.tracing) {
                    this.lexdebug("reserved word " + reservedCode[i] + " (" + reserved[i] + ")");
                }
                if (reservedCode[i] == -1) {
                    this.lval = AttrName.PARENT;
                    return 259;
                }
                return reservedCode[i];
            }
            this.lval = AttrName.fromString(new String(this.line, this.tokenStart, this.pos - this.tokenStart));
            if (this.tracing) {
                this.lexdebug("ID(" + this.lval + ")");
            }
            return 259;
        }
        if (Character.isDigit(this.line[this.pos]) || this.line[this.pos] == '.') {
            int type;
            if (this.line[this.pos] == '.' && !Character.isDigit(this.line[this.pos + 1])) {
                ++this.pos;
                if (this.tracing) {
                    this.lexdebug("DOT");
                }
                return 46;
            }
            while (Character.isDigit(this.line[this.pos])) {
                ++this.pos;
            }
            if (this.line[this.pos] == '.') {
                type = 262;
                ++this.pos;
                while (Character.isDigit(this.line[this.pos])) {
                    ++this.pos;
                }
            } else {
                type = 260;
                if (this.line[this.tokenStart] == '0' && (this.line[this.tokenStart + 1] == 'x' || this.line[this.tokenStart + 1] == 'x')) {
                    int digitValue;
                    int value = 0;
                    this.pos = this.tokenStart + 2;
                    while ((digitValue = Character.digit(this.line[this.pos], 16)) >= 0) {
                        value = (value << 4) + digitValue;
                        ++this.pos;
                    }
                    if (this.pos == this.tokenStart + 2) {
                        if (this.tracing) {
                            this.lexdebug("bad number");
                        }
                        this.lval = "hex constant with no digits(" + new String(this.line, this.tokenStart, this.pos - this.tokenStart) + ")";
                        return 261;
                    }
                    this.lval = Constant.getInstance(value);
                    if (this.tracing) {
                        this.lexdebug("INTEGER " + this.lval);
                    }
                    return 260;
                }
            }
            if (this.line[this.pos] == 'e' || this.line[this.pos] == 'E') {
                type = 262;
                ++this.pos;
                if (this.line[this.pos] == '+' || this.line[this.pos] == '-') {
                    ++this.pos;
                }
                if (!Character.isDigit(this.line[this.pos])) {
                    if (this.tracing) {
                        this.lexdebug("bad float");
                    }
                    this.lval = "exponent with no digits(" + new String(this.line, this.tokenStart, this.pos - this.tokenStart) + ")";
                    return 261;
                }
                ++this.pos;
                while (Character.isDigit(this.line[this.pos])) {
                    ++this.pos;
                }
            }
            if (type == 262) {
                this.lval = Constant.getInstance(Double.parseDouble(new String(this.line, this.tokenStart, this.pos - this.tokenStart)));
                if (this.tracing) {
                    this.lexdebug("REAL " + this.lval);
                }
                return 262;
            }
            int value = 0;
            int radix = this.line[this.tokenStart] == '0' ? 8 : 10;
            for (int i = this.tokenStart; i < this.pos; ++i) {
                int digitValue = Character.digit(this.line[i], radix);
                if (digitValue < 0) {
                    if (this.tracing) {
                        this.lexdebug("bad oct");
                    }
                    this.lval = "octal constant with no octal digits(" + new String(this.line, this.tokenStart, this.pos - this.tokenStart) + ")";
                    return 261;
                }
                value = value * radix + digitValue;
            }
            this.lval = Constant.getInstance(value);
            if (this.tracing) {
                this.lexdebug("INT " + this.lval);
            }
            return 260;
        }
        switch (this.line[this.pos++]) {
            case '!': {
                if (this.line[this.pos] != '=') break;
                ++this.pos;
                if (this.tracing) {
                    this.lexdebug("NE");
                }
                return 269;
            }
            case '&': {
                if (this.line[this.pos] != '&') break;
                ++this.pos;
                if (this.tracing) {
                    this.lexdebug("LAND");
                }
                return 267;
            }
            case '<': {
                if (this.line[this.pos] == '<') {
                    ++this.pos;
                    if (this.tracing) {
                        this.lexdebug("SHL");
                    }
                    return 274;
                }
                if (this.line[this.pos] != '=') break;
                ++this.pos;
                if (this.tracing) {
                    this.lexdebug("LE");
                }
                return 272;
            }
            case '=': {
                if (this.line[this.pos] == '=') {
                    ++this.pos;
                    if (this.tracing) {
                        this.lexdebug("EQ");
                    }
                    return 268;
                }
                if (this.line[this.pos] == '?' && this.line[this.pos + 1] == '=') {
                    this.pos += 2;
                    if (this.tracing) {
                        this.lexdebug("IS");
                    }
                    return 270;
                }
                if (this.line[this.pos] != '!' || this.line[this.pos + 1] != '=') break;
                this.pos += 2;
                if (this.tracing) {
                    this.lexdebug("ISNT");
                }
                return 271;
            }
            case '>': {
                if (this.line[this.pos] == '=') {
                    ++this.pos;
                    if (this.tracing) {
                        this.lexdebug("GE");
                    }
                    return 273;
                }
                if (this.line[this.pos] != '>') break;
                ++this.pos;
                if (this.line[this.pos] == '>') {
                    ++this.pos;
                    if (this.tracing) {
                        this.lexdebug("SHRR");
                    }
                    return 276;
                }
                if (this.tracing) {
                    this.lexdebug("SHR");
                }
                return 275;
            }
            case '|': {
                if (this.line[this.pos] != '|') break;
                ++this.pos;
                if (this.tracing) {
                    this.lexdebug("LOR");
                }
                return 266;
            }
            case '\"': 
            case '\'': {
                char quote = this.line[this.pos - 1];
                while (true) {
                    if (this.pos == this.lineLen) {
                        this.lval = "unterminated " + (quote == '\"' ? "string " : "attribute name ") + new String(this.line, this.tokenStart, this.pos - this.tokenStart);
                        return 261;
                    }
                    if (this.line[this.pos] == '\\') {
                        this.pos += 2;
                        continue;
                    }
                    if (this.line[this.pos] == quote) {
                        ++this.pos;
                        break;
                    }
                    ++this.pos;
                }
                if (quote == '\"') {
                    int result = 263;
                    this.lval = Constant.getInstance(this.line, this.tokenStart + 1, this.pos - 1);
                    if (this.lval == null) {
                        this.lval = "invalid string " + new String(this.line, this.tokenStart, this.pos - this.tokenStart);
                        result = 261;
                    }
                    if (this.tracing) {
                        this.lexdebug("STRING(" + this.lval + ")");
                    }
                    return result;
                }
                int result = 259;
                this.lval = AttrName.fromText(new String(this.line, this.tokenStart, this.pos - this.tokenStart));
                if (this.lval == null) {
                    this.lval = "invalid attribute name " + new String(this.line, this.tokenStart, this.pos - this.tokenStart);
                    result = 261;
                }
                if (this.tracing) {
                    this.lexdebug("ID(" + this.lval + ")");
                }
                return result;
            }
        }
        if (this.tracing) {
            this.lexdebug("CHAR('" + this.line[this.pos - 1] + "')");
        }
        return this.line[this.pos - 1];
    }

    private void error(String msg) {
        this.error(msg, true);
    }

    private void error(String msg, boolean lookaheads) {
        if (this.verbosity <= 0) {
            return;
        }
        if (this.verbosity == 1) {
            this.errs.println(msg + " at line " + this.reader.getLineNumber() + " column " + this.tokenStart);
            return;
        }
        this.errs.println(msg + " at line " + this.reader.getLineNumber() + " column " + this.tokenStart + ":");
        if (this.lineStr != null) {
            this.errs.println(this.lineStr);
            for (int i = 0; i < this.tokenStart; ++i) {
                this.errs.print(this.lineStr.charAt(i) == '\t' ? (char)'\t' : ' ');
            }
            this.errs.println("^");
        }
        if (this.verbosity < 3) {
            return;
        }
        if (lookaheads) {
            String emsg;
            int[] valid = this.validTokens(this.state);
            String string = emsg = this.lookahead == 261 ? "" + this.lval : this.tokenName(this.lookahead);
            if (valid.length > 0) {
                this.errs.print("Expecting ");
                for (int i = 0; i < valid.length; ++i) {
                    if (i > 0) {
                        this.errs.print(i == valid.length - 1 ? ", or " : ", ");
                    }
                    this.errs.print(this.tokenName(valid[i]));
                }
                this.errs.println(", but found " + emsg);
            } else {
                this.errs.println("Invalid token " + emsg);
            }
        }
    }

    void printMessage(String msg) {
        if (this.verbosity <= 0) {
            return;
        }
        this.errs.println(msg + " at line " + this.reader.getLineNumber() + " column " + this.tokenStart);
    }

    /*
     * Opcode count of 14121 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        int len = 1;
        for (int i = 1; i < reserved.length; ++i) {
            len += reserved[i].length() + 1;
        }
        trieStart = new int[123];
        match = new char[len];
        alt = new int[len];
        accept = new int[len];
        Arrays.fill(match, ' ');
        int next = 1;
        for (int i = 1; i < reserved.length; ++i) {
            next = Parser.trieAdd(i, next);
        }
        tolower = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 0, 0, 0, 0, 0, 0, 0, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 0, 0, 0, 0, 95, 0, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 0, 0, 0, 0, 0};
    }
}

